<?php

use App\Http\Controllers\Admin\DashboardController as AdminDashboardController;
use App\Http\Controllers\Admin\DynamicContentSetController;
use App\Http\Controllers\Admin\UnoInfoController;
use App\Http\Controllers\FormController;
use App\Http\Controllers\LocalizationController;
use App\Http\Controllers\OfficeOrderController;
use App\Http\Controllers\PageController;
use App\Http\Controllers\PdfController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\UserLoginController;
use App\Http\Controllers\User\ApplicationController;
use App\Http\Controllers\User\DashboardController as UserDashboardController;
use App\Http\Controllers\User\UserLoginController as UserLogin;
use App\Http\Controllers\VerificationController;
use Illuminate\Support\Facades\Route;

Route::get('/', function () {
    return view('index');
})->name('home');

Route::post('application-login', [UserLogin::class, 'login'])->name('application.login');

Route::get('/pdf', [PdfController::class, 'generatePDF']);
Route::get('apply-now', [ApplicationController::class, 'applyNow'])->name('apply-now');
Route::get('user-login', [UserLoginController::class, 'userLogin'])->name('user.login');
Route::get('pages/{value}', [PageController::class, 'pageData'])->name('page.data');
Route::get('trasti-board-member', [PageController::class, 'trastyMember'])->name('trasti-board-member');

Route::get('form-fill-up-nirdesika/{value}', [PageController::class, 'nirdesika'])->name('form.fillUp');
Route::get('office-form', [PageController::class, 'officeForm'])->name('office-form');
Route::get('office-order', [PageController::class, 'officeOrder'])->name('office-order');

Route::get('otp-verification', [VerificationController::class, 'verify'])->name('otp-verification');
Route::post('send-verification-code', [VerificationController::class, 'sendOTP'])->name('send-otp');
Route::get('enter-otp', [VerificationController::class, 'enterOTP'])->name('enter-otp');
Route::post('verify-otp', [VerificationController::class, 'verifyOTP'])->name('verify-otp');
Route::get('resend-otp', [VerificationController::class, 'resendOtp'])->name('resend.otp');

Route::get('brta-login', [UserLoginController::class, 'login'])->name('brta.login');
Route::get('brta-registration', [UserLoginController::class, 'registration'])->name('brta.registration');

Route::get('application-step-one', [ApplicationController::class, 'index'])->name('application-step-one');
Route::get('new-application', [ApplicationController::class, 'newApplication'])->name('new-application');

Route::post('application-store', [ApplicationController::class, 'store'])->name('application.store');
Route::get('download-application-pdf', [ApplicationController::class, 'downloadApplicationPdf'])->name('download-application-pdf');
Route::get('/serve-pdf/{filename}', [ApplicationController::class, 'servePdf'])->name('serve.pdf');
Route::get('/thankyou', function () {
    return view('thankyou');
})->name('thankyou');

Route::get('form-fill-up-nirdesika/{value}', [PageController::class, 'nirdesika'])->name('form.fillUp');

Route::get('download-application-pdf', [ApplicationController::class, 'downloadApplicationPdf'])->name('download-application-pdf');
Route::get('/serve-pdf/{filename}', [ApplicationController::class, 'servePdf'])->name('serve.pdf');
Route::get('/test', function () {
    return view('test');
});

Route::get('/dashboard', function () {
    return view('dashboard');
})->middleware(['auth'])->name('dashboard');

// Admin Routes
Route::middleware(['auth'])->group(function () {
    // Route::get('admin-dashboard', [AdminDashboardController::class, 'index'])->name('admin.dashboard');
    Route::get('dashboard', [AdminDashboardController::class, 'index'])->name('admin.dashboard');
    Route::get('edit-profile', [AdminDashboardController::class, 'editProfile'])->name('edit-profile');


    Route::get('today-applications', [ApplicationController::class, 'todayApplications'])->name('applications.today');
    Route::get('last-week-applications', [ApplicationController::class, 'lastWeekApplications'])->name('applications.last-week');
    Route::get('last-month-applications', [ApplicationController::class, 'lastMonthApplications'])->name('applications.last-month');


    Route::resource('office-orders', OfficeOrderController::class)->except('show');
    Route::resource('office-forms', FormController::class)->except('show');

    Route::get('division-user', [UserController::class, 'division'])->name('admin-user.division');
    Route::get('district-user', [UserController::class, 'district'])->name('admin-user.district');
    Route::get('upozila-user', [UserController::class, 'upozila'])->name('admin-user.upozila');
    Route::get('update-user/{id}', [UserController::class, 'edit'])->name('admin-user.edit');
    Route::put('admin-user/{id}', [UserController::class, 'update'])->name('admin-user.update');

    Route::get('division-user/create', [UserController::class, 'create'])->name('division-user.create');
    Route::get('upozila-user/create', [UserController::class, 'create'])->name('upozila-user.create');
    // Route::post('district-user/create', [UserController::class, 'district'])->name('admin-user.district');
    Route::post('admin-user', [UserController::class, 'store'])->name('admin-user.store');

    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');

    Route::get('uno-information', [UnoInfoController::class, 'index'])->name('uno-information.index');
    Route::get('uno-information/create', [UnoInfoController::class, 'create'])->name('uno-information.create');
    Route::post('uno-information', [UnoInfoController::class, 'store'])->name('uno-information.store');
    Route::get('uno-information/{unoInfo}/edit', [UnoInfoController::class, 'edit'])->name('uno-information.edit');
    Route::put('uno-information/{unoInfo}/update', [UnoInfoController::class, 'update'])->name('uno-information.update');
    Route::delete('uno-information/{unoInfo}', [UnoInfoController::class, 'destroy'])->name('uno-information.destroy');

    Route::get('introduction-en-trasti-board', [DynamicContentSetController::class, 'introductionEngTrastyBoard'])->name('trasty-en-bord-info');

    Route::get('introduction-trasti-board', [DynamicContentSetController::class, 'introductionTrastyBoard'])->name('trasty-bn-board-info');

    Route::Post('introduction-trasti-board', [DynamicContentSetController::class, 'store'])->name('trasti-board.store');

    Route::get('applications', [ApplicationController::class, 'applications'])->name('applications.index');
   
    Route::get('applications-details/{id}', [ApplicationController::class, 'userApplication'])->name('user-applications.show');

    Route::get('documents-add/{value}', [ApplicationController::class, 'documentAdd'])->name('document.add');
    Route::put('documents-add/{value}', [ApplicationController::class, 'update'])->name('application.update');
});

Route::middleware(['auth'])->group(function () {
    Route::get('user-dashboard', [UserDashboardController::class, 'index'])->name('user.dashboard');
    Route::get('application-form', [ApplicationController::class, 'create'])->name('application.create');
});

Route::get('get-districts/{id}', [ApplicationController::class, 'getDistricts']);
Route::get('get-thana/{id}', [ApplicationController::class, 'getThana']);

Route::get('lang/change', [LocalizationController::class, 'change'])->name('changeLang');

require __DIR__ . '/auth.php';
