@extends('layouts.brta-layout')
@section('title', 'BRTA')
@section('content')
<div class="container">
    <div class="row justify-content-center align-items-center" style="height: 100%">
        <div class="col-lg-6">
            <div class="card">
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif

                    @if(session('error'))
                        <div class="alert alert-danger">
                            {{ session('error') }}
                        </div>
                    @endif
                    <form method="POST" action="{{ route('verify-otp') }}" onsubmit="disableSubmitButton(this)">
                        @csrf
                        <div class="form-group">
                            <label for="otp">{{ __('messages.OTP') }} <span class="text-danger">*</span></label>
                            <input type="number" name="otp" class="form-control" placeholder="please enter otp"
                                required>
                            @error('otp')
                            <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="my-2">
                            <a class="text-decoration-none" href="{{ route('resend.otp') }}">{{ __('messages.ResendOtp') }}</a>
                        </div>

                        <button type="submit" class="btn btn-primary">Submit</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function disableSubmitButton(form) {
    const submitButton = form.querySelector('button[type="submit"]');
    submitButton.disabled = true;
    submitButton.innerText = 'Processing...';
}
</script>

@endsection