@extends('layouts.brta-layout')
@section('title', 'BRTA')
@section('content')

<div class="container g-0">
    <div class="col-lg-12 mb-4">
        <div class="se-btn text-center">
            <h4 class="text-center text-white">দুর্ঘটনার ক্ষতি পূরণ সংক্রান্ত আর্থিক সহায়তা তহবিল হইতে আর্থিক সহায়তা
                প্রাপ্তির
                আবেদন </h4>
        </div>
    </div>
</div>
<div class="container g-0">
    <div class="card">
        <div class="card-body">
            <form method="POST" action="{{ route('application.store') }}" onsubmit="disableSubmitButton()"
                enctype="multipart/form-data">
                @csrf

                <!-- Step 1 -->
                <div class="step active">
                    <div class="form-group">
                        <label for="victim_name">দুর্ঘটনায় ক্ষতিগ্রস্ত ব্যক্তির নাম: <span class="text-danger">*</span>
                        </label>
                        <input type="text" name="victim_name" class="form-control" value="{{ old('victim_name') }}"
                            required>
                        @error('victim_name')
                        <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="form-group">
                        <label for="father_husband_name">পিতা/স্বামী/স্ত্রীর নাম: <span class="text-danger">*</span>
                        </label>
                        <input type="text" name="father_husband_name" class="form-control"
                            value="{{ old('father_husband_name') }}" required>
                        @error('father_husband_name')
                        <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="form-group">
                        <label for="mother_name">মাতার নাম: <span class="text-danger">*</span> </label>
                        <input type="text" name="mother_name" class="form-control" value="{{ old('mother_name') }}"
                            required>
                        @error('mother_name')
                        <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="form-group">
                        <label for="applicant_name">মৃত ব্যক্তির ক্ষেত্রে আবেদনকারীর নাম: <span
                                class="text-danger">*</span>
                        </label>
                        <input type="text" name="applicant_name" class="form-control"
                            value="{{ old('applicant_name') }}" required>
                        @error('applicant_name')
                        <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="form-group">
                        <label for="relation_with_deceased">আবেদনকারীর সাথে মৃত ব্যক্তির সম্পর্ক: <span
                                class="text-danger">*</span> </label>
                        <input type="text" name="relation_with_deceased" class="form-control"
                            value="{{ old('relation_with_deceased') }}" required>
                        @error('relation_with_deceased')
                        <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>
                </div>

                <!-- Step 2 -->
                <div class="step">
                    <div class="form-group">
                        <label for="victim_birthdate">দুর্ঘটনায় ক্ষতিগ্রস্ত ব্যক্তির জন্ম তারিখ: <span
                                class="text-danger">*</span> </label>
                        <input type="date" name="victim_birthdate" class="form-control"
                            value="{{ old('victim_birthdate') }}" required>
                        @error('victim_birthdate')
                        <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="form-group">
                        <label for="national_id">জাতীয় পরিচয়পত্রের নম্বর: <span class="text-danger">*</span> </label>
                        <input type="number" name="national_id" class="form-control" value="{{ old('national_id') }}"
                            required>
                        @error('national_id')
                        <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="form-group">
                        <label for="driving_license">ড্রাইভিং লাইসেন্স নম্বর (চালকের ক্ষেত্রে) ও মেয়াদ: </label>
                        <input type="text" name="driving_license" class="form-control"
                            value="{{ old('driving_license') }}">
                        @error('driving_license')
                        <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="form-group">
                        <label for="address">ঠিকানা: <span class="text-danger">*</span> </label>
                        <input type="text" name="address" class="form-control" value="{{ old('address') }}" required>
                        @error('address')
                        <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>

                </div>

                <!-- Step 3 -->
                <div class="step">
                    <div class="form-group">
                        <label for="accident_description">দুর্ঘটনার স্থানসহ বিবরণ: <span class="text-danger">*</span>
                        </label>
                        <textarea class="form-control" name="accident_description"
                            required>{{ old('accident_description') }}</textarea>
                        @error('accident_description')
                        <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="form-group">
                        <label for="accident_date_time">দুর্ঘটনার তারিখ ও সময়: <span class="text-danger">*</span>
                        </label>
                        <input type="datetime-local" name="accident_date_time" class="form-control"
                            value="{{ old('accident_date_time') }}" required>

                        @error('accident_date_time')
                        <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="form-group">
                        <label for="case_dd_number">দুর্ঘটনার মামলার ডিডি নম্বর: <span class="text-danger">*</span>
                        </label>
                        <input type="text" name="case_dd_number" value="{{ old('case_dd_number') }}"
                            class="form-control" required>
                        @error('case_dd_number')
                        <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="form-group">
                        <label for="death_date">মৃত ব্যক্তির ক্ষেত্রে মৃত্যুর তারিখ (মৃত্যু সনদ সংযুক্ত): <span
                                class="text-danger">*</span> </label>
                        <input type="date" name="death_date" value="{{ old('death_date') }}" class="form-control"
                            required>
                        @error('death_date')
                        <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="form-group">
                        <label for="total_expense">মোট খরচের পরিমাণ (প্রমাণসহ): <span class="text-danger">*</span>
                        </label>
                        <input type="number" name="total_expense" value="{{ old('total_expense') }}"
                            class="form-control" required>
                        @error('total_expense')
                        <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="form-group">
                        <label for="current_address">বর্তমান ঠিকানা: <span class="text-danger">*</span> </label>
                        <input type="text" name="current_address" value="{{ old('current_address') }}"
                            class="form-control" required>
                        @error('current_address')
                        <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="form-group">
                        <label for="fund_aid">আর্থিক সহায়তা তহবিল হইতে গত /চলতি বছরে পাইয়া থাকিলে অনুদান প্রাপ্তির খাতের
                            নাম ও
                            টাকার
                            পরিমান: <span class="text-danger">*</span> </label>
                        <input type="text" name="fund_aid" value="{{ old('fund_aid') }}" class="form-control" required>
                        @error('fund_aid')
                        <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>
                </div>

                <!-- Step 4 (Final step) -->
                <div class="step">

                    <div class="form-group">
                        <label for="exampleInputEmail1">হাসপাতালের মেডিকেল সার্টিফিকেট: <span
                                class="text-danger">*</span>
                        </label>
                        <input type="file" name="medical_certificate" class="form-control" required>
                        @error('medical_certificate')
                        <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="form-group">
                        <label for="exampleInputEmail1">সংশ্লিষ্ট এলাকার মৃত্যু সনদ: <span class="text-danger">*</span>
                        </label>
                        <input type="file" name="death_certificate" class="form-control" required>
                        @error('medical_certificate')
                        <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="form-group">
                        <label for="exampleInputEmail1">ক্ষতিগ্রস্ত ব্যক্তির ড্রাইভিং লাইসেন্স: (Optional) </label>
                        <input type="file" name="victim_driving_license" class="form-control" required>
                    </div>

                    <div class="form-group">
                        <label for="exampleInputEmail1">ওয়ারিশ সনদ: <span class="text-danger">*</span> </label>
                        <input type="file" name="warish_sonod" class="form-control" required>
                        @error('warish_sonod')
                        <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="form-group">
                        <label for="exampleInputEmail1">ক্ষতিগ্রস্ত ব্যক্তির জন্ম সনদ: <span
                                class="text-danger">*</span>
                        </label>
                        <input type="file" name="victim_birth_certificate" class="form-control" required>
                        @error('victim_birth_certificate')
                        <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="form-group">
                        <label for="exampleInputEmail1">আবেদনকারীর এন আইডি: <span class="text-danger">*</span> </label>
                        <input type="file" name="applicant_nid" class="form-control" required>
                        @error('applicant_nid')
                        <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="form-group">
                        <label for="exampleInputEmail1">আবেদনকারীর জন্ম সনদ: <span class="text-danger">*</span> </label>
                        <input type="file" name="applicant_birth_certificate" class="form-control" required>
                        @error('applicant_birth_certificate')
                        <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="form-group">
                        <label for="exampleInputEmail1">ক্ষতিগ্রস্ত ব্যক্তির এন আইডি: <span class="text-danger">*</span>
                        </label>
                        <input type="file" name="victim_nid" class="form-control" required>
                        @error('victim_nid')
                        <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="form-group">
                        <label for="exampleInputEmail1">৩০০ টাকার নন-জুডিশিয়াল স্ট্যাম্পে অর্থ উত্তোলনের
                            ক্ষমতাপত্র: <span class="text-danger">*</span> </label>
                        <input type="file" name="non_judicial_stamp" class="form-control" required>
                        @error('non_judicial_stamp')
                        <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="form-group">
                        <label for="exampleInputEmail1">আবেদনকারীর স্বাক্ষর : <span class="text-danger">*</span>
                        </label>
                        <input type="file" name="applicant_signature" class="form-control" required>
                        @error('applicant_signature')
                        <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>
                </div>

                <!-- Navigation buttons -->
                <div class="step-buttons">
                    <button type="button" class="btn btn-primary" id="prevBtn" onclick="nextPrev(-1)">Previous</button>
                    <button type="button" class="btn btn-primary" id="nextBtn" onclick="nextPrev(1)">Next</button>
                    <button type="submit" class="btn btn-success" id="submitBtn">Submit</button>
                </div>

            </form>
        </div>
    </div>
</div>

@endsection

@push('scripts')
<script>
var currentStep = 0;
showStep(currentStep);

function showStep(n) {
    var steps = document.getElementsByClassName("step");
    steps[n].classList.add("active");

    // Update the buttons visibility
    if (n == 0) {
        document.getElementById("prevBtn").style.display = "none";
    } else {
        document.getElementById("prevBtn").style.display = "inline";
    }
    if (n == (steps.length - 1)) {
        document.getElementById("nextBtn").style.display = "none";
        document.getElementById("submitBtn").style.display = "inline";
    } else {
        document.getElementById("nextBtn").style.display = "inline";
        document.getElementById("submitBtn").style.display = "none";
    }
}

function nextPrev(n) {
    // Prevent moving to the next step if validation fails
    if (n == 1 && !validateForm()) return false;

    var steps = document.getElementsByClassName("step");
    steps[currentStep].classList.remove("active");
    currentStep = currentStep + n;
    showStep(currentStep);
}

// Function to validate the form in the current step
function validateForm() {
    var steps = document.getElementsByClassName("step");
    var inputs = steps[currentStep].getElementsByTagName("input");
    var textareas = steps[currentStep].getElementsByTagName("textarea");
    var valid = true;

    // Loop through all input fields in the current step and check if they are filled
    for (var i = 0; i < inputs.length; i++) {
        if (inputs[i].hasAttribute('required') && inputs[i].value === "") {
            inputs[i].classList.add('is-invalid');
            valid = false;
        } else {
            inputs[i].classList.remove('is-invalid');
        }
    }

    // Loop through textareas as well
    for (var i = 0; i < textareas.length; i++) {
        if (textareas[i].hasAttribute('required') && textareas[i].value === "") {
            textareas[i].classList.add('is-invalid');
            valid = false;
        } else {
            textareas[i].classList.remove('is-invalid');
        }
    }

    return valid;
}

function disableSubmitButton() {
    document.getElementById("submitBtn").disabled = true;
}
</script>

@endpush