@extends('layouts.brta-layout')
@section('title', 'BRTA')
@section('content')
    <div class="container g-0">
        <div class="col-lg-12 mb-4">
            <div class="se-btn text-center">
                <h4 class="text-center text-white">
                    {{ __('messages.FinancialAssistance') }}
                </h4>
            </div>
        </div>
    </div>

    <div class="container g-0">
        <div class="card">
            <div class="card-body">
                <form method="POST" action="{{ route('application.store') }}" onsubmit="disableSubmitButton()"
                    enctype="multipart/form-data">
                    @csrf

                    <!-- Step 1 -->
                    <div class="step active">

                        <div class="form-group mb-3">
                            <label for="victim_name">{{ __('messages.InjuredPersonName') }}: <span
                                    class="text-danger">*</span>
                            </label>
                            <input type="text" name="victim_name" class="form-control" value="{{ old('victim_name') }}"
                                required>
                            @error('victim_name')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="form-group mb-3">

                            <p class="mb-0" for="">{{ __('messages.Father') }}/{{ __('messages.Husband') }}/{{ __('messages.Wifes') }}{{' ' . __('messages.Name')}}:</p>
                            <input type="radio" checked name="relation" value="father" id="father" required> <label
                                for="father" class="me-3"> {{ __('messages.Father') }}</label>
                            <input type="radio" name="relation" value="husband" id="husband" required> <label
                                for="husband" class="me-3"> {{ __('messages.Husband') }}</label>
                            <input type="radio" name="relation" value="husewife" id="husewife" required> <label
                                for="husewife"> {{ __('messages.Wife') }}</label>

                            <input type="text" name="father_husband_name" class="form-control"
                                value="{{ old('father_husband_name') }}" required>

                            @error('father_husband_name')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <div class="form-group">
                                    <label for="mother_name">{{ __('messages.MotherName') }} {{ __('messages.Name') }}:
                                        <span class="text-danger">*</span>
                                    </label>
                                    <input type="text" name="mother_name" class="form-control"
                                        value="{{ old('mother_name') }}" required>
                                    @error('mother_name')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6 mb-3">
                                <div class="form-group">
                                    <label for="applicant_name">{{ __('messages.ApplicantDeceasedName') }}
                                        {{ __('messages.Name') }}:</label>
                                    <input type="text" name="applicant_name" class="form-control"
                                        value="{{ old('applicant_name') }}">
                                </div>
                            </div>
                            <div class="col-md-12  mb-3">
                                <div class="form-group">
                                    <label for="relation_with_deceased">{{ __('messages.RelationshipApplicantDeceased') }}:
                                    </label>
                                    <input type="text" name="relation_with_deceased" class="form-control"
                                        value="{{ old('relation_with_deceased') }}">
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <div class="form-group">
                                    <label for="victim_birthdate">{{ __('messages.AffectedPersonAge') }}:</label>
                                    <input type="date" name="victim_birthdate" class="form-control"
                                        value="{{ old('victim_birthdate') }}">
                                </div>
                            </div>
                            <div class="col-md-6 mb-3">
                                <div class="form-group">
                                    <label for="victim_birth_certificate">{{ __('messages.BirthCertificate') }}: </label>
                                    <input type="file" name="victim_birth_certificate" class="form-control"
                                        accept="image/*">
                                    @error('victim_birth_certificate')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-6 mb-3">
                                <div class="form-group">
                                    <label for="national_id">{{ __('messages.NID') }}: <span class="text-danger">*</span>
                                    </label>
                                    <input type="number" name="national_id" class="form-control"
                                        value="{{ old('national_id') }}" required>
                                    @error('national_id')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-6 mb-3">
                                <div class="form-group">
                                    <label for="applicant_nid">{{ __('messages.NIDImage') }}: </label>
                                    <input type="file" name="applicant_nid" class="form-control" accept="image/*">
                                    @error('applicant_nid')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-6 mb-3">
                                <div class="form-group">
                                    <label for="driving_license">{{ __('messages.DrivingLicenseNumber') }}: </label>
                                    <input type="text" name="driving_license" class="form-control"
                                        value="{{ old('driving_license') }}">
                                </div>
                            </div>

                            <div class="col-md-6 mb-3">
                                <div class="form-group">
                                    <label for="victim_driving_license">{{ __('messages.DrivingLicense') }}:
                                    </label>
                                    <input type="file" name="victim_driving_license" class="form-control"
                                        accept="image/*">
                                </div>
                            </div>

                            <div class="col-md-6 mb-3">
                                <div class="form-group">
                                    <label for="division_id">{{ __('messages.Division') }}:<span
                                            class="text-danger">*</span>
                                    </label>

                                    <select name="division_id" id="select_division" class="form-control" required>
                                        <option value="">{{ __('messages.SelectDivision') }}</option>
                                        @foreach ($division as $d_data)
                                            <option value="{{ $d_data->id }}">{{ $d_data->bn_name }}</option>
                                        @endforeach
                                    </select>

                                    @error('division_id')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6 mb-3">
                                <div class="form-group">
                                    <label for="district_id">{{ __('messages.Districts') }}:<span
                                            class="text-danger">*</span>
                                    </label>

                                    <select name="district_id" id="select_district" class="form-control" required>
                                        <option value="">{{ __('messages.SelectDistricts') }}</option>
                                    </select>

                                    @error('district_id')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="upozila_id">{{ __('messages.Upozila') }}:<span
                                            class="text-danger">*</span>
                                    </label>

                                    <select name="upozila_id" id="select_upozila" class="form-control" required>
                                        <option value="">{{ __('messages.SelectUpozila') }}</option>
                                    </select>

                                    @error('upozila_id')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="address">{{ __('messages.Address') }}:
                                    </label>
                                    <input type="text" name="address" class="form-control"
                                        value="{{ old('address') }}">
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Step 2 -->
                    <div class="step">
                        <div class="row">
                            <div class="col-md-12 mb-4">
                                <div class="form-group">
                                    <label for="accident_description">{{ __('messages.AccidentPlaceDetails') }}: <span
                                            class="text-danger">*</span>
                                    </label>
                                    <textarea class="form-control" name="accident_description" required>{{ old('accident_description') }}</textarea>
                                    @error('accident_description')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6 mb-4">
                                <div class="form-group">
                                    <label for="case_dd_number">{{ __('messages.AccidentGDNumber') }}:
                                    </label>
                                    <input type="text" name="case_dd_number" value="{{ old('case_dd_number') }}"
                                        class="form-control">
                                    @error('case_dd_number')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-6 mb-4">
                                <div class="form-group">
                                    <label for="gd_stamp">{{ __('messages.AccidentGDImage') }}:
                                    </label>
                                    <input type="file" name="gd_stamp" class="form-control" accept="image/*">
                                    @error('gd_stamp')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6 mb-4">
                                <div class="form-group">
                                    <label for="death_date">{{ __('messages.DeceasedDate') }}: </label>
                                    <input type="date" name="death_date" value="{{ old('death_date') }}"
                                        class="form-control">
                                    @error('death_date')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6 mb-4">
                                <div class="form-group">
                                    <label for="death_certificate">{{ __('messages.DeathCertificate') }}: </label>
                                    <input type="file" name="death_certificate" class="form-control" accept="image/*">
                                    @error('death_certificate')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-12 mb-4">
                                <div class="form-group">
                                    <label for="sick_short_details">{{ __('messages.SummaryTreatment') }}:
                                    </label>
                                    <input type="text" name="sick_short_details" value="{{ old('sick_short_details') }}"
                                        class="form-control">
                                    @error('sick_short_details')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6 mb-4">
                                <div class="form-group">
                                    <label for="total_expense">{{ __('messages.TotalCost') }}:
                                    </label>
                                    <input type="number" name="total_expense" value="{{ old('total_expense') }}"
                                        class="form-control">
                                    @error('total_expense')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6 mb-4">
                                <div class="form-group">
                                    <label for="medical_certificate">{{ __('messages.MedicalCertificate') }}: </label>
                                    <input type="file" name="medical_certificate" class="form-control" accept="image/*">
                                    @error('medical_certificate')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6 mb-4">
                                <div class="form-group">
                                    <label for="current_address">{{ __('messages.PresentAddress') }}: </label>
                                    <input type="text" name="current_address" value="{{ old('current_address') }}"
                                        class="form-control">
                                    @error('current_address')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-12 mb-4">
                                <div class="form-group">
                                    <label for="fund_aid">{{ __('messages.FinancialAssistanceFund') }}: </label>
                                    <input type="text" name="fund_aid" value="{{ old('fund_aid') }}" class="form-control">
                                    @error('fund_aid')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6 mb-4">
                                <div class="form-group">
                                    <label for="applicant_signature">{{ __('messages.ApplicantSignature') }} : </label>
                                    <input type="file" name="applicant_signature" class="form-control" accept="image/*">
                                    @error('applicant_signature')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group">
                                    <input id="ullikhito_value" type="checkbox" name="ul" id="" required>
                                    <label for="ullikhito_value">
                                        {{ __('messages.ConcealedNotBelief') }}
                                    </label>
        
                                    @error('ullikhito_value')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Navigation buttons -->
                    <div class="step-buttons">
                        <button type="button" class="btn btn-primary" id="prevBtn"
                            onclick="nextPrev(-1)">{{ __('messages.Previous') }}</button>
                        <button type="button" class="btn btn-primary" id="nextBtn"
                            onclick="nextPrev(1)">{{ __('messages.Next') }}</button>
                        <button type="submit" class="btn btn-success"
                            id="submitBtn">{{ __('messages.Submit') }}</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script src="https://cdnjs.cloudflare.com/ajax/libs/axios/1.7.7/axios.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script>
        $('#select_division').on('change', function() {
            let value = $(this).val();
            var selectDistrictText = "{{ __('messages.SelectDistricts') }}"; // Get translated text
            $('#select_district').empty();
            $('#select_district').append(`<option value="">${selectDistrictText}</option>`); // Use translated text

            axios.get('/get-districts/' + value).then(res => {
                let data = res.data;
                data.map(item => {
                    $('#select_district').append(
                        `<option value="${item.id}">${item.bn_name}</option>`
                    );
                });
            });
        });


        $('#select_district').on('change', function() {
            let value = $(this).val();
            $('#select_upozila').empty()

            axios.get('/get-thana/' + value).then(res => {
                let data = res.data
                data.map(item => {
                    $('#select_upozila').append(
                        `<option value="${item.id}">${item.bn_name}</option>`)
                })
            })
        })
    </script>

    <script>
        var currentStep = 0;
        showStep(currentStep);

        function showStep(n) {
            var steps = document.getElementsByClassName("step");
            steps[n].classList.add("active");

            // Update the buttons visibility
            if (n == 0) {
                document.getElementById("prevBtn").style.display = "none";
            } else {
                document.getElementById("prevBtn").style.display = "inline";
            }
            if (n == (steps.length - 1)) {
                document.getElementById("nextBtn").style.display = "none";
                document.getElementById("submitBtn").style.display = "inline";
            } else {
                document.getElementById("nextBtn").style.display = "inline";
                document.getElementById("submitBtn").style.display = "none";
            }
        }

        function nextPrev(n) {
            // Prevent moving to the next step if validation fails
            if (n == 1 && !validateForm()) return false;

            var steps = document.getElementsByClassName("step");
            steps[currentStep].classList.remove("active");
            currentStep = currentStep + n;
            showStep(currentStep);
        }

        // Function to validate the form in the current step
        function validateForm() {
            var steps = document.getElementsByClassName("step");
            var inputs = steps[currentStep].getElementsByTagName("input");
            var textareas = steps[currentStep].getElementsByTagName("textarea");
            var selects = steps[currentStep].getElementsByTagName("select");
            var valid = true;

            const optionalFields = [
                'applicant_name', 'relation_with_deceased', 'address',
                'driving_license', 'victim_birthdate', 'victim_driving_license', 'case_dd_number', 'death_date',
                'total_expense', 'current_address',
                'fund_aid', 'medical_certificate', 'death_certificate',
                'victim_driving_license', 'warish_sonod', 'victim_birth_certificate',
                'applicant_nid', 'applicant_birth_certificate', 'victim_nid',
                'non_judicial_stamp', 'applicant_signature'
            ];


            // Loop through all input fields in the current step and check if they are filled
            for (var i = 0; i < inputs.length; i++) {
                const input = inputs[i];
                if (optionalFields.includes(input.name) && input.value === "") {
                    continue; // Skip validation for these fields
                }

                if (inputs[i].hasAttribute('required') && inputs[i].value === "") {
                    inputs[i].classList.add('is-invalid');
                    valid = false;
                } else {
                    inputs[i].classList.remove('is-invalid');
                }
            }

            // Loop through textareas as well
            for (var i = 0; i < textareas.length; i++) {
                if (textareas[i].hasAttribute('required') && textareas[i].value === "") {
                    textareas[i].classList.add('is-invalid');
                    valid = false;
                } else {
                    textareas[i].classList.remove('is-invalid');
                }
            }

            // Loop through textareas as well
            for (var i = 0; i < selects.length; i++) {
                if (selects[i].hasAttribute('required') && selects[i].value === "") {
                    selects[i].classList.add('is-invalid');
                    valid = false;
                } else {
                    selects[i].classList.remove('is-invalid');
                }
            }

            return valid;
        }

        function disableSubmitButton() {
            document.getElementById("submitBtn").disabled = true;
        }
    </script>
@endpush
