@extends('layouts.brta-layout')
@section('title', 'BRTA')
@section('content')

    <div class="container g-0">
        <div class="col-lg-12 mb-4">
            <div class="se-btn text-center">
                <h4 class="text-center text-white">{{ __('messages.FinancialAssistance') }} </h4>
            </div>
        </div>
    </div>
    <div class="container g-0">
        <div class="card">
            <div class="card-body">
                @if (Session::has('error'))
                    <div class="alert alert-warning alert-dismissible fade show" role="alert">
                        <strong>{{ Session::get('error') }}</strong>
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                @endif

                <form method="POST" action="{{ route('send-otp') }}" enctype="multipart/form-data"
                    onsubmit="disableSubmitButton()">
                    @csrf

                    <!-- Step 1 -->
                    <div class="form-group mb-2">
                        <label for="accident_date_time">{{ __('messages.AccidentDateTime') }}: <span
                                class="text-danger">*</span>
                        </label>
                        <input type="datetime-local" name="accident_date_time" class="form-control"
                            value="{{ old('accident_date_time') }}" required>

                        @error('accident_date_time')
                            <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="form-group mb-3">
                        <label for="applicant_name">{{ __('messages.ApplicantName') }} : <span class="text-danger">*</span>
                        </label>
                        <input type="text" name="applicant_name" class="form-control" value="{{ old('applicant_name') }}"
                            required>
                        @error('applicant_name')
                            <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="form-group mb-3">
                        <label for="applicant_phone">{{ __('messages.ApplicantMobile') }} : <span
                                class="text-danger">*</span>
                        </label>
                        <input type="text" name="applicant_phone" class="form-control"
                            value="{{ old('applicant_phone') }}" required>
                        @error('applicant_phone')
                            <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>

                    <!-- Navigation buttons -->
                    <div class="buttons">
                        <button type="submit" class="btn btn-success" id="submitBtn">Submit</button>
                    </div>

                </form>
            </div>
        </div>
    </div>

@endsection

@push('scripts')
    <script>
        function disableSubmitButton() {
            document.getElementById("submitBtn").disabled = true;
        }
    </script>
@endpush
