@extends('layouts.brta-layout')
@section('title', 'BRTA')
@section('content')

<h1>Thank You!</h1>
<p>Your PDF has been download successfully.</p>

@endsection

@push('scripts')
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script type="text/javascript">
$(document).ready(function() {
    // Trigger the AJAX request to download the PDF
    var filename = "{{ $filename }}";

    $.ajax({
        url: '/serve-pdf/' + filename,
        method: 'GET',
        xhrFields: {
            responseType: 'blob'
        },
        success: function(data) {
            var link = document.createElement('a');
            link.href = window.URL.createObjectURL(data);
            link.download = filename;
            link.click();
        },
        error: function(xhr, status, error) {
            alert('Error downloading the PDF.');
        }
    });
});
</script>
@endpush