@extends('layouts.brta-layout')

@section('title', 'Login')
@section('content')
    <div class="row justify-content-center">
        <div class="col-md-5">
            <div class="card mt-5">
                <div class="card-body">
                    <h3 class="card-title text-center mb-4">Registration</h3>
                    <form action="{{ route('register') }}" method="post">
                        @csrf
                        <div class="mb-4">
                            <label for="name" class="form-label">Name</label>
                            <input type="text" name="name" class="form-control" id="name"
                                placeholder="Enter name">
                            @error('name')
                                <p class="position-absolute text-danger"><small>{{ $message }}</small></p>
                            @enderror
                        </div>
                        <div class="mb-4">
                            <label for="email" class="form-label">Email</label>
                            <input type="email" name="email" class="form-control" id="email"
                                placeholder="Enter email">
                            @error('email')
                                <p class="position-absolute text-danger"><small>{{ $message }}</small></p>
                            @enderror
                        </div>
                        <div class="mb-4">
                            <label for="phone" class="form-label">Phone</label>
                            <input type="numeric" name="phone" class="form-control" id="phone"
                                placeholder="Enter phone">
                            @error('phone')
                                <p class="position-absolute text-danger"><small>{{ $message }}</small></p>
                            @enderror
                        </div>

                        <div class="mb-4">
                            <label for="password" class="form-label">Password</label>
                            <input type="password" name="password" class="form-control" id="password"
                                placeholder="Password">
                            @error('password')
                                <p class="position-absolute text-danger"><small>{{ $message }}</small></p>
                            @enderror
                        </div>

                        <div class="mb-4">
                            <label for="password_confirmation" class="form-label">Confirm Password</label>
                            <input type="password" name="password_confirmation" class="form-control"
                                id="password_confirmation" placeholder="Confirm Password">
                            {{-- @error('password_confirmation')
                                <p class="position-absolute text-danger"><small>{{ $message }}</small></p>
                            @enderror --}}
                        </div>
                        <button type="submit" class="btn text-white w-100 mb-4"
                            style="  background-color: #501784;">Submit</button>
                        <p>Already have an account? <a href="{{ route('brta.login') }}">Login</a></p>
                    </form>
                </div>
            </div>

        </div>
    </div>
@endsection
