<!doctype html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>BRTA PDF</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
    <style>
    .bangla-text {
        font-family: 'solaiman_lipi', Arial, sans-serif !important;
    }

    body {
        font-family: Arial, sans-serif !important;
    }
    </style>
</head>

<body>

    <div class="container py-5">
        <div class="row">
            <div class="col-lg-12">
                <h6 class="text-center py-2 bangla-text" style="background: blueviolet; font-size:20px;  color:white; font-weight:700">
                    দুর্ঘটনার ক্ষতি
                    পূরণ সংক্রান্ত আর্থিক সহায়তা তহবিল হইতে আর্থিক সহায়তা
                    প্রাপ্তির
                    আবেদন </h6>
                <table class="table pdfTable">
                    <tbody>
                        <tr>
                            <td class="bangla-text">আবেদনের ট্র্যাকিং নম্বর</td>
                            <td class="{{ containsBangla($invoice?->reference_number) ? 'bangla-text' : 'eng-text' }}">
                                #{{ $invoice?->reference_number }}
                            </td>
                        </tr>
                        <tr>
                            <td class="pdfTable bangla-text">দুর্ঘটনায় ক্ষতিগ্রস্ত ব্যক্তির নাম</td>
                            <td class="{{ containsBangla($invoice?->victim_name) ? 'bangla-text' : 'eng-text' }}">
                                {{ $invoice?->victim_name }}</td>
                        </tr>
                        <tr>
                            <td class="pdfTable bangla-text">
                                @if ($invoice?->relation == 'husband')
                                স্বামী
                                @elseif ($invoice?->relation == 'husewife')
                                স্ত্রীর
                                @elseif ($invoice?->relation == 'father')
                                পিতা
                                @endif
                                নাম
                            </td>
                            <td
                                class="{{ containsBangla($invoice?->father_husband_name) ? 'bangla-text' : 'eng-text' }}">
                                {{ $invoice?->father_husband_name }}</td>
                        </tr>
                        <tr>
                            <td class="pdfTable bangla-text">মাতার নাম</td>
                            <td class="{{ containsBangla($invoice?->mother_name) ? 'bangla-text' : 'eng-text' }}">
                                {{ $invoice?->mother_name }}</td>
                        </tr>
                        <tr>
                            <td class="pdfTable bangla-text">মৃত ব্যক্তির ক্ষেত্রে আবেদনকারীর নাম</td>
                            <td class="{{ containsBangla($invoice?->applicant_name) ? 'bangla-text' : 'eng-text' }}">
                                {{ $invoice?->applicant_name }}</td>
                        </tr>
                        <tr>
                            <td class="pdfTable bangla-text">আবেদনকারীর সহিত মৃত ব্যক্তির সম্পর্ক</td>
                            <td
                                class="{{ containsBangla($invoice?->relation_with_deceased) ? 'bangla-text' : 'eng-text' }}">
                                {{ $invoice?->relation_with_deceased }}</td>
                        </tr>
                        <tr>
                            <td class="pdfTable bangla-text">দুর্ঘটনায় কবলিত ব্যক্তির জন্ম তারিখ/বয়স</td>
                            <td class="{{ containsBangla($invoice?->victim_birthdate) ? 'bangla-text' : 'eng-text' }}">
                                {{ $invoice?->victim_birthdate }}</td>
                        </tr>
                        <tr>
                            <td class="pdfTable bangla-text">জাতীয় পরিচয়পত্রের নম্বর</td>
                            <td class="{{ containsBangla($invoice?->national_id) ? 'bangla-text' : 'eng-text' }}">
                                {{ $invoice?->national_id }}</td>
                        </tr>
                        <tr>
                            <td class="pdfTable bangla-text">ড্রাইভিং লাইসেন্স নম্বর (চালকের ক্ষেত্রে) ও মেয়াদ</td>
                            <td class="{{ containsBangla($invoice?->driving_license) ? 'bangla-text' : 'eng-text' }}">
                                {{ $invoice?->driving_license }}</td>
                        </tr>
                        <tr>
                            <td class="pdfTable bangla-text">ঠিকানা</td>
                            <td class="{{ containsBangla($invoice?->address) ? 'bangla-text' : 'eng-text' }}">
                                {{ $invoice?->address }}</td>
                        </tr>
                        <tr>
                            <td class="pdfTable bangla-text">আবেদনকারীর মোবাইল নাম্বার</td>
                            <td class="{{ containsBangla($invoice?->phone) ? 'bangla-text' : 'eng-text' }}">
                                {{ $invoice?->phone }}</td>
                        </tr>
                        <tr>
                            <td class="pdfTable bangla-text">দুর্ঘটনার স্থানসহ বিবরণ</td>
                            <td
                                class="{{ containsBangla($invoice?->accident_description) ? 'bangla-text' : 'eng-text' }}">
                                {{ $invoice?->accident_description }}</td>
                        </tr>
                        <tr>
                            <td class="pdfTable bangla-text">দুর্ঘটনার তারিখ ও সময়</td>
                            <td
                                class="{{ containsBangla($invoice?->accident_date_time) ? 'bangla-text' : 'eng-text' }}">
                                {{ $invoice?->accident_date_time }}</td>
                        </tr>
                        <tr>
                            <td class="pdfTable bangla-text">দুর্ঘটনার মামলার জিডি নম্বর</td>
                            <td class="{{ containsBangla($invoice?->case_dd_number) ? 'bangla-text' : 'eng-text' }}">
                                {{ $invoice?->case_dd_number }}</td>
                        </tr>
                        <tr>
                            <td class="pdfTable bangla-text">মৃত ব্যক্তির ক্ষেত্রে মৃত্যুর তারিখ (মৃত্যু সনদ সংযুক্ত)
                            </td>
                            <td class="{{ containsBangla($invoice?->death_date) ? 'bangla-text' : 'eng-text' }}">
                                {{ $invoice?->death_date }}</td>
                        </tr>
                        <tr>
                            <td class="pdfTable bangla-text">মোট খরচের পরিমাণ (প্রমাণসহ)</td>
                            <td class="{{ containsBangla($invoice?->total_expense) ? 'bangla-text' : 'eng-text' }}">
                                {{ $invoice?->total_expense }}</td>
                        </tr>
                        <tr>
                            <td class="pdfTable bangla-text">বর্তমান ঠিকানা</td>
                            <td class="{{ containsBangla($invoice?->current_address) ? 'bangla-text' : 'eng-text' }}">
                                {{ $invoice?->current_address }}</td>
                        </tr>
                        <tr>
                            <td class="pdfTable bangla-text">আর্থিক সহায়তা তহবিল হইতে গত /চলতি অর্থ বৎসরে কোনো অনুদান পাইয়া থাকিলে অনুদান প্রাপ্তির খাতের নাম ও টাকার পরিমান</td>
                            <td class="{{ containsBangla($invoice?->fund_aid) ? 'bangla-text' : 'eng-text' }}">
                                {{ $invoice?->fund_aid }}</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"
        integrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz" crossorigin="anonymous">
    </script>
</body>

</html>