@extends('layouts.brta-layout')
@section('title', 'BRTA')
@section('content')

    @if (!empty($value))
        <table class="table table-hover table-bordered">
            <thead>
                <tr>
                    <th> {!! GoogleTranslate::trans('SL' ?? '', app()->getLocale()) !!}</th>
                    <th> {!! GoogleTranslate::trans('Title' ?? '', app()->getLocale()) !!}</th>
                    <th> {!! GoogleTranslate::trans('Download' ?? '', app()->getLocale()) !!}</th>
                    <th> {!! GoogleTranslate::trans('Explain' ?? '', app()->getLocale()) !!}</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($value as $data)
                    <tr>
                        <td> {!! GoogleTranslate::trans($loop->iteration ?? '', app()->getLocale()) !!} </td>
                        <td> {{ GoogleTranslate::trans($data->title ?? '', app()->getLocale()) }} </td>
                        <td>
                            <a href="{{ $data->download }}"  download class="text-decoration-none">
                                {!! GoogleTranslate::trans('Download' ?? '', app()->getLocale()) !!}
                            </a>
                        </td>

                        <td> {!! GoogleTranslate::trans($data->explain ?? '', app()->getLocale()) !!} </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    @else
        <p>
            <strong class="text-danger">
                ফরম পূরণের নির্দেশিকা তথ্য পাওয়া যায়নি।
            </strong>
        </p>
    @endif

@endsection
