@extends('layouts.brta-layout')

@section('title', 'Login')
@section('content')
    <div class="row justify-content-center">
        <div class="col-md-4">
            <div class="card mt-5">
                <div class="card-body">
                    <h3 class="card-title text-center mb-4">{{ __('messages.login') }}</h3>
                    @if (Session::has('error'))
                        <div class="alert alert-warning alert-dismissible fade show" role="alert">
                            <strong>{{ __('messages.loginMessage') }}</strong>
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    @endif
                    <form action="{{ route('application.login') }}" method="post">
                        @csrf
                        <div class="mb-3">
                            <label for="phone" class="form-label">{{ __('messages.Phone') }}</label>
                            <input type="number" name="phone" class="form-control" id="phone" placeholder="">

                        </div>
                        <div class="mb-3">
                            <label for="password" class="form-label">{{ __('messages.ReferenceNumber') }}</label>
                            <input type="password" name="password" class="form-control" id="password" placeholder="">
                        </div>
                        <button type="submit" class="btn text-white w-100 mb-4"
                            style="  background-color: #501784;">{{ __('messages.login') }}</button>
                    </form>
                </div>
            </div>

        </div>
    </div>
@endsection
