<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>@yield('title')</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://fonts.maateen.me/solaiman-lipi/font.css" rel="stylesheet">
    <style>
    /* Hide all steps by default */
    .step {
        display: none;
    }

    /* Show the active step */
    .active {
        display: block;
    }

    /* Style for the step navigation buttons */
    .step-buttons {
        margin-top: 20px;
    }

    .step-buttons button {
        margin-right: 10px;
    }
    </style>


    <style>
    body {
        font-family: 'SolaimanLipi', Arial, sans-serif !important;
    }

    /* Custom styling */
    .top-bar {
        background-color: #0f8655;
        color: white;
        padding: 5px 0;
    }

    .navbar {
        background-color: #5a0f83;
    }

    .navbar a {
        color: white;
    }

    .cta-btn {
        background-color: #501784;
        color: white;
        padding: 15px;
        display: inline-block;
        border-radius: 5px;
        margin: 10px 0;
    }

    .se-btn {
        background-color: #501784;
        padding: 15px;
        border-radius: 5px;
        margin: 10px 0;
    }

    .service-section {
        background-color: #f7f7f7;
        padding: 40px 0;
    }

    .menu {
        padding: 0px 7px;
        border-radius: 3px;
        margin-right: 5px;
        font-size: 17px;
        font-weight: 500;
    }

    .menu a {
        font-size: 16px !important;
        font-weight: 500;
    }

    .menu:nth-last-child() {
        margin-right: 0px
    }

    .menu:nth-last-child() {
        margin-right: 0px
    }

    .menu:hover {
        border-bottom: 1px solid #fff;
        transition: 0.5s;
    }

    .active-menu {
        border-bottom: 1px solid #fff;
    }

    .submit-btn {
        padding: 8px 23px;
        background: #5a0f83;
        border: none;
        border-radius: 3px;
        color: #fff;
        font-size: 18px;
        font-weight: 600;
    }

    .submit-btn:hover {
        background: #333;
        transition: 0.5s;
    }

    .service-card {
        text-align: center;
        padding: 20px;
        border: 1px solid #ddd;
        background-color: white;
        transition: box-shadow 0.3s ease;
    }

    .service-card:hover {
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
    }

    .nav-link:hover {
        color: rgba(248, 203, 2, 0.932) !important;
    }

    .nav-link:focus,
    .nav-link:hover {
        color: #fff !important;
    }

    .footer {
        background-color: #5a0f83;
        color: white;
        padding: 30px 0;
    }

    .footer a {
        color: white;
    }

    /* Flexbox layout */
    html,
    body {
        height: 100%;
    }

    body {
        display: flex;
        flex-direction: column;
    }

    .content {
        flex: 1;
    }
    </style>
</head>


<body>

    <!-- Navbar -->
    <nav class="navbar navbar-expand-lg">
        <div class="container">
            <a class="navbar-brand" href="{{ route('home') }}">
                <!-- Logo here -->
                <img src="{{ asset('brta-logo.png') }}" alt="Logo" width="50">
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    <li
                        class="nav-item menu {{ URL::current() ==  url('pages/introduction_trasti_board') ? 'active-menu' : '' }}">
                        <a class="nav-link" href="{{ route('page.data', 'introduction_trasti_board') }}">
                            {{ __('messages.IntroductionBoard') }} </a>
                    </li>
                    <li class="nav-item menu {{ URL::current() ==  url( 'pages/trasti_board_member') ? 'active-menu' : '' }}">
                        <a class="nav-link" href="{{ route('page.data', 'trasti_board_member') }}">
                            {{ __('messages.BoardMembers') }}
                        </a>
                    </li>

                    <li class="nav-item menu {{ URL::current() ==  url( 'pages/office_order' ) ? 'active-menu' : '' }}">
                        <a class="nav-link" href="{{ route('page.data', 'office_order') }}">
                            {{ __('messages.OfficeOrders') }}
                        </a>
                    </li>
                    <li class="nav-item menu {{ URL::current() ==  url( 'pages/all_form') ? 'active-menu' : '' }}">
                        <a class="nav-link" href="{{ route('page.data', 'all_form') }}">
                            {{-- ফরম সমূহ --}} {{ __('messages.Forms') }}
                        </a>
                    </li>
                    <li
                        class="nav-item menu {{ URL::current() ==  url('form-fill-up-nirdesika/form_fill') ? 'active-menu' : '' }}">
                        <a class="nav-link" href="{{ route('form.fillUp', 'form_fill') }}">
                            {{-- ফরম পূরণের নির্দেশিকা --}} {{ __('messages.formFilling') }}
                        </a>
                    </li>
                    @if (!Auth::user())
                        <li class="nav-item me-3">
                            <a class="btn btn-success" href="{{ route('login') }}">
                                {{ __('messages.AdminLogin') }}
                            </a>
                        </li>
                        @else
                        <li class="nav-item me-2">
                            <a class="nav-link" href="{{ route('admin.dashboard') }}">
                                {{ __('messages.dashboard') }}
                            </a>
                        </li>
                    @endif
                    <li class="nav-item  d-flex align-middle">
                        <select name="" class="form-select form-select-sm changeLang" id="">
                            <option value="en" {{ session()->get('locale') == 'en' ? 'selected' : '' }}>English</option>
                            <option value="bn" {{ session()->get('locale') == 'bn' ? 'selected' : '' }}>বাংলা</option>
                        </select>
                    </li>
                </ul>
            </div>
        </div>
    </nav>

    <!-- Main Section -->
    <div class="content">
        <div class="container my-4">
            @yield('content')
        </div>
    </div>

    <!-- Services Section -->

    <!-- Footer -->
    <footer class="footer">
        <div class="container text-center">
            <div class="justify-space-between">
                <div>
                    <p>বাংলাদেশ সড়ক পরিবহন কর্তৃপক্ষ (বিআরটিএ)
                        সদর কার্যালয়
                        বিআরটিএ ভবন, চেয়ারম্যানবাড়ী
                        নতুন বিমানবন্দর সড়ক
                        বনানী, ঢাকা-১২১২, বাংলাদেশ।
                        ই-মেইল: info@brta.gov.bd</p>
                </div>
                <div>
                    <p> &copy; 2024 Government Service Portal.<a href="https://seoexpate.com">powered by SEO
                            Expate Bangladesh Ltd.</a>
                    </p>
                </div>
            </div>
        </div>
    </footer>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
    <script src="{{ asset('backEnd') }}/iziToast/dist/js/iziToast.min.js"></script>
 


    <script type="text/javascript">
        var url = "{{ route('changeLang') }}";
        $(".changeLang").change(function(){
            window.location.href = url + "?lang="+ $(this).val();
        });
    </script>

@if (session()->get('success'))
<script>
    iziToast.success({
        title: '',
        position: 'topRight',
        message: '{{ session()->get('success') }}',
    });
</script>
@endif

@if (session()->get('error'))
<script>
    iziToast.error({
        title: ''{{ session()->get('error') }}'',
        position: 'topRight',
        message: '{{ session()->get('error') }}',
    });
</script>
@endif

   @stack('scripts')
</body>

</html>