@php
    $errorCode = '401';
    $errorMessage = 'Unauthorized';
    $errorDescription = 'Authentication is required to access this page. Please log in and try again.';
@endphp
    <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="description" content="Orbiter is a bootstrap minimal & clean admin template">
    <meta name="keywords" content="admin, admin panel, admin template, admin dashboard, responsive, bootstrap 4, ui kits, ecommerce, web app, crm, cms, html, sass support, scss">
    <meta name="author" content="Themesbox">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0, minimal-ui">
    <title>{{ $errorCode }} - {{ $errorMessage }}</title>
    <!-- Fevicon -->
    <link rel="shortcut icon" href="{{asset('backEnd')}}/assets/images/favicon.ico">
    <!-- Start CSS -->
    <link href="{{asset('backEnd')}}/assets/css/bootstrap.min.css" rel="stylesheet" type="text/css">
    <link href="{{asset('backEnd')}}/assets/css/icons.css" rel="stylesheet" type="text/css">
    <link href="{{asset('backEnd')}}/assets/css/style.css" rel="stylesheet" type="text/css">
    <!-- End CSS -->
</head>
<body class="vertical-layout">
<!-- Start Containerbar -->
<div id="containerbar" class="containerbar authenticate-bg">
    <!-- Start Container -->
    <div class="container">
        <div class="auth-box error-box">
            <!-- Start row -->
            <div class="row no-gutters align-items-center justify-content-center">
                <!-- Start col -->
                <div class="col-md-8 col-lg-6">
                    <div class="text-center">
                        <h1 class="error-image" style="font-size: 150px;">{{ $errorCode }}</h1>
                        <h4 class="error-subtitle mb-4">{{ $errorMessage }}</h4>
                        <p class="mb-4">{{ $errorDescription }}</p>
                        <a href="{{route('admin')}}" class="btn btn-primary font-16"><i class="feather icon-home mr-2"></i> Go back to Dashboard</a>
                    </div>
                </div>
                <!-- End col -->
            </div>
            <!-- End row -->
        </div>
    </div>
    <!-- End Container -->
</div>
<!-- End Containerbar -->
<!-- Start js -->
<script src="{{asset('backEnd')}}/assets/js/jquery.min.js"></script>
<script src="{{asset('backEnd')}}/assets/js/popper.min.js"></script>
<script src="{{asset('backEnd')}}/assets/js/bootstrap.min.js"></script>
<script src="{{asset('backEnd')}}/assets/js/modernizr.min.js"></script>
<script src="{{asset('backEnd')}}/assets/js/detect.js"></script>
<script src="{{asset('backEnd')}}/assets/js/jquery.slimscroll.js"></script>
<!-- End js -->
</body>
</html>
