@extends('backEnd.master')
@section('title')
    User Management
@endsection

@section('content')
    <!-- Start Breadcrumbbar -->
    <div class="breadcrumbbar">
        <div class="row align-items-center">
            <div class="col-md-8 col-lg-8">
                <div class="breadcrumb-list">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Home</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
                        <li class="breadcrumb-item active" aria-current="page">User Management</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <div class="contentbar">
        <div class="row">
            <div class="col-lg-12">
                <div class="card m-b-30">
                    <div class="card-header">
                        <h5 class="card-title">Upozila User List</h5>
                    </div>
                    <div class="card-body">
                        <form action="{{ route('admin-user.update', $user->id) }}" method="POST">
                            @csrf
                            @method('PUT')

                            <div class="form-group">
                                <label for="name">Name</label>
                                <input type="text" name="name" class="form-control" value="{{ $user->name }}">
                            </div>

                            @if ($user->uno_type == App\Enum\EnoType::DIVISIONUNO)
                                <div class="form-group">
                                    <label for="name">Division</label>
                                    <select name="division_id" class="form-control" id="">
                                        @foreach ($division as $item)
                                            <option {{ $item->id == $user->division_id ? 'selected' : '' }}
                                                value="{{ $item->id }}">{{ $item->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            @elseif($user->uno_type == App\Enum\EnoType::DISTRICT)
                            <div class="form-group">
                                <label for="name">District</label>
                                <select name="district_id" class="form-control" id="">
                                    @foreach ($district as $item)
                                        <option {{ $item->id == $user->district_id ? 'selected' : '' }}
                                            value="{{ $item->id }}">{{ $item->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            @else
                                <div class="form-group">
                                    <label for="name">Upozila</label>
                                    <select name="upozila_id" class="form-control" id="">
                                        @foreach ($upozila as $item)
                                            <option {{ $item->id == $user->upozila_id ? 'selected' : '' }}
                                                value="{{ $item->id }}">{{ $item->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            @endif

                            <div class="form-group">
                                <label for="name">Email</label>
                                <input type="email" name="email" class="form-control" value="{{ $user->email }}">
                            </div>

                            <div class="form-group">
                                <label for="name">Phone</label>
                                <input type="number" name="phone" class="form-control" value="{{ $user->phone }}">
                            </div>
                            <button class="btn btn-success" type="submit">submit</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
