@extends('backEnd.master')
@section('title')
    Add User
@endsection

@section('content')
    <!-- Start Breadcrumbbar -->
    <div class="breadcrumbbar">
        <div class="row align-items-center">
            <div class="col-md-8 col-lg-8">
                <div class="breadcrumb-list">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Home</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
                        <li class="breadcrumb-item active" aria-current="page">Add User</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <div class="contentbar">
        <div class="row">
            <div class="col-lg-12">
                <div class="card m-b-30">
                    <div class="card-body">
                        <form action="{{ route('admin-user.store') }}" method="POST">
                            @csrf

                            <div class="form-group">
                                <label for="name">Name</label>
                                <input type="text" name="name" class="form-control" value="{{ old('name') }}" placeholder="Enter name">
                            </div>


                            @if (Route::currentRouteName() == 'division-user.create')
                                <div class="form-group">
                                    <label for="name">Division</label>
                                    <select name="division_id" class="form-control" id="">
                                        <option value="">Select Division</option>
                                        @foreach ($division as $item)
                                            <option value="{{ $item->id }}">{{ $item->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            @else
                                <div class="form-group">
                                    <label for="name">Upozila</label>
                                    <select name="upozila_id" class="form-control" id="">
                                        <option value="">Select Upozila</option>
                                        @foreach ($upozila as $item)
                                            <option value="{{ $item->id }}">{{ $item->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            @endif


                            <div class="form-group">
                                <label for="name">Email</label>
                                <input type="email" name="email" class="form-control" value="{{ old('email') }}" placeholder="example@gmail.com">
                            </div>

                            <div class="form-group">
                                <label for="name">Phone</label>
                                <input type="number" name="phone" class="form-control" value="{{ old('phone') }}" placeholder="+880 17">
                            </div>

                            <div class="form-group">
                                <label for="name">Password</label>
                                <input type="password" name="password" class="form-control" value="" placeholder="enter password">
                            </div>
                            <button class="btn btn-success" type="submit">submit</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
