@extends('backend.master')
@section('title')
    User Create
@endsection

@section('content')
    <!-- Start Breadcrumbbar -->
    <div class="breadcrumbbar">
        <div class="row align-items-center">
            <div class="col-md-8 col-lg-8">
                <h4 class="page-title">Users</h4>
                <div class="breadcrumb-list">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="index.html">Home</a></li>
                        <li class="breadcrumb-item"><a href="#">Users</a></li>
                        <li class="breadcrumb-item active" aria-current="page">@yield('title')</li>
                    </ol>
                </div>
            </div>
            <div class="col-md-4 col-lg-4">
                <div class="widgetbar">
                    <a href="{{route('admin-user.index')}}" class="btn btn-primary"><i class="feather icon-plus mr-2"></i>User List</a>
                </div>
            </div>
        </div>
    </div>
    <!-- End Breadcrumb bar -->

    <!-- Start Contentbar -->
    <div class="contentbar">
        <!-- Start row -->
        <div class="row">
            <!-- Start col -->
            <div class="col-lg-12">
                <div class="card m-b-30">
                    <div class="card-header">
                        <h5 class="card-title">Create User</h5>
                    </div>
                    <div class="card-body">
                        <form method="POST" action="{{route('admin-user.store')}}">
                            @csrf
                            <div class="form-group">
                                <label for="name">Full Name <small class="text-danger">*</small></label>
                                <input type="text" class="form-control" id="name" name="name" aria-describedby="emailHelp" placeholder="Full Name" required value="{{old('name')}}">
                            </div>
                            <div class="form-group">
                                <label for="username">Username<small class="text-danger">*</small></label>
                                <input type="text" class="form-control" id="username" name="username" placeholder="Username" required  value="{{old('username')}}">
                            </div>
                            <div class="form-group">
                                <label for="exampleInputEmail1">Email address <small class="text-danger">*</small></label>
                                <input type="email" name="email" class="form-control" id="exampleInputEmail1" aria-describedby="emailHelp" placeholder="Enter email" required  value="{{old('email')}}">
                            </div>

                            <div class="form-group">
                                <label for="exampleInputPassword1">Password <small class="text-danger">*</small></label>
                                <input type="password" name="password" class="form-control" id="exampleInputPassword1" placeholder="Password" required  value="{{old('password')}}">
                            </div>

                            <button type="submit" class="btn btn-primary">Submit</button>
                        </form>
                    </div>
                </div>
            </div>
            <!-- End col -->


        </div> <!-- End row -->
    </div>
    <!-- End Contentbar -->
@endsection
