@extends('backEnd.master')
@section('title')
    User List
@endsection

@section('content')
    <!-- Start Breadcrumbbar -->
    <div class="breadcrumbbar">
        <div class="row align-items-center">
            <div class="col-md-8 col-lg-8">
                <div class="breadcrumb-list">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="index.html">Home</a></li>
                        <li class="breadcrumb-item"><a href="#">Uno Information</a></li>
                        <li class="breadcrumb-item active" aria-current="page">Uno Information List</li>
                    </ol>
                </div>
            </div>
            <div class="col-md-4 col-lg-4">
                <div class="widgetbar">
                    <a href="{{ route('uno-information.create') }}" class="btn btn-primary"><i
                            class="feather icon-plus mr-2"></i>Add Uno</a>
                </div>
            </div>
        </div>
    </div>
    <!-- End Breadcrumbbar -->

    <!-- Start Contentbar -->
    <div class="contentbar">
        <div class="row">
            <div class="col-lg-12">
                <div class="card m-b-30">
                    <div class="card-header">
                        <h5 class="card-title">Uno List</h5>
                    </div>
                    <div class="card-body">
                        <h6 class="card-subtitle">Export data to Copy, CSV, Excel & Note.</h6>
                        <div class="table-responsive">
                            <table id="datatable-buttons" class="table table-bordered text-black">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Name</th>
                                        <th>Email</th>
                                        <th>Phone</th>
                                        <th>Designation</th>
                                        <th>Zila</th>
                                        <th>Thana</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($records as $record)
                                        <tr>
                                            <td>{{ $loop->iteration }}</td>
                                            <td>{{ $record->name }}</td>
                                            <td>{{ $record->email }}</td>
                                            <td>{{ $record->phone ?? 'N/A' }}</td>
                                            <td>{{ $record->designation ?? 'N/A' }}</td>
                                            <td>{{ $record->zila ?? 'N/A' }}</td>
                                            <td>{{ $record->thana ?? 'N/A' }}</td>
                                            <td>
                                                <a href="{{ route('uno-information.edit', $record->id) }}">
                                                    <button class="btn btn-info mb-2">Edit</button>
                                                </a>
                                                <form action="{{ route('uno-information.destroy', $record->id) }}"
                                                    method="post" id="item_delete_{{ $record->id }}">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button class="btn btn-danger delete-item"
                                                        data-id="{{ $record->id }}" type="button">Delete</button>
                                                </form>
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="8" class="text-center">No records found</td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('script')
    <script>
        $('.delete-item').on('click', function() {
            var id = $(this).attr('data-id');
            Swal.fire({
                title: "Are you sure?",
                text: "You won't be able to revert this!",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#3085d6",
                cancelButtonColor: "#d33",
                confirmButtonText: "Yes, delete it!"
            }).then((result) => {
                if (result.isConfirmed) {
                    $('#item_delete_' + id).submit()
                }
            });
        })
    </script>
@endpush
