@extends('backEnd.master')
@section('title')
Uno Information Add
@endsection

@section('content')
<!-- Start Breadcrumbbar -->
<div class="breadcrumbbar">
    <div class="row align-items-center">
        <div class="col-md-8 col-lg-8">
            {{-- <h4 class="page-title">Uno</h4> --}}
            <div class="breadcrumb-list">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Home</a></li>
                    <li class="breadcrumb-item"><a href="#">Uno</a></li>
                    <li class="breadcrumb-item active" aria-current="page">@yield('title')</li>
                </ol>
            </div>
        </div>
        <div class="col-md-4 col-lg-4">
            <div class="widgetbar">
                <a href="{{route('uno-information.index')}}" class="btn btn-primary"><i
                        class="feather icon-plus mr-2"></i>Uno List</a>
            </div>
        </div>
    </div>
</div>
<!-- End Breadcrumb bar -->

<!-- Start Contentbar -->
<div class="contentbar">
    <!-- Start row -->
    <div class="row">
        <!-- Start col -->
        <div class="col-lg-12">
            <div class="card m-b-30">
                <div class="card-header">
                    <h5 class="card-title">Add Uno</h5>
                </div>
                <div class="card-body">
                    <form method="POST" action="{{ route('uno-information.store') }}" onsubmit="disableSubmitButton()" enctype="multipart/form-data">
                        @csrf
                        <!-- CSRF token for security -->

                        <!-- Name Field -->
                        <div class="mb-3">
                            <label for="name" class="form-label">Division <span class="text-danger">*</span> </label>
                          <select name="division_id" class="form-control" id="" required>
                            <option value="">Select Division</option>
                            @foreach ( $division as $item )
                            <option value="{{  $item['id'] }}">{{ $item['bn_name'] }}</option>
                            @endforeach
                          </select>
                            @error('name')
                            <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Name Field -->
                        <div class="mb-3">
                            <label for="name" class="form-label">Name  <span class="text-danger">*</span> </label>
                            <input type="text" class="form-control" id="name" name="name" placeholder="Enter your name"
                                value="{{ old('name') }}" required>
                            @error('name')
                            <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Email Field -->
                        <div class="mb-3">
                            <label for="email" class="form-label">Email  <span class="text-danger">*</span> </label>
                            <input type="email" class="form-control" id="email" name="email"
                                placeholder="Enter your email" value="{{ old('email') }}" required>
                            @error('email')
                            <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Phone Field -->
                        <div class="mb-3">
                            <label for="phone" class="form-label">Mobile  <span class="text-danger">*</span> </label>
                            <input type="number" class="form-control" id="phone" name="mobile"
                                placeholder="+880 1555414501" value="{{ old('mobile') }}" requireds>
                            @error('phone')
                            <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Phone Field -->
                        <div class="mb-3">
                            <label for="phone" class="form-label">Phone (Office)</label>
                            <input type="number" class="form-control" id="phone" name="phone"
                                placeholder="02" value="{{ old('phone') }}">
                        </div>

                        <!-- Designation Field -->
                        <div class="mb-3">
                            <label for="designation" class="form-label">Designation  <span class="text-danger">*</span> </label>
                            <input type="text" class="form-control" id="designation" name="designation"
                                placeholder="Enter your designation" value="{{ old('designation') }}" required>
                            @error('designation')
                            <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Zila Field -->
                        <div class="mb-3">
                            <label for="address" class="form-label">Address  <span class="text-danger">*</span> </label>
                            <input type="text" class="form-control" id="address" name="address" placeholder="Enter uno address"
                                value="{{ old('address') }}" required>
                            @error('address')
                            <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Zila Field -->
                        <div class="mb-3">
                            <label for="image" class="form-label">Image</label>
                            <input type="file" class="form-control" id="image" name="image">
                            @error('image')
                            <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>


                        <button type="submit" class="btn btn-primary" id="submit-button">Submit</button>
                    </form>
                </div>
            </div>
        </div>
        <!-- End col -->


    </div> <!-- End row -->
</div>
<!-- End Contentbar -->
@endsection