@extends('backend.master')
@section('title', 'Survey Report')
<style>
    @media print {
        .header {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            background: #f8f9fa;
            border-bottom: 1px solid #dee2e6;
            padding: 10px;
            text-align: center;
            font-weight: bold;
        }

        .content {
            margin-top: 60px;
            /* Adjust according to header height */
        }
    }
</style>
@push('style')
    <link rel="stylesheet" href="{{ asset('backEnd/assets/yearpicker.css') }}">
@endpush
@section('content')
    <!-- Start Breadcrumbbar -->
    <div class="breadcrumbbar">
        <div class="row align-items-center">
            <div class="col-md-8 col-lg-8">
                <h4 class="page-title">Reports</h4>
                <div class="breadcrumb-list">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="index.html">Home</a></li>
                        <li class="breadcrumb-item"><a href="#">Yearly Reports </a></li>
                        <li class="breadcrumb-item active" aria-current="page">@yield('title')</li>
                    </ol>
                </div>
            </div>

        </div>
    </div>
    <!-- End Breadcrumb bar -->

    <!-- Start Contentbar -->
    <div class="contentbar">
        <!-- Start row -->
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <form method="get" action="{{ route('filter.yearly') }}">
                            <div class="row">
                                <div class="form-group col-md-3">
                                    <label for="name">Type<small class="text-danger">*</small></label>
                                    <select name="type" id="type" class="form-control">
                                        <option value="">Select Type</option>
                                        <option {{ $type == 1 ? 'selected' : '' }} value="1">Food Loss</option>
                                        <option {{ $type == 2 ? 'selected' : '' }} value="2">Food Waste</option>
                                    </select>
                                </div>
                                <?php
                                $currentYear = date('Y');
                                $years = [];
                                
                                for ($i = 0; $i < 7; $i++) {
                                    $years[] = $currentYear + $i;
                                }
                                ?>

                                <div class="form-group col-md-3">
                                    <label for="name">Year<small class="text-danger">*</small></label>
                                    <select name="year" id="year" class="form-control">
                                        <option value="">Select Year</option>
                                        @foreach ($years as $year)
                                            <option {{ $y == $year ? 'selected' : '' }} value="{{ $year }}">
                                                {{ $year }}</option>
                                        @endforeach

                                    </select>
                                </div>
                            </div>
                            <button type="submit" class="btn btn-primary">Submit</button>
                            <button onclick="printContent()" class="btn btn-warning" type="button">
                                <img src="{{ asset('images/printer.svg') }}" alt="" srcset=""> Print
                            </button>
                        </form>
                    </div>
                    <div class="card-body" id="printableArea">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>SL</th>
                                    <th>Survey Type</th>
                                    <th>Total Survey</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse ($survey as $item)
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td>{{ $item?->type?->name }}</td>
                                        <td>{{ $item?->survey_count }}</td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="3">Data Not Found !</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                        {{ $survey->links('pagination::bootstrap-5') }}
                    </div>
                </div>
            </div>
        </div> <!-- End row -->
    </div>
    <!-- End Contentbar -->
@endsection

@push('script')
    <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.22.2/moment.min.js"></script>

    <script>
        $('.yearpicker').yearpicker()
    </script>

    <script>
        function printContent() {
            printJS({
                printable: 'printableArea',
                type: 'html',
                header: 'Yearly Survey Report',
                css: 'https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css'
            });
        }
    </script>
@endpush
