@extends('backend.master')
@section('title', 'Survey Report')
<style>
@media print {
    .header {
        position: fixed;
        top: 0;
        left: 0;
        right: 0;
        background: #f8f9fa;
        border-bottom: 1px solid #dee2e6;
        padding: 10px;
        text-align: center;
        font-weight: bold;
    }

    .content {
        margin-top: 60px;
        /* Adjust according to header height */
    }
}
</style>
@section('content')
<!-- Start Breadcrumbbar -->
<div class="breadcrumbbar">
    <div class="row align-items-center">
        <div class="col-md-8 col-lg-8">
            <h4 class="page-title">Reports</h4>
            <div class="breadcrumb-list">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="index.html">Home</a></li>
                    <li class="breadcrumb-item"><a href="#">Reports </a></li>
                    <li class="breadcrumb-item active" aria-current="page">@yield('title')</li>
                </ol>
            </div>
        </div>

    </div>
</div>
<!-- End Breadcrumb bar -->

<!-- Start Contentbar -->
<div class="contentbar">
    <!-- Start row -->
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">
                    <form method="get" action="{{ route('filter.user-survey') }}">
                        <div class="row">
                            <div class="form-group col-md-6">
                                <label for="name">User<small class="text-danger">*</small></label>
                                <select name="user" id="type" class="form-control">
                                    <option value="">Select User</option>
                                    @foreach ($users as $user)
                                    <option {{ $user_id == $user->id ? 'selected' : '' }} value="{{ $user->id }}">
                                        {{ $user->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <button type="submit" class="btn btn-primary">Get Report </button>
                    </form>
                </div>

            </div>
        </div>
    </div> <!-- End row -->
</div>
<!-- End Contentbar -->
@endsection

@push('script')
<script>
function printContent() {
    printJS({
        printable: 'printableArea',
        type: 'html',
        header: 'User wise Survey Report',
        css: 'https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css'
    });
}
</script>

@endpush