@extends('backend.master')
@section('title', 'Survey Report')

@section('content')
<style>
@media print {
    .header {
        position: fixed;
        top: 0;
        left: 0;
        right: 0;
        background: #f8f9fa;
        border-bottom: 1px solid #dee2e6;
        padding: 10px;
        text-align: center;
        font-weight: bold;
    }

    .content {
        margin-top: 60px;
        /* Adjust according to header height */
    }
}
</style>
<!-- Start Breadcrumbbar -->
<div class="breadcrumbbar">
    <div class="row align-items-center">
        <div class="col-md-8 col-lg-8">
            <h4 class="page-title">Reports</h4>
            <div class="breadcrumb-list">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="index.html">Home</a></li>
                    <li class="breadcrumb-item"><a href="#">Reports </a></li>
                    <li class="breadcrumb-item active" aria-current="page">@yield('title')</li>
                </ol>
            </div>
        </div>

    </div>
</div>
<!-- End Breadcrumb bar -->

<!-- Start Contentbar -->
<div class="contentbar">
    <!-- Start row -->
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">
                    <form method="get" action="{{route('reports.login-history')}}">
                        <div class="row">
                            <div class="form-group col-md-4">
                                <label for="from">From Date <small class="text-danger">*</small></label>
                                <input type="date" class="form-control" id="from" name="from" placeholder="from"
                                    required value="{{ $form ?? old('from') }}">
                            </div>

                            <div class="form-group col-md-4">
                                <label for="from">To Date <small class="text-danger">*</small></label>
                                <input type="date" class="form-control" id="to" name="to" placeholder="to" required
                                    value="{{ $to ?? old('to')}}">
                            </div>
                        </div>
                        <button type="submit" class="btn btn-primary">Submit</button>
                        <button onclick="printContent()" class="btn btn-warning" type="button"> 
                            <img src="{{ asset('images/printer.svg') }}" alt="" srcset=""> Print
                        </button>
                    </form>
                </div>

                <div class="card-body" id="printableArea">
                    <table class="table table-bordered">
                        <thead>
                            <tr>
                                <th>Date</th>
                                <th>User</th>
                                <th>IP Address</th>
                                <th>User Agent</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($loginHistories as $history)
                            <tr>
                                <td>{{ $history->login_at->format('F j, Y, g:i a') }}</td>
                                <td>{{ $history->user->name }}</td>
                                <td>{{ $history->ip_address }}</td>
                                <td>{{ $history->user_agent }}</td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                    {{ $loginHistories->links('pagination::bootstrap-5') }}
                </div>
            </div>
        </div>
    </div> <!-- End row -->
</div>
<!-- End Contentbar -->
@endsection

@push('script')
<script>
function printContent() {
    printJS({
        printable: 'printableArea',
        type: 'html',
        header: 'Login History',
        css: 'https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css'
    });
}
</script>

@endpush