@extends('backend.master')
@section('title', 'Report')

@section('content')
    <!-- Start Breadcrumbbar -->
    <div class="breadcrumbbar">
        <div class="row align-items-center">
            <div class="col-md-8 col-lg-8">
                <h4 class="page-title">Reports</h4>
                <div class="breadcrumb-list">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ route('admin') }}">Home</a></li>
                        <li class="breadcrumb-item"><a href="#">Reports </a></li>
                        <li class="breadcrumb-item active" aria-current="page">@yield('title')</li>
                    </ol>
                </div>
            </div>

        </div>
    </div>
    <!-- End Breadcrumb bar -->

    <!-- Start Contentbar -->
    <div class="contentbar">
        <!-- Start row -->
        <div class="row">
            <!-- Start col -->
            <div class="col-lg-12">
                <div class="card m-b-30">
                    <div class="card-header">
                        <h5 class="card-title">Filter Report </h5>
                    </div>
                    <div class="card-body">
                        <form method="POST" action="{{route('reports.download-excel-data')}}">
                            @csrf
                            <div class="row">
                                <div class="form-group col-md-4">
                                    <label for="name">Type<small class="text-danger">*</small></label>
                                    <select name="type" id="type" class="form-control">
                                        <option value="">Select Survey Type </option>
                                        <option value="1">Food Loss</option>
                                        <option value="2">Food Waste</option>
                                    </select>
                                </div>
                                <div class="form-group col-md-4">
                                    <label for="from">From Date <small class="text-danger">*</small></label>
                                    <input type="date" class="form-control" id="from" name="from" placeholder="from" required  value="{{old('from')}}">
                                </div>
                                
                                <div class="form-group col-md-4">
                                    <label for="from">To Date <small class="text-danger">*</small></label>
                                    <input type="date" class="form-control" id="to" name="to" placeholder="to" required  value="{{old('to')}}">
                                </div>
                            </div>


                            <button type="submit" class="btn btn-primary">Submit</button>
                        </form>
                    </div>
                </div>
            </div>
            <!-- End col -->


        </div> <!-- End row -->
    </div>
    <!-- End Contentbar -->
@endsection
