@extends('backEnd.master')
@section('title')
    Office Order
@endsection

@section('content')
    <!-- Start Breadcrumbbar -->
    <div class="breadcrumbbar">
        <div class="row align-items-center">
            <div class="col-md-8 col-lg-8">
                <h4 class="page-title">Office Order</h4>
                <div class="breadcrumb-list">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Home</a></li>
                        <li class="breadcrumb-item"><a href="#">Office Order</a></li>
                        <li class="breadcrumb-item active" aria-current="page">@yield('title')</li>
                    </ol>
                 
                </div>
            </div>
            <div class="col-md-4 text-right">
                <a href="{{ route('office-orders.create') }}">
                    <button class="btn btn-sm btn-info">Create</button>
                </a>
            </div>
        </div>
    </div>
    <div class="contentbar">
        <div class="row">
            <div class="col-lg-12">
                <div class="card m-b-30">
                    <div class="card-body">
                        <div class="table-responsive mt-4">
                            <table class="table table-bordered">
                                <thead>
                                    <tr>
                                        <th>SL</th>
                                        <th>Form No</th>
                                        <th>Title</th>
                                        <th>Download</th>
                                        <th>Explain</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($forms as $order)
                                        <tr>
                                            <td>{{ $loop->iteration }}</td>
                                            <td>{{ $order->form_no }}</td>
                                            <td>{{ $order->title }}</td>
                                            <td>{{ $order->download }}</td>
                                            <td>{{ $order->explain }}</td>
                                            <td>
                                                <div class="d-inline-flex">
                                                    <a href="{{ route('office-forms.edit', $order->id) }}">
                                                        <button class="btn btn-sm btn-info mr-2">Edit</button>
                                                    </a>

                                                    <form action="{{ route('office-forms.destroy', $order->id) }}"
                                                        id="deleteOrder_{{ $order->id }}" method="POST">
                                                        @csrf
                                                    @method('DELETE')
                                                        <button class="btn btn-sm btn-danger officeForms" type="button"
                                                            id="" data-id="{{ $order->id }}">Delete</button>
                                                    </form>
                                                </div>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection


@push('script')
    <script>
        $('.officeForms').on('click', function() {
            let value = $(this).attr('data-id');
            Swal.fire({
                title: "Are you sure?",
                text: "You won't be able to revert this!",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#3085d6",
                cancelButtonColor: "#d33",
                confirmButtonText: "Yes, delete it!"
            }).then((result) => {
                if (result.isConfirmed) {
                    $('#deleteOrder_' + value).submit();
                }
            });
        })
    </script>
@endpush
