@extends('backEnd.master')
@section('title')
    Office Order
@endsection

@section('content')
    <!-- Start Breadcrumbbar -->
    <div class="breadcrumbbar">
        <div class="row align-items-center">
            <div class="col-md-8 col-lg-8">
                <h4 class="page-title">Office Order</h4>
                <div class="breadcrumb-list">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Home</a></li>
                        <li class="breadcrumb-item"><a href="#">Office Order</a></li>
                        <li class="breadcrumb-item active" aria-current="page">@yield('title')</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <div class="contentbar">
        <div class="row">
            <div class="col-lg-12">
                <div class="card m-b-30">
                    <div class="card-body">
                        <form action="{{ route('office-forms.update',$orderOffice->id ) }}" method="POST">
                            @csrf
                            @method('PUT')
                            <div class="form-group">
                                <label for="form_no">Form No</label>
                                <input type="number" name="form_no" min="1" class="form-control" id="form_no"
                                    placeholder="Enter form_no" value="{{ $orderOffice->form_no }}">
                                @error('form_no')
                                    <small class="text-danger">{{ $message }}</small>
                                @enderror
                            </div>

                            <div class="form-group">
                                <label for="title">Title</label>
                                <input type="text" name="title" class="form-control" id="title"
                                    placeholder="Enter title" value="{{ $orderOffice->title }}">
                                @error('title')
                                    <small class="text-danger">{{ $message }}</small>
                                @enderror
                            </div>

                            <div class="form-group">
                                <label for="download">Download Link</label>
                                <input type="text" name="download" class="form-control" id="download"
                                    placeholder="Enter download link" value="{{ $orderOffice->download }}">
                                @error('download')
                                    <small class="text-danger">{{ $message }}</small>
                                @enderror
                            </div>

                            <div class="form-group">
                                <label for="explain">Explain</label>
                                <input type="text" name="explain" class="form-control" id="download"
                                placeholder="Enter download link" value="{{ $orderOffice->explain }}">
                                @error('explain')
                                    <small class="text-danger">{{ $message }}</small>
                                @enderror
                            </div>

                            <button type="submit" class="btn btn-primary">Submit</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
