@extends('backEnd.master')
@section('title')
Trustees Board
@endsection

@section('content')
    <!-- Start Breadcrumbbar -->
    <div class="breadcrumbbar">
        <div class="row align-items-center">
            <div class="col-md-8 col-lg-8">
                <h4 class="page-title">Trustees Board</h4>
                <div class="breadcrumb-list">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Home</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">@yield('title')</a></li>
                        <li class="breadcrumb-item active" aria-current="page">@yield('title')</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <div class="contentbar">
        <div class="row">
            <div class="col-lg-12">
                <div class="card m-b-30">
                    <div class="card-body">
                        <form method="POST" action="{{ route('trasti-board.store') }}" onsubmit="disableSubmitButton()"
                            enctype="multipart/form-data">
                            @csrf
                            <div class="mb-4">
                                <label for="title" class="form-label">@yield('title') </label>
                                <input type="text" name="en_introduction_trasti_board[]" class="form-control mb-3"
                                    placeholder="Enter title"
                                    value="{{ get_trasti_board('en_introduction_trasti_board')[0] ?? '' }}" id="title">

                                <label for="name" class="form-label">Board of Trustees</label>
                                <textarea name="en_introduction_trasti_board[]" id="officeOrder" cols="30" rows="10">
                                    {{ get_trasti_board('en_introduction_trasti_board')[1] ?? '' }}
                                </textarea>
                            </div>

                            <div class="mb-4">
                                <label for="office_order_title" class="form-label">Office Order Title </label>
                                <input type="text" name="en_office_order[]" class="form-control mb-2"
                                    value="{{ get_trasti_board('en_office_order')[0] ?? '' }}"
                                    placeholder="Enter the title of the office order">

                                <label for="name" class="form-label">Office orders </label>
                                <textarea name="en_office_order[]" id="summernote" cols="30" rows="10">
                                    {{ get_trasti_board('en_office_order')[1] ?? '' }}
                                </textarea>
                            </div>

                            <div class="mb-4">
                                <label for="all_form_title" class="form-label">Forms Title </label>
                                <input type="text" name="en_all_form[]" class="form-control mb-3"
                                    value="{{ get_trasti_board('en_all_form')[0] ?? '' }}" 
                                    placeholder="Enter the title of the forms">

                                <label for="en_all_form" class="form-label">Forms</label>
                                <textarea name="en_all_form[]" id="all_form" cols="30" rows="10">
                                    {{ get_trasti_board('en_all_form')[1] ?? '' }}
                                </textarea>
                            </div>

                            <div class="mb-4">
                                <label for="en_trasti_board_member" class="form-label">Dear Members of the Board of Trustees </label>

                                <textarea name="en_trasti_board_member[]" id="trasti_board_member" cols="30" rows="10">
                                    {{ get_trasti_board('en_trasti_board_member')[0] ?? '' }}
                                </textarea>
                            </div>

                            <div class="mb-4">
                                <label for="name" class="form-label">Instructions for filling the form</label>
                                <input type="file" name="form_fill" id="" class="form-control">
                            </div>

                            @if (get_trasti_board('form_fill'))
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="w-50">
                                            <img class="w-100" src="{{ asset('images/' . get_trasti_board('form_fill')) }}"
                                                alt="f fg fd g">
                                        </div>
                                    </div>
                                </div>
                            @endif

                            <button type="submit" class="btn btn-primary mt-4" id="submit-button">Submit</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('script')
    <script>
        $('#form_fill').summernote({
            placeholder: 'ফরম পূরণের নির্দেশিকা',
            tabsize: 2,
            height: 120,
            toolbar: [
                ['style', ['style']],
                ['font', ['bold', 'underline', 'clear']],
                ['color', ['color']],
                ['para', ['ul', 'ol', 'paragraph']],
                ['table', ['table']],
                ['insert', ['link', 'picture', 'video']],
                ['view', ['fullscreen', 'codeview', 'help']]
            ]
        });

        $('#all_form').summernote({
            placeholder: 'ফরম সমূহ',
            tabsize: 2,
            height: 120,
            toolbar: [
                ['style', ['style']],
                ['font', ['bold', 'underline', 'clear']],
                ['color', ['color']],
                ['para', ['ul', 'ol', 'paragraph']],
                ['table', ['table']],
                ['insert', ['link', 'picture', 'video']],
                ['view', ['fullscreen', 'codeview', 'help']]
            ]
        });

        $('#summernote').summernote({
            placeholder: 'ট্রাস্টি বোর্ড পরচিতি',
            tabsize: 2,
            height: 120,
            toolbar: [
                ['style', ['style']],
                ['font', ['bold', 'underline', 'clear']],
                ['color', ['color']],
                ['para', ['ul', 'ol', 'paragraph']],
                ['table', ['table']],
                ['insert', ['link', 'picture', 'video']],
                ['view', ['fullscreen', 'codeview', 'help']]
            ]
        });

        $('#officeOrder').summernote({
            placeholder: 'অফিস আদেশ সমূহ',
            tabsize: 2,
            height: 120,
            toolbar: [
                ['style', ['style']],
                ['font', ['bold', 'underline', 'clear']],
                ['color', ['color']],
                ['para', ['ul', 'ol', 'paragraph']],
                ['table', ['table']],
                ['insert', ['link', 'picture', 'video']],
                ['view', ['fullscreen', 'codeview', 'help']]
            ]
        });

        $('#trasti_board_member').summernote({
            toolbar: [
                ['style', ['style']],
                ['font', ['bold', 'underline', 'clear']],
                ['color', ['color']],
                ['para', ['ul', 'ol', 'paragraph']],
                ['table', ['table']],
                ['insert', ['link', 'picture', 'video']],
                ['view', ['fullscreen', 'codeview', 'help']]
            ],
            callbacks: {
                onPaste: function(e) {}
            },
            codemirror: {
                theme: 'monokai'
            },
            popover: {
                table: [
                    ['add', ['addRowDown', 'addRowUp', 'addColLeft', 'addColRight']],
                    ['delete', ['deleteRow', 'deleteCol', 'deleteTable']]
                ]
            }
        });
    </script>
@endpush
