@extends('backEnd.master')
@section('title')
    All Application
@endsection

@section('content')
    <!-- Start Breadcrumbbar -->
    <div class="breadcrumbbar">
        <div class="row align-items-center">
            <div class="col-md-8 col-lg-8">
                {{-- <h4 class="page-title">CRM</h4> --}}
                <div class="breadcrumb-list">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Home</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
                        <li class="breadcrumb-item active" aria-current="page">Applicaiton</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>


    <div class="contentbar">
        <div class="row">
            @if (Auth::user()->uno_type == 'admin')
                <!-- Stat Card 1: Primary -->
                <div class="col-md-3">
                    <div class="card text-white bg-primary mb-3">
                        <div class="card-header">Total Users</div>
                        <div class="card-body">
                            <h5 class="card-title">{{ $totalUser }}</h5>
                            <p class="card-text">Active users in the system.</p>
                        </div>
                    </div>
                </div>
            @endif


            <!-- Stat Card 2: Success -->
            <div class="col-md-3">
                <div class="card text-white bg-success mb-3">
                    <div class="card-header">Total Approved Application </div>
                    <div class="card-body">
                        <h5 class="card-title">{{ $completeApplication }}</h5>
                        <p class="card-text">Total Approved Application</p>
                    </div>
                </div>
            </div>

            <!-- Stat Card 4: Danger -->
            <div class="col-md-3">
                <div class="card text-white bg-danger mb-3">
                    <div class="card-header">Total Incomplete Application</div>
                    <div class="card-body">
                        <h5 class="card-title">{{ $incompleteApplication }}</h5>
                        <p class="card-text">Total Incomplete Application.</p>
                    </div>
                </div>
            </div>

            <!-- Stat Card 3: Warning -->
            <div class="col-md-3">
                <div class="card text-white bg-warning mb-3">
                    <div class="card-header">This Month Total Application </div>
                    <div class="card-body">
                        <h5 class="card-title">{{ $currentMonthApplication }}</h5>
                        <p class="card-text">This Month Total Application</p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- End Contentbar -->

    <div class="contentbar">
        <div class="row">
            <div class="col-lg-12">
                <div class="card m-b-30">
                    <div class="card-header d-flex justify-content-between">
                        <h5 class="card-title">Today's Application</h5>
                    </div>
                    <div class="card-body">
                        <h6 class="card-subtitle">Export data to Copy, CSV, Excel & Note.</h6>
                        <div class="table-responsive">
                            <table id="datatable-buttons" class="table table-bordered text-black">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Reference Number</th>
                                        <th>Applicant Name</th>
                                        <th>Phone</th>
                                        <th>Division</th>
                                        <th>District</th>
                                        <th>Upazilas</th>
                                        {{-- @if (Auth::user()->role_id == App\Enum\UserType::APPLY) --}}
                                        <th>Action</th>
                                        {{-- @endif --}}
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($application as $row)
                                        <tr>
                                            <td>{{ $loop->iteration }}</td>
                                            <td>#{{ $row?->reference_number }}</td>
                                            <td>{{ $row?->applicant_name }}</td>
                                            <td>{{ $row?->phone }}</td>
                                            <td>{{ $row?->division?->name }}</td>
                                            <td>{{ $row?->district?->name }}</td>
                                            <td>{{ $row?->upozila?->name }}</td>

                                            <td>
                                                <div class="d-inline-flex">
                                                    <a
                                                        href="{{ route('user-applications.show', $row->reference_number) }}">
                                                        <button class="btn btn-primary mr-2">
                                                            Details
                                                        </button>
                                                    </a>
                                                    @if (Auth::user()->role_id == App\Enum\UserType::APPLY)
                                                        <a href="{{ route('document.add', $row->reference_number) }}">
                                                            <button class="btn btn-info">
                                                                update
                                                            </button>
                                                        </a>
                                                    @endif
                                                </div>
                                            </td>

                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
@endsection
