@extends('backEnd.master')
@section('title')
    Documents Update
@endsection

@section('content')
    <!-- Start Breadcrumbbar -->
    <div class="breadcrumbbar">
        <div class="row align-items-center">
            <div class="col-md-8 col-lg-8">
                {{-- <h4 class="page-title">CRM</h4> --}}
                <div class="breadcrumb-list">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Home</a></li>
                        <li class="breadcrumb-item"><a href="#">Dashboard</a></li>
                        <li class="breadcrumb-item active" aria-current="page">Applicaiton update</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <div class="contentbar">
        <div class="row">
            <div class="col-lg-12">
                <div class="card m-b-30">
                    <div class="card-header">
                        <h5 class="card-title">Application Edit</h5>
                    </div>
                    <div class="card-body">
                        <form method="POST" action="{{ route('application.update', $userData?->reference_number) }}"
                            onsubmit="disableSubmitButton()" enctype="multipart/form-data">
                            @csrf
                            @method('put')
                            <!-- Step 2 -->
                            <div class="step">

                                <div class="form-group mb-4">
                                    <label for="victim_birth_certificate">{{ __('messages.BirthCertificate') }}: </label>
                                    <input type="file" name="victim_birth_certificate" class="form-control"
                                        accept="image/*">
                                    @error('victim_birth_certificate')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>

                                @if (!empty($userData?->victim_birth_certificate))
                                    <div class="form-group mb-2">
                                        <img src="{{ asset('application/' .$userData?->victim_birth_certificate) }}"
                                            style="width:250px; height:250px; object-fit:cover" alt="">
                                    </div>
                                @endif


                                <div class="form-group mb-4">
                                    <label for="applicant_nid">{{ __('messages.NIDImage') }}: </label>
                                    <input type="file" name="applicant_nid" class="form-control" accept="image/*">
                                    @error('applicant_nid')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                                @if (!empty($userData?->applicant_nid))
                                <div class="form-group mb-2">
                                    <img src="{{ asset('application/' .$userData?->applicant_nid) }}"
                                        style="width:250px; height:250px; object-fit:cover" alt="">
                                </div>
                            @endif

                                <div class="form-group mb-4">
                                    <label for="victim_driving_license">{{ __('messages.DrivingLicense') }}:
                                    </label>
                                    <input type="file" name="victim_driving_license" class="form-control"
                                        accept="image/*">
                                </div>


                                @if (!empty($userData?->victim_driving_license))
                                    <div class="form-group mb-2">
                                        <img src="{{ asset('application/' .$userData?->victim_driving_license) }}"
                                            style="width:250px; height:250px; object-fit:cover" alt="">
                                    </div>
                                @endif

                            </div>

                            <!-- Step 3 -->
                            <div class="step">

                                <div class="form-group mb-4">
                                    <label for="gd_stamp">{{ __('messages.AccidentGDImage') }}:
                                    </label>
                                    <input type="file" name="gd_stamp" class="form-control" accept="image/*">
                                    @error('gd_stamp')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>

                                @if (!empty($userData?->gd_stamp))
                                    <div class="form-group mb-2">
                                        <img src="{{ asset('application/' .$userData?->gd_stamp) }}"
                                            style="width:250px; height:250px; object-fit:cover" alt="">
                                    </div>
                                @endif

                                <div class="form-group mb-4">
                                    <label for="death_certificate">{{ __('messages.DeathCertificate') }}: </label>
                                    <input type="file" name="death_certificate" class="form-control" accept="image/*">
                                    @error('death_certificate')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>

                                @if (!empty($userData?->death_certificate))
                                    <div class="form-group mb-2">
                                        <img src="{{ asset('application/' .$userData?->death_certificate) }}"
                                            style="width:250px; height:250px; object-fit:cover" alt="">
                                    </div>
                                @endif

                            </div>

                            <!-- Step 4  -->
                            <div class="step">

                                <div class="form-group mb-4">
                                    <label for="medical_certificate">{{ __('messages.MedicalCertificate') }}: </label>
                                    <input type="file" name="medical_certificate" class="form-control" accept="image/*">
                                    @error('medical_certificate')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>

                                @if (!empty($userData?->medical_certificate))
                                    <div class="form-group mb-2">
                                        <img src="{{ asset( 'application/' .$userData?->medical_certificate) }}"
                                            style="width:250px; height:250px; object-fit:cover" alt="">
                                    </div>
                                @endif

                            </div>

                            <!-- Step 6 final step -->
                            <div class="step">
                                <div class="form-group mb-4">
                                    <label for="applicant_signature">{{ __('messages.ApplicantSignature') }} : </label>
                                    <input type="file" name="applicant_signature" class="form-control" accept="image/*">
                                    @error('applicant_signature')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>

                                @if (!empty($userData?->applicant_signature))
                                    <div class="form-group mb-2">
                                        <img src="{{ asset('application/' .$userData?->applicant_signature) }}"
                                            style="width:250px; height:250px; object-fit:cover" alt="">
                                    </div>
                                @endif
                            </div>

                            <!-- Step 6 final step -->
                            <div class="step">
                                <div class="form-group mb-4">
                                    <label for="applicant_signature">{{ __('messages.InheritanceCertificate') }} :
                                    </label>
                                    <input type="file" name="inheritance_certificate" class="form-control"
                                        accept="image/*">
                                    @error('applicant_signature')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>

                                @if (!empty($userData?->inheritance_certificate))
                                    <div class="form-group mb-2">
                                        <img src="{{ asset('application/' .$userData?->inheritance_certificate) }}"
                                            style="width:250px; height:250px; object-fit:cover" alt="">
                                    </div>
                                @endif
                            </div>

                            <!-- Step 6 final step -->
                            <div class="step">
                                <div class="form-group mb-4">
                                    <label for="applicant_signature">{{ __('messages.PowerOfAttorney') }} : </label>
                                    <input type="file" name="power_of_attorney" class="form-control"
                                        accept="image/*">
                                    @error('applicant_signature')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>

                                @if (!empty($userData?->power_of_attorney))
                                    <div class="form-group mb-2">
                                        <img src="{{ asset('application/' .$userData?->power_of_attorney) }}"
                                            style="width:250px; height:250px; object-fit:cover" alt="">
                                    </div>
                                @endif
                            </div>

                            <button class="btn btn-info">Update</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>

    </div>
@endsection
@push('script')
    <script src="https://cdnjs.cloudflare.com/ajax/libs/axios/1.7.7/axios.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script>
        $('#select_division').on('change', function() {
            let value = $(this).val();
            var selectDistrictText = "{{ __('messages.SelectDistricts') }}"; // Get translated text
            $('#select_district').empty();
            $('#select_district').append(`<option value="">${selectDistrictText}</option>`); // Use translated text

            axios.get('/get-districts/' + value).then(res => {
                let data = res.data;
                data.map(item => {
                    $('#select_district').append(
                        `<option value="${item.id}">${item.bn_name}</option>`
                    );
                });
            });
        });


        let thana = "<?php echo $userData?->upozila_id; ?>"

        const selectThana = (value, thana) => {
            console.log(thana)
            axios.get('/get-thana/' + value).then(res => {
                let data = res.data
                data.map(item => {
                    $('#select_upozila').append(
                        `<option ${thana == item.id ? 'selected' : ''} value="${item.id}">${item.bn_name}</option>`
                    )
                })
            })
        }

        $('#select_district').on('change', function() {
            let value = $(this).val();
            $('#select_upozila').empty()
            selectThana(value)
        })

        selectThana(1)
        console.log(thana)
    </script>

    <script>
        var currentStep = 0;
        showStep(currentStep);

        function showStep(n) {
            var steps = document.getElementsByClassName("step");
            steps[n].classList.add("active");

            // Update the buttons visibility
            if (n == 0) {
                document.getElementById("prevBtn").style.display = "none";
            } else {
                document.getElementById("prevBtn").style.display = "inline";
            }
            if (n == (steps.length - 1)) {
                document.getElementById("nextBtn").style.display = "none";
                document.getElementById("submitBtn").style.display = "inline";
            } else {
                document.getElementById("nextBtn").style.display = "inline";
                document.getElementById("submitBtn").style.display = "none";
            }
        }

        function nextPrev(n) {
            // Prevent moving to the next step if validation fails
            if (n == 1 && !validateForm()) return false;

            var steps = document.getElementsByClassName("step");
            steps[currentStep].classList.remove("active");
            currentStep = currentStep + n;
            showStep(currentStep);
        }

        // Function to validate the form in the current step
        function validateForm() {
            var steps = document.getElementsByClassName("step");
            var inputs = steps[currentStep].getElementsByTagName("input");
            var textareas = steps[currentStep].getElementsByTagName("textarea");
            var selects = steps[currentStep].getElementsByTagName("select");
            var valid = true;

            const optionalFields = [
                'applicant_name', 'relation_with_deceased', 'address',
                'driving_license', 'victim_birthdate', 'victim_driving_license', 'case_dd_number', 'death_date',
                'total_expense', 'current_address',
                'fund_aid', 'medical_certificate', 'death_certificate',
                'victim_driving_license', 'warish_sonod', 'victim_birth_certificate',
                'applicant_nid', 'applicant_birth_certificate', 'victim_nid',
                'non_judicial_stamp', 'applicant_signature'
            ];


            // Loop through all input fields in the current step and check if they are filled
            for (var i = 0; i < inputs.length; i++) {
                const input = inputs[i];
                if (optionalFields.includes(input.name) && input.value === "") {
                    continue; // Skip validation for these fields
                }

                if (inputs[i].hasAttribute('required') && inputs[i].value === "") {
                    inputs[i].classList.add('is-invalid');
                    valid = false;
                } else {
                    inputs[i].classList.remove('is-invalid');
                }
            }

            // Loop through textareas as well
            for (var i = 0; i < textareas.length; i++) {
                if (textareas[i].hasAttribute('required') && textareas[i].value === "") {
                    textareas[i].classList.add('is-invalid');
                    valid = false;
                } else {
                    textareas[i].classList.remove('is-invalid');
                }
            }

            // Loop through textareas as well
            for (var i = 0; i < selects.length; i++) {
                if (selects[i].hasAttribute('required') && selects[i].value === "") {
                    selects[i].classList.add('is-invalid');
                    valid = false;
                } else {
                    selects[i].classList.remove('is-invalid');
                }
            }

            return valid;
        }

        function disableSubmitButton() {
            document.getElementById("submitBtn").disabled = true;
        }
    </script>
@endpush
