@extends('backEnd.master')
@section('title')
   All Application
@endsection

@section('content')
    <!-- Start Breadcrumbbar -->
    <div class="breadcrumbbar">
        <div class="row align-items-center">
            <div class="col-md-8 col-lg-8">
                {{-- <h4 class="page-title">CRM</h4> --}}
                <div class="breadcrumb-list">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Home</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
                        <li class="breadcrumb-item active" aria-current="page">Applicaiton</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <div class="contentbar">
        <div class="row">
            <div class="col-lg-12">
                <div class="card m-b-30">
                    <div class="card-header">
                        <h5 class="card-title">Applications</h5>
                    </div>
                    <div class="card-body">
                        <h6 class="card-subtitle">Export data to Copy, CSV, Excel & Note.</h6>
                        <div class="table-responsive">
                            <table id="datatable-buttons" class="table table-bordered text-black">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Reference Number</th>
                                        <th>Applicant Name</th>
                                        <th>Phone</th>
                                        {{-- @if (Auth::user()->uno_type == 'divi') --}}
                                        <th>Division</th>
                                        {{-- @endif --}}
                                        <th>District</th>
                                        <th>Upazilas</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>

                                <tbody>
                                    @foreach ($application as $row)
                                        <tr>
                                            <td>{{ $loop->iteration }}</td>
                                            <td>{{ $row?->reference_number }}</td>
                                            <td>{{ $row?->applicant_name }}</td>
                                            <td>{{ $row?->phone }}</td>
                                            {{-- @if (Auth::user()->uno_type == 'divi') --}}
                                                <td>{{ $row?->division?->name }}</td>
                                            {{-- @endif --}}
                                            <td>{{ $row?->district?->name }}</td>
                                            <td>{{ $row?->upozila?->name }}</td>
                                            <td>
                                                <a href="{{ route('user-applications.show', $row->reference_number) }}"
                                                    class="btn btn-primary">
                                                    Details
                                                </a>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
