@extends('backEnd.master')
@section('title')
    Dashboard
@endsection

@section('content')
    <!-- Start Breadcrumbbar -->
    <div class="breadcrumbbar">
        <div class="row align-items-center">
            <div class="col-md-8 col-lg-8">
                {{-- <h4 class="page-title">CRM</h4> --}}
                <div class="breadcrumb-list">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="index.html">Home</a></li>
                        <li class="breadcrumb-item"><a href="#">Dashboard</a></li>
                        <li class="breadcrumb-item active" aria-current="page">Applicaiton</li>
                    </ol>
                </div>
            </div>
            <div class="col-md-4">
                <button type="button" class="btn btn-info" onclick="printContent()">
                    download
                </button>
            </div>
        </div>
    </div>

    <div class="contentbar">
        <div class="row">
            <div class="col-lg-12">
                <div class="card m-b-30">
                    <div class="card-header">
                        <h5 class="card-title">Application Details</h5>
                    </div>
                    <div class="card-body">
                        <table class="table table-bordered text-black" id="printableArea">
                            <tbody>
                                <thead>
                                    <tr>
                                        <th>রেফারেন্স নম্বর</th>
                                        <td>#{{ $application?->reference_number }}</td>
                                    </tr>
                                    <tr>
                                        <th>বিভাগ</th>
                                        <td>{{ $application?->division?->name }}</td>
                                    </tr>
                                    <tr>
                                        <th>জেলা</th>
                                        <td>{{ $application?->district?->name }}</td>
                                    </tr>
                                    <tr>
                                        <th>থানা</th>
                                        <td>{{ $application?->upozila?->name }}</td>
                                    </tr>
                                    <tr>
                                        <th>দুর্ঘটনায় ক্ষতিগ্রস্ত ব্যক্তির নাম</th>
                                        <td>{{ $application?->victim_name }}</td>
                                    </tr>
                                    <tr>
                                        <th>পিতা/স্বামী/স্ত্রী</th>
                                        <td> {{ $application?->relation == 'father' ? 'পিতা' : ($application?->relation == 'husewife' ? 'স্ত্রী' : 'স্বামী') }}:
                                            {{ $application?->father_husband_name }}</td>
                                    </tr>
                                    <tr>
                                        <th>মাতার নাম</th>
                                        <td>{{ $application?->mother_name }}</td>
                                    </tr>
                                    <tr>
                                        <th>মৃত ব্যক্তির ক্ষেত্রে আবেদনকারীর নাম</th>
                                        <td>{{ $application?->applicant_name }}</td>
                                    </tr>
                                    <tr>
                                        <th>আবেদনকারীর সাথে মৃত ব্যক্তির সম্পর্ক</th>
                                        <td>{{ $application?->relation_with_deceased }}</td>
                                    </tr>
                                    <tr>
                                        <th>দুর্ঘটনায় কবলিত ব্যক্তির জন্ম তারিখ/বয়স</th>
                                        <td>{{ $application?->victim_birthdate }}</td>
                                    </tr>
                                    <tr>
                                        <th>ক্ষতিগ্রস্ত ব্যক্তির জন্ম সনদ</th>
                                        <td>
                                            @if (!empty($application?->victim_birth_certificate))
                                                <img src="{{ asset('storage/' . $application?->victim_birth_certificate) }}"
                                                    style="width:250px; height:250px; object-fit:cover" alt="">
                                            @endif

                                        </td>
                                    </tr>
                                    <tr>
                                        <th>জাতীয় পরিচয়পত্রের নম্বর</th>
                                        <td>{{ $application?->national_id }}</td>
                                    </tr>
                                    <tr>
                                        <th>জাতীয় পরিচয়পত্র (ছবি)</th>
                                        <td>
                                            @if (!empty($application?->applicant_nid))
                                                <img src="{{ asset('storage/' . $application?->applicant_nid) }}"
                                                    style="width:250px; height:250px; object-fit:cover" alt="">
                                            @endif

                                        </td>
                                    </tr>
                                    <tr>
                                        <th>ড্রাইভিং লাইসেন্স নম্বর (চালকের ক্ষেত্রে) ও মেয়াদ</th>
                                        <td>{{ $application?->driving_license }}</td>
                                    </tr>
                                    <tr>
                                        <th>ক্ষতিগ্রস্ত ব্যক্তির ড্রাইভিং লাইসেন্স: (অফশনাল)</th>
                                        <td>
                                            @if (!empty($application?->victim_driving_license))
                                                <img src="{{ asset('storage/' . $application?->victim_driving_license) }}"
                                                    style="width:250px; height:250px; object-fit:cover" alt="">
                                            @endif

                                        </td>
                                    </tr>
                                    <tr>
                                        <th>ড্রাইভিং লাইসেন্স নম্বর (চালকের ক্ষেত্রে) ও মেয়াদ</th>
                                        <td>{{ $application?->driving_license }}</td>
                                    </tr>
                                    <tr>
                                        <th>ঠিকানা</th>
                                        <td>{{ $application?->address }}</td>
                                    </tr>
                                    <tr>
                                        <th>ঠিকানা</th>
                                        <td>{{ $application?->address }}</td>
                                    </tr>
                                    <tr>
                                        <th>দুর্ঘটনার স্থানসহ বিবরণ</th>
                                        <td>{!! $application?->accident_description !!}</td>
                                    </tr>
                                    <tr>
                                        <th>দুর্ঘটনার তারিখ ও সময়</th>
                                        <td>
                                            {{ $application?->accident_date_time ? \Carbon\Carbon::parse($application->accident_date_time)->format('d M Y H:i:s') : 'N/A' }}
                                        </td>

                                    </tr>
                                    <tr>
                                        <th>দুর্ঘটনার মামলার বা জিডি নম্বর</th>
                                        <td>#{{ $application?->case_dd_number }}</td>
                                    </tr>
                                    <tr>
                                        <th>দুর্ঘটনার জিডির কপি</th>
                                        <td>
                                            @if (!empty($application?->gd_stamp))
                                                <img src="{{ asset('storage/' . $application?->gd_stamp) }}"
                                                    style="width:250px; height:250px; object-fit:cover" alt="">
                                            @endif

                                        </td>
                                    </tr>
                                    <tr>
                                        <th>মৃত ব্যক্তির ক্ষেত্রে মৃত্যুর তারিখ (মৃত্যু সনদ সংযুক্ত):</th>
                                        <td>
                                            {{ $application?->death_date ? \Carbon\Carbon::parse($application->death_date)->format('d M Y H:i:s') : 'N/A' }}
                                        </td>
                                    </tr>
                                    <tr>
                                        <th>সংশ্লিষ্ট এলাকার মৃত্যু সনদ</th>
                                        <td>
                                            @if (!empty($application?->death_certificate))
                                                <img src="{{ asset('storage/' . $application?->death_certificate) }}"style="width:250px; height:250px; object-fit:cover"
                                                    alt="">
                                            @endif

                                        </td>
                                    </tr>
                                    <tr>
                                        <th>অসুস্থতা ও চিকিৎসার সংক্ষিপ্ত বিবরণ</th>
                                        <td>{{ $application?->sick_short_details }}</td>
                                    </tr>
                                    <tr>
                                        <th>মোট খরচের পরিমাণ (প্রমাণকসহ)</th>
                                        <td>{{ $application?->total_expense }}tk</td>
                                    </tr>
                                    <tr>
                                        <th>হাসপাতালের মেডিকেল সার্টিফিকেট</th>
                                        <td>
                                            @if (!empty($application?->medical_certificate))
                                                <img src="{{ asset('storage/' . $application?->medical_certificate) }}"
                                                    style="width:250px; height:250px; object-fit:cover" alt="">
                                            @endif

                                        </td>
                                    </tr>
                                    <tr>
                                        <th>বর্তমান ঠিকানা</th>
                                        <td>{{ $application?->current_address }}</td>
                                    </tr>
                                    <tr>
                                        <th>বর্তমান ঠিকানা</th>
                                        <td>{{ $application?->current_address }}</td>
                                    </tr>
                                    <tr>
                                        <th>আর্থিক সহায়তা তহবিল হইতে গত /চলতি অর্থ বৎসরে কোনো অনুদান পাইয়া থাকিলে অনুদান
                                            প্রাপ্তির খাতের নাম ও টাকার পরিমান</th>
                                        <td>{{ $application?->fund_aid }}</td>
                                    </tr>
                                    <tr>
                                        <th>আবেদনকারীর স্বাক্ষর</th>
                                        <td>
                                            @if (!empty($application?->applicant_signature))
                                                <img src="{{ asset('storage/' . $application?->applicant_signature) }}"
                                                    style="width:250px; height:250px; object-fit:cover" alt="">
                                            @endif

                                        </td>
                                    </tr>
                                </thead>
                            </tbody>
                        </table>

                        <a href="{{ route('applications.index') }}">
                            <button class="btn btn-sm btn-info">Back</button>
                        </a>
                    </div>
                </div>
            </div>
        </div>

    </div>

    @push('script')
        <script>
            function printContent() {
                printJS({
                    printable: 'printableArea',
                    type: 'html',
                    css: 'https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css'
                });
            }
        </script>
    @endpush
@endsection
