
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="description" content="Orbiter is a bootstrap minimal & clean admin template">
    <meta name="keywords" content="admin, admin panel, admin template, admin dashboard, responsive, bootstrap 4, ui kits, ecommerce, web app, crm, cms, html, sass support, scss">
    <meta name="author" content="Themesbox">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0, minimal-ui">
    <title>Register</title>
    <!-- Fevicon -->
    <link rel="shortcut icon" href="{{asset('images/logo.png') }}">
    <!-- Start css -->
    <link href="{{asset('backEnd')}}/assets/css/bootstrap.min.css" rel="stylesheet" type="text/css">
    <link href="{{asset('backEnd')}}/assets/css/icons.css" rel="stylesheet" type="text/css">
    <link href="{{asset('backEnd')}}/assets/css/style.css" rel="stylesheet" type="text/css">
    <link rel="stylesheet" href="{{asset('backEnd')}}/iziToast/dist/css/iziToast.min.css">
    
</head>
<body class="vertical-layout">
<!-- Start Containerbar -->
<div id="containerbar" class="containerbar authenticate-bg">
    <!-- Start Container -->
    <div class="container">
        <div class="auth-box login-box">
            <!-- Start row -->
            <div class="row no-gutters align-items-center justify-content-center">
                <!-- Start col -->
                <div class="col-md-6 col-lg-5">
                    <!-- Start Auth Box -->
                    <div class="auth-box-right">
                        <div class="card">
                            <div class="card-body">
                                <form action="{{route('register')}}" method="post">
                                    @csrf
                                    <h4 class="text-primary my-4">Register !</h4>
                                    <div class="form-group text-left">
                                        <label for="name">Name</label>
                                        <input type="text" class="form-control" id="name" name="name" placeholder="Enter Username here" required value="{{old('name')}}">
                                    </div>
                                    <div class="form-group text-left">
                                        <label for="phone">Phone</label>
                                        <input type="number" class="form-control" id="phone" name="phone" placeholder="Enter phone here" required value="{{old('phone')}}">
                                    </div>
                                    <div class="form-group text-left">
                                        <label for="password">Password</label>
                                        <input type="password" class="form-control" id="password" name="password" placeholder="Enter Password here" required>
                                    </div>
                                    <div class="form-group text-left">
                                        <label for="confirmed_password">Confirmation Password</label>
                                        <input type="password" class="form-control" id="confirmed_password"    name="password_confirmation" placeholder="Enter Password here" required>
                                    </div>
                                    <div class="form-row mb-3">
                                        <div class="col-sm-12">
                                            <div class="custom-control  text-left">
                                                <label class="font-14"> <a href="{{ route('login') }}">Already have an account?</a> </label>
                                            </div>
                                        </div>
                                    </div>
                                    <button type="submit" class="btn btn-success btn-lg btn-block font-18">Register</button>
                                </form>
                            </div>
                        </div>
                    </div>
                    <!-- End Auth Box -->
                </div>
                <!-- End col -->
            </div>
            <!-- End row -->
        </div>
    </div>
    <!-- End Container -->
</div>
<!-- End Containerbar -->
<!-- Start js -->
<script src="{{asset('backEnd')}}/assets/js/jquery.min.js"></script>
<script src="{{asset('backEnd')}}/assets/js/popper.min.js"></script>
<script src="{{asset('backEnd')}}/assets/js/bootstrap.min.js"></script>
<script src="{{asset('backEnd')}}/assets/js/modernizr.min.js"></script>
<script src="{{asset('backEnd')}}/assets/js/detect.js"></script>
<script src="{{asset('backEnd')}}/assets/js/jquery.slimscroll.js"></script>
<script src="{{asset('backEnd')}}/iziToast/dist/js/iziToast.min.js"></script>

@if($errors->any())
    @foreach($errors->all() as $error)
        <script>
            iziToast.error({
                title: '',
                position:'topRight',
                message: '{{$error}}',
            });
        </script>
    @endforeach

@endif

@if(session()->get('success'))
    <script>
        iziToast.success({
            title: '',
            position:'topRight',
            message: '{{session()->get('success')}}',
        });

    </script>
@endif

@if(session()->get('error'))
    <script>
        iziToast.error({
            title: '',
            position:'topRight',
            message: '{{session()->get('error')}}',
        });
    </script>
@endif
</body>
</html>
