<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="description" content="Orbiter is a bootstrap minimal & clean admin template">
    <meta name="keywords"
        content="admin, admin panel, admin template, admin dashboard, responsive, bootstrap 4, ui kits, ecommerce, web app, crm, cms, html, sass support, scss">
    <meta name="author" content="Themesbox">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0, minimal-ui">
    <title>Login</title>
    <!-- Fevicon -->
    <link rel="shortcut icon" href="{{asset('images/logo.png') }}">
    <!-- Start css -->
    <link href="{{asset('backEnd')}}/assets/css/bootstrap.min.css" rel="stylesheet" type="text/css">
    <link href="{{asset('backEnd')}}/assets/css/icons.css" rel="stylesheet" type="text/css">
    <link href="{{asset('backEnd')}}/assets/css/style.css" rel="stylesheet" type="text/css">
    <link rel="stylesheet" href="{{asset('backEnd')}}/iziToast/dist/css/iziToast.min.css">
    <!-- End css -->
</head>

<body class="vertical-layout">
    <!-- Start Containerbar -->
    <div id="containerbar" class="containerbar authenticate-bg">
        <!-- Start Container -->
        <div class="container">
            <div class="auth-box login-box">
                <!-- Start row -->
                <div class="row no-gutters align-items-center justify-content-center">
                    <!-- Start col -->
                    <div class="col-md-6 col-lg-5">
                        <!-- Start Auth Box -->
                        <div class="auth-box-right">
                            <div class="card">
                                <div class="card-body">
                                    <form action="{{route('login')}}" method="post">
                                        @csrf
                                        <div class="form-head">
                                            <a href="{{ route('home') }}" class="logo"><img src="{{asset('images/logo.png')}}"
                                                    class="img-fluid" alt="logo"></a>
                                        </div>
                                        <h4 class="text-primary my-4">Log in !</h4>
                                        <div class="form-group">
                                            <input type="text" class="form-control" id="email" name="email"
                                                placeholder="Enter email here" required value="{{old('username')}}">
                                        </div>
                                        <div class="form-group">
                                            <input type="password" class="form-control" id="password" name="password"
                                                placeholder="Enter Password here" required>
                                        </div>
                                        <div class="form-row mb-3">
                                            <div class="col-sm-6">
                                                <div class="custom-control custom-checkbox text-left">
                                                    <input type="checkbox" class="custom-control-input" id="rememberme">
                                                    <label class="custom-control-label font-14"
                                                        for="rememberme">Remember Me</label>
                                                </div>
                                            </div>
                                            <div class="col-sm-6">
                                                <div class="forgot-psw">
                                                    <a id="forgot-psw" href="{{route('password.request')}}"
                                                        class="font-14">Forgot Password?</a>
                                                </div>
                                            </div>
                                        </div>
                                        <button type="submit" class="btn btn-success btn-lg btn-block font-18">Log
                                            in</button>
                                    </form>
                                </div>
                            </div>
                        </div>
                        <!-- End Auth Box -->
                    </div>
                    <!-- End col -->
                </div>
                <!-- End row -->
            </div>
        </div>
        <!-- End Container -->
    </div>
    <!-- End Containerbar -->
    <!-- Start js -->
    <script src="{{asset('backEnd')}}/assets/js/jquery.min.js"></script>
    <script src="{{asset('backEnd')}}/assets/js/popper.min.js"></script>
    <script src="{{asset('backEnd')}}/assets/js/bootstrap.min.js"></script>
    <script src="{{asset('backEnd')}}/assets/js/modernizr.min.js"></script>
    <script src="{{asset('backEnd')}}/assets/js/detect.js"></script>
    <script src="{{asset('backEnd')}}/assets/js/jquery.slimscroll.js"></script>
    <script src="{{asset('backEnd')}}/iziToast/dist/js/iziToast.min.js"></script>

    @if($errors->any())
    @foreach($errors->all() as $error)
    <script>
    iziToast.error({
        title: '',
        position: 'topRight',
        message: '{{$error}}',
    });
    </script>
    @endforeach

    @endif

    @if(session()->get('success'))
    <script>
    iziToast.success({
        title: '',
        position: 'topRight',
        message: '{{session()->get('
        success ')}}',
    });
    </script>
    @endif

    @if(session()->get('error'))
    <script>
    iziToast.error({
        title: '',
        position: 'topRight',
        message: '{{session()->get('
        error ')}}',
    });
    </script>
    @endif
</body>

</html>