<?php

namespace Database\Seeders;

use App\Enum\UserType;
use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class UsersTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $users = [
            // Khulna Division
            ['division_id' => '3', 'district_id' => '27', 'designation' => 'পরিচালক (ইঞ্জিনিয়ারিং) পিএএ', 'name' => 'মোঃ জিয়াউর রহমান পিএএ', 'email' => 'de_khulna@brta.gov.bd', 'uno_type' => 'divi', 'phone' => '01550053903', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],

            ['division_id' => '3', 'district_id' => '27', 'designation' => 'উপপরিচালক (ইঞ্জিনিয়ারিং)চঃদাঃ', 'name' => 'মোঃ আতিকুর রহমান', 'email' => 'dd_khulna@brta.gov.bd', 'uno_type' => 'district', 'phone' => '01966622024', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],

            ['division_id' => '3', 'district_id' => '27', 'designation' => 'সহকারী পরিচালক (ইঞ্জিনিয়ারিং)', 'name' => 'তানভির আহমেদ', 'email' => 'ad_khulna@brta.gov.bd', 'uno_type' => 'district', 'phone' => '01966622075', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],

            ['division_id' => '3', 'district_id' => '20', 'name' => 'এস.এম. মাহফুজুর রহমান', 'designation' => 'সহকারী পরিচালক (ইঞ্জিনিয়ারিং)', 'email' => 'ade_jashore@brta.gov.bd', 'uno_type' => 'district', 'phone' => '01966622078', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],
            ['division_id' => '3', 'district_id' => '20', 'name' => 'এস.এম. মাহফুজুর রহমান', 'designation' => 'সহকারী পরিচালক (ইঞ্জিনিয়ারিং)', 'email' => 'ad_narail@brta.gov.bd', 'uno_type' => 'district', 'phone' => '01550053890', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],
            ['division_id' => '3', 'district_id' => '21', 'name' => 'কে.এম. মাহবুব কবীর', 'designation' => 'সহকারী পরিচালক (ইঞ্জিনিয়ারিং)', 'email' => 'ad_satkhira@brta.gov.bd', 'uno_type' => 'district', 'phone' => '01966622077', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],
            ['division_id' => '3', 'district_id' => '24', 'name' => 'মোঃ আতিয়ার রহমান', 'designation' => 'সহকারী পরিচালক (ইঞ্জিনিয়ারিং)', 'email' => 'ad_chuadanga@brta.gov.bd', 'uno_type' => 'district', 'phone' => '01550051642', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],
            ['division_id' => '3', 'district_id' => '29', 'name' => 'মোঃ আতিয়ার রহমান', 'designation' => 'সহকারী পরিচালক (ইঞ্জিনিয়ারিং)', 'email' => 'ad_jhenaidaha@brta.gov.bd', 'uno_type' => 'district', 'phone' => '01966622079', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],

            ['division_id' => '3', 'district_id' => '22', 'name' => 'মোঃ জাহাঙ্গীর আলম', 'designation' => 'সহকারী পরিচালক (ইঞ্জিনিয়ারিং)', 'email' => 'ad_meherpur@brta.gov.bd', 'uno_type' => 'district', 'phone' => '01550051651', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],
            ['division_id' => '3', 'district_id' => '25', 'name' => 'মোঃ জাহাঙ্গীর আলম', 'email' => 'ad_kushtia@brta.gov.bd', 'uno_type' => 'district', 'designation' => 'সহকারী পরিচালক (ইঞ্জিনিয়ারিং)', 'phone' => '01550051652', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],
            ['division_id' => '3', 'district_id' => '26', 'designation' => 'সহকারী পরিচালক (ইঞ্জিনিয়ারিং)', 'name' => 'মহাঃ মাছুদুর রহমান জোয়ার্দ্দার', 'email' => 'ad_magura@brta.gov.bd', 'uno_type' => 'district', 'phone' => '01966622080', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],
            ['division_id' => '3', 'district_id' => '28', 'designation' => 'সহকারী পরিচালক (ইঞ্জিনিয়ারিং)', 'name' => 'লাইলাতুল মাওয়া', 'email' => 'ad_bagerhat@brta.gov.bd', 'uno_type' => 'district', 'phone' => '01550051653', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],

            // Rajshahi Division

            ['division_id' => '2', 'district_id' => '15', 'designation' => 'পরিচালক (ইঞ্জিনিয়ারিং)', 'name' => 'শফিকুজ্জামান ভূঞা', 'email' => 'de_rajshahi@brta.gov.bd', 'uno_type' => 'divi', 'phone' => '01550053902', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],

            ['division_id' => '2', 'district_id' => '15', 'designation' => 'উপপরিচালক (ইঞ্জিনিয়ারিং)', 'name' => 'এ. এস. এম. কামরুল হাসান', 'email' => 'dde_rajshahi@brta.gov.bd', 'uno_type' => 'district', 'phone' => '01550051609', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],

            ['division_id' => '2', 'district_id' => '15', 'designation' => 'সহকারী পরিচালক (ইঞ্জিনিয়ারিং)', 'name' => 'আবদূর রশিদ', 'email' => 'ad_rajshahi@brta.gov.bd', 'uno_type' => 'district', 'phone' => '01972807280', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],
            ['division_id' => '2', 'district_id' => '18', 'designation' => 'সহকারী পরিচালক (ইঞ্জিনিয়ারিং)', 'name' => 'মোঃ শাহজামান', 'email' => 'ad_nawabganj@brta.gov.bd', 'uno_type' => 'district', 'phone' => '01550053885', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],

            ['division_id' => '2', 'district_id' => '19', 'designation' => 'সহকারী পরিচালক (ইঞ্জিনিয়ারিং)', 'name' => 'ফয়সাল হাসান', 'email' => 'ad_naogaon@brta.gov.bd', 'uno_type' => 'district', 'phone' => '01958659670', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],
            ['division_id' => '2', 'district_id' => '13', 'designation' => 'সহকারী পরিচালক (ইঞ্জিনিয়ারিং)', 'name' => 'মোঃ আব্দুল হালিম', 'email' => 'ad_pabna@brta.gov.bd', 'uno_type' => 'district', 'phone' => '01966622067', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],
            ['division_id' => '2', 'district_id' => '14', 'designation' => 'সহকারী পরিচালক (ইঞ্জিনিয়ারিং)', 'name' => 'আব্দুল্লাহ আল মামুন', 'email' => 'ad_bogura@brta.gov.bd', 'uno_type' => 'district', 'phone' => '01710236687', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],
            ['division_id' => '2', 'district_id' => '12', 'designation' => 'সহকারী পরিচালক (ইঞ্জিনিয়ারিং)', 'name' => 'মোঃ আলতাব হোসেন', 'email' => 'ad_sirajganj@brta.gov.bd', 'uno_type' => 'district', 'phone' => '01726316141', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],
            ['division_id' => '2', 'district_id' => '16', 'designation' => 'সহকারী পরিচালক (ইঞ্জিনিয়ারিং)', 'name' => 'আব্দুল্লাহ আল মামুন', 'email' => 'ad_natore@brta.gov.bd', 'uno_type' => 'district', 'phone' => '01710236687', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],
            ['division_id' => '2', 'district_id' => '17', 'designation' => 'সহকারী পরিচালক (ইঞ্জিনিয়ারিং) অঃ দাঃ', 'name' => 'মোঃ কাফিউল হাসান মৃধা', 'email' => 'ad_joypurhat@brta.gov.bd', 'uno_type' => 'district', 'phone' => '01973778227', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],

            // Sylhet Division

            ['division_id' => '5', 'district_id' => '36', 'designation' => 'পরিচালক (ইঞ্জিনিয়ারিং)', 'name' => 'মোঃ মাসুদ আলম', 'email' => 'de_sylhet@brta.gov.bd', 'uno_type' => 'divi', 'phone' => '01550053904', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],
            ['division_id' => '5', 'district_id' => '36', 'designation' => 'উপপরিচালক (ইঞ্জিনিয়ারিং)', 'name' => 'মোঃ ডালিম উদ্দীন', 'email' => 'dd_sylhet@brta.gov.bd', 'uno_type' => 'district', 'phone' => '01550051610', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],
            ['division_id' => '5', 'district_id' => '36', 'designation' => 'সহকারী পরিচালক (ইঞ্জিনিয়ারিং)', 'name' => 'মোঃ রিয়াজুল ইসলাম', 'email' => 'ad_sylhet@brta.gov.bd', 'uno_type' => 'district', 'phone' => '01966622083', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],
            ['division_id' => '5', 'district_id' => '37', 'designation' => 'সহকারী পরিচালক (ইঞ্জিনিয়ারিং)', 'name' => 'মু: হাবিবুর রহমান', 'email' => 'ad_moulvibazar@brta.gov.bd', 'uno_type' => 'district', 'phone' => '01966622085', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],
            ['division_id' => '5', 'district_id' => '39', 'designation' => 'সহকারী পরিচালক (ইঞ্জিনিয়ারিং)', 'name' => 'মোঃ রিয়াজুল ইসলাম', 'email' => 'ad_sunamganj@brta.gov.bd', 'uno_type' => 'district', 'phone' => '01550051654', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],
            ['division_id' => '5', 'district_id' => '38', 'designation' => 'সহকারী পরিচালক (ইঞ্জিনিয়ারিং)', 'name' => 'মু: হাবিবুর রহমান', 'email' => 'ad_habiganj@brta.gov.bd', 'uno_type' => 'district', 'phone' => '01966622084', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],

            // Chattogram Division
            ['division_id' => '1', 'district_id' => '8', 'designation' => 'পরিচালক (ইঞ্জিনিয়ারিং)', 'name' => 'মোঃ মাসুদ আলম', 'email' => 'de_chattogram@brta.gov.bd', 'uno_type' => 'divi', 'phone' => '01550053901', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],
            ['division_id' => '1', 'district_id' => '8', 'designation' => 'উপপরিচালক (ইঞ্জিনিয়ারিং)', 'name' => 'সৈয়দ আইনুল হুদা চৌধুরী', 'email' => 'dd_ctg@brta.gov.bd', 'uno_type' => 'district', 'phone' => '01550709946', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],
            ['division_id' => '1', 'district_id' => '8', 'designation' => 'সহকারী পরিচালক (ইঞ্জিনিয়ারিং)', 'name' => 'আতিকুর রহমান', 'email' => 'ade_ctgdiv@brta.gov.bd', 'uno_type' => 'district', 'phone' => '01550056582', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],
            ['division_id' => '1', 'district_id' => '8', 'designation' => 'সহকারী পরিচালক (সাধারণ) ', 'name' => 'আমির খসরু ভুঁঞা', 'email' => 'adg_chattogram@brta.gov.bd', 'uno_type' => 'district', 'phone' => '01911270451', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],
            ['division_id' => '1', 'district_id' => '8', 'designation' => 'উপপরিচালক (ইঞ্জিঃ)', 'name' => 'তৌহিদুল ইসলাম', 'email' => 'ad_ctg_metro@brta.gov.bd', 'uno_type' => 'district', 'phone' => '015500516224', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],
            ['division_id' => '1', 'district_id' => '8', 'designation' => 'উপপরিচালক (ইঞ্জিঃ)', 'name' => 'সৈয়দ আইনুল হুদা চৌধুরী', 'email' => 'dde_cm2@brta.gov.bd', 'uno_type' => 'district', 'phone' => '01550709946', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],
            ['division_id' => '1', 'district_id' => '8', 'designation' => 'সহকারী পরিচালক (ইঞ্জিঃ) ', 'name' => 'মোঃ ওমর ফারুক', 'email' => 'ad2_ctg@brta.gov.bd', 'uno_type' => 'district', 'phone' => '01827174442', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],
            ['division_id' => '1', 'district_id' => '8', 'designation' => 'সহকারী পরিচালক (ইঞ্জিঃ) ', 'name' => 'বেগম রায়হানা আক্তার উথী', 'email' => 'ad1_ctg@brta.gov.bd', 'uno_type' => 'district', 'phone' => '01966622050', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],
            ['division_id' => '1', 'district_id' => '9', 'designation' => 'সহকারী পরিচালক (ইঞ্জিঃ) ', 'name' => 'উথোয়াইনু চৌধরী', 'email' => 'ad_coxsbazar@brta.gov.bd', 'uno_type' => 'district', 'phone' => '015500516245', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],
            ['division_id' => '1', 'district_id' => '11', 'designation' => 'সহকারী পরিচালক (ইঞ্জিঃ অঃ দাঃ) ', 'name' => 'বেগম রায়হানা আক্তার উথী', 'email' => 'ad_bandarban@brta.gov.bd', 'uno_type' => 'district', 'phone' => '01550051647', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],
            ['division_id' => '1', 'district_id' => '4', 'name' => 'উসমান সারওয়ার আলম', 'email' => 'ad_rangamati@brta.gov.bd', 'uno_type' => 'district', 'phone' => '01966622053', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],
            ['division_id' => '1', 'district_id' => '10', 'designation' => 'উপপরিচালক (ইঞ্জিঃ)', 'name' => 'মোঃ ওমর ফারুক', 'email' => 'ad_khagrachhari@brta.gov.bd', 'uno_type' => 'district', 'phone' => '01966622053', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],
            ['division_id' => '1', 'district_id' => '5', 'designation' => 'সহকারী পরিচালক (ইঞ্জিঃ অঃদাঃ) ', 'name' => 'আতিকুর রহমান', 'email' => 'ad_noakhali@brta.gov.bd', 'uno_type' => 'district', 'phone' => '01550051641', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],
            ['division_id' => '1', 'district_id' => '2', 'designation' => 'সহকারী পরিচালক (ইঞ্জিঃ) ', 'name' => 'আতিকুর রহমান', 'email' => 'ad_feni@brta.gov.bd', 'uno_type' => 'district', 'phone' => '01966622056', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],
            ['division_id' => '1', 'district_id' => '7', 'designation' => 'সহকারী পরিচালক (ইঞ্জিঃ) ', 'name' => 'মোঃ কামরুজ্জামান-১', 'email' => 'ad_lakshmipur@brta.gov.bd', 'uno_type' => 'district', 'phone' => '01550051641', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],
            ['division_id' => '1', 'district_id' => '1', 'designation' => 'সহকারী পরিচালক (ইঞ্জিঃ) ', 'name' => 'মোঃ ফারুক আলম', 'email' => 'ad_cumilla@brta.gov.bd', 'uno_type' => 'district', 'phone' => '01712003154', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],
            ['division_id' => '1', 'district_id' => '6', 'designation' => 'সহকারী পরিচালক (ইঞ্জিঃ) ', 'name' => 'আনোয়ার হোসেন', 'email' => 'ad_chandpur@brta.gov.bd', 'uno_type' => 'district', 'phone' => '01966622059', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],
            ['division_id' => '1', 'district_id' => '3', 'designation' => 'সহকারী পরিচালক (ইঞ্জিঃ) ', 'name' => 'মোঃ আবু আশরাফ সিদ্দিকী', 'email' => 'ad_bbaria@brta.gov.bd', 'uno_type' => 'district', 'phone' => '01926604090', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],

            // Barishal Division

            ['division_id' => '4', 'district_id' => '33', 'designation' => 'পরিচালক (ইঞ্জিনিয়ারিং)', 'name' => 'মোঃ জিয়াউর রহমান', 'email' => 'de_barishal@brta.gov.bd', 'uno_type' => 'divi', 'phone' => '01550053905', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],
            ['division_id' => '4', 'district_id' => '33', 'designation' => 'উপপরিচালক (ইঞ্জিনিয়ারিং)', 'name' => 'নাই', 'email' => 'dde_barishal@brta.gov.bd', 'uno_type' => 'district', 'phone' => '01550051611', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],
            ['division_id' => '4', 'district_id' => '33', 'designation' => 'সহকারী পরিচালক (সাধারণ)', 'name' => 'কাজী মোঃ শামছুল হক', 'email' => 'adg_barishaldiv@brta.gov.bd', 'uno_type' => 'district', 'phone' => '01726049406', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],
            ['division_id' => '4', 'district_id' => '33', 'designation' => 'সহকারী পরিচালক (ইঞ্জিঃ)-(অঃদাঃ) ', 'name' => 'দেবাশীষ বিশ্বাস', 'email' => 'ade_barishal@brta.gov.bd', 'uno_type' => 'district', 'phone' => '01724430691', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],
            ['division_id' => '4', 'district_id' => '30', 'designation' => 'সহকারী পরিচালক (ইঞ্জিঃ)-(অঃদাঃ) ', 'name' => 'এস এম মাহাবুবুর রহমান', 'email' => 'ade_jhalakathi@brta.gov.bd', 'uno_type' => 'district', 'phone' => '01550053888', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],
            ['division_id' => '4', 'district_id' => '32', 'designation' => 'সহকারী পরিচালক (ইঞ্জিঃ)-(অঃদাঃ) ', 'name' => 'মোঃ মেহেদী হাসান', 'email' => 'ad_pirojpur@brta.gov.bd', 'uno_type' => 'district', 'phone' => '01550053886', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],
            ['division_id' => '4', 'district_id' => '31', 'designation' => 'সহকারী পরিচালক (ইঞ্জিঃ)-(অঃদাঃ) ', 'name' => 'মোঃ মাহফুজ হোসেন', 'email' => 'ad_patuakhali@brta.gov.bd', 'uno_type' => 'district', 'phone' => '01550053886', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],
            ['division_id' => '4', 'district_id' => '35', 'designation' => 'সহকারী পরিচালক (ইঞ্জিঃ)-(অঃদাঃ) ', 'name' => 'মোঃ মাহফুজ হোসেন', 'email' => 'ad_barguna@brta.gov.bd', 'uno_type' => 'district', 'phone' => '01550053886', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],
            ['division_id' => '4', 'district_id' => '34', 'designation' => 'সহকারী পরিচালক (ইঞ্জিঃ) ', 'name' => 'এস এম মাহাবুবুর রহমান', 'email' => 'ad_bhola@brta.gov.bd', 'uno_type' => 'district', 'phone' => '01550051656', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],

            // mymensingh Division

            ['division_id' => '8', 'district_id' => '62', 'designation' => 'পরিচালক (ইঞ্জিনিয়ারিং)', 'name' => 'নাই', 'email' => 'de_mymensingh@brta.gov.bd', 'uno_type' => 'divi', 'phone' => '01550053907', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],
            ['division_id' => '8', 'district_id' => '62', 'designation' => 'উপপরিচালক (ইঞ্জিনিয়ারিং)', 'name' => 'সৈয়দ মেজবাহ উদ্দিন', 'email' => 'dde_mymensingh@brta.gov.bd', 'uno_type' => 'district', 'phone' => '01550053908', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],
            ['division_id' => '8', 'district_id' => '62', 'designation' => 'সহকারী পরিচালক (সাধারণ) ', 'name' => 'মোঃ সিরাজুল ইসলাম', 'email' => 'adg_mymensingh@brta.gov.bd', 'uno_type' => 'district', 'phone' => '01611749123', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],
            ['division_id' => '8', 'district_id' => '62', 'designation' => 'সহকারী পরিচালক (ইঞ্জিনিয়ারিং)', 'name' => 'এ এস এম ওয়াজেদ হোসেন', 'email' => 'ad_mymensingh@brta.gov.bd', 'uno_type' => 'district', 'phone' => '01550051637', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],
            ['division_id' => '8', 'district_id' => '61', 'designation' => 'সহকারী পরিচালক (ইঞ্জিঃ) ', 'name' => 'মো আনোয়ারুল  কিবরিয়া', 'email' => 'ad_sherpur@brta.gov.bd', 'uno_type' => 'district', 'phone' => '01550051636', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],
            ['division_id' => '8', 'district_id' => '63', 'designation' => 'সহকারী পরিচালক (ইঞ্জিঃ) ', 'name' => 'মো আবু নাঈম', 'email' => 'ad_jamalpur@brta.gov.bd', 'uno_type' => 'district', 'phone' => '01550051638', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],
            ['division_id' => '8', 'district_id' => '64', 'designation' => 'সহকারী পরিচালক (ইঞ্জিঃ)-(অঃদাঃ) ', 'name' => 'কেশব কুমার দাস', 'email' => 'ad_netrokona@brta.gov.bd', 'uno_type' => 'district', 'phone' => '01550051639', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],

            // Rangpur Division

            ['division_id' => '7', 'designation' => 'পরিচালক (ইঞ্জিনিয়ারিং)', 'district_id' => '59', 'name' => 'শফিকুজ্জামান ভুঁঞা', 'email' => 'de_rangpur@brta.gov.bd', 'uno_type' => 'divi', 'phone' => '01550051609', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],
            ['division_id' => '7', 'district_id' => '59', 'designation' => 'উপপরিচালক (ইঞ্জিঃ)', 'name' => 'আব্দুল কুদ্দুস', 'email' => 'dd_rangpur@brta.gov.bd', 'uno_type' => 'district', 'phone' => '01550051612', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],
            ['division_id' => '7', 'district_id' => '59', 'designation' => 'সহকারী পরিচালক (ইঞ্জিঃ)', 'name' => 'মোঃ শফিকুল আলম সরকার', 'email' => 'ad_rangpur@brta.gov.bd', 'uno_type' => 'district', 'phone' => '01966622069', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],
            ['division_id' => '7', 'district_id' => '54', 'designation' => 'সহকারী পরিচালক (ইঞ্জিঃ)', 'name' => 'এটিএম ময়নুল হাসান', 'email' => 'ad_dinajpur@brta.gov.bd', 'uno_type' => 'district', 'phone' => '01966622073', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],
            ['division_id' => '7', 'district_id' => '53', 'designation' => 'সহকারী পরিচালক (ইঞ্জিঃ)', 'name' => 'তন্ময় কুমার ধর', 'email' => 'ad_panchagarh@brta.gov.bd', 'uno_type' => 'district', 'phone' => '01550051657', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],
            ['division_id' => '7', 'district_id' => '55', 'designation' => 'সহকারী পরিচালক (ইঞ্জিঃ)-(অঃদাঃ) ', 'name' => 'মোঃ রাশেদ মিলন', 'email' => 'ad_lalmonirhat@brta.gov.bd', 'uno_type' => 'district', 'phone' => '01550051662', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],
            ['division_id' => '7', 'district_id' => '58', 'designation' => 'সহকারী পরিচালক (ইঞ্জিঃ)', 'name' => 'তন্ময় কুমার ধর', 'email' => 'ad_thakurgaon@brta.gov.bd', 'uno_type' => 'district', 'phone' => '01550051657', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],
            ['division_id' => '7', 'district_id' => '56', 'designation' => 'সহকারী পরিচালক (ইঞ্জিঃ)', 'name' => 'মোঃ শফিকুল আলম সরকার', 'email' => 'ad_nilphamari@brta.gov.bd', 'uno_type' => 'district', 'phone' => '01550051659', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],
            ['division_id' => '7', 'district_id' => '60', 'designation' => 'সহকারী পরিচালক (ইঞ্জিঃ)-(অঃদাঃ) ', 'name' => 'মোঃ নুরুস সাফা সরকার', 'email' => 'ad_kurigram@brta.gov.bd', 'uno_type' => 'district', 'phone' => '01550051660', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],

            ['division_id' => '7', 'district_id' => '57', 'designation' => 'সহকারী পরিচালক (ইঞ্জিঃ)', 'name' => 'মোঃ রবিউল ইসলাম', 'email' => 'ad_gaibandha@brta.gov.bd', 'uno_type' => 'district', 'phone' => '01966622070', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],






            // ['division_id' => '6',     'district_id' => '57',  'designation' => 'সহকারী পরিচালক (ইঞ্জিঃ)',     'name' => 'মোঃ রবিউল ইসলাম', 'email' => 'ad_gaibandha@brta.gov.bd', 'uno_type' => 'district', 'phone' => '01966622070', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],

            // ['division_id' => '6',     'district_id' => '57',  'designation' => 'সহকারী পরিচালক (ইঞ্জিঃ)',     'name' => 'জিয়াউর রহমান', 'email' => '', 'uno_type' => 'district', 'phone' => '01966622070', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],



            ['division_id' => '6', 'district_id' => '73', 'designation' => 'সহকারী পরিচালক (ইঞ্জিঃ)', 'name' => 'বশির উদ্দিন আহমেদ', 'email' => 'ad_dm3_reg@brta.gov.bd', 'uno_type' => 'district', 'phone' => '01550053891', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],

            ['division_id' => '6', 'district_id' => '73', 'designation' => 'উপপরিচালক (ইঞ্জিঃ)', 'name' => 'মোঃ সানাউল হক', 'email' => 'dde_dm2@brta.gov.bd', 'uno_type' => 'district', 'phone' => '01550051619', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],

            ['division_id' => '6', 'district_id' => '73', 'designation' => 'সহকারী পরিচালক (ইঞ্জিঃ)', 'name' => 'মোঃ বখতিয়ার উদ্দিন', 'email' => 'ade1_dm2@brta.gov.bd', 'uno_type' => 'district', 'phone' => '01550051618', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],

            ['division_id' => '6', 'district_id' => '73', 'designation' => 'সহকারী পরিচালক (ইঞ্জিঃ)', 'name' => 'জিএম নাদির হোসেন', 'email' => 'ad3_dm2_@brta.gov.bd', 'uno_type' => 'district', 'phone' => '01550051620', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],

            ['division_id' => '6', 'district_id' => '73', 'designation' => 'উপপরিচালক (ইঞ্জিঃ)', 'name' => 'কাজী মোঃ মোরছালীন', 'email' => 'dde_dm3@brta.gov.bd', 'uno_type' => 'district', 'phone' => '01550051621', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],

            ['division_id' => '6', 'district_id' => '73', 'designation' => 'সহকারী পরিচালক (ইঞ্জিঃ)', 'name' => 'মোঃ মোবারক হোসেন-১', 'email' => 'ad_dm1_dl@brta.gov.bd', 'uno_type' => 'district', 'phone' => '01550051615', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],

            ['division_id' => '6', 'district_id' => '73', 'designation' => 'পরিচালক (ইঞ্জিঃ)', 'name' => 'মোহাম্মাদ শহীদুল্লাহ', 'email' => 'de_dhaka@brta.gov.bd', 'uno_type' => 'divi', 'phone' => '01550051607', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],

            ['division_id' => '6', 'district_id' => '73', 'designation' => 'উপপরিচালক (ইঞ্জিঃ)', 'name' => 'স্বদেশ কুমার দাস', 'email' => 'd_dhaka@brta.gov.bd', 'uno_type' => 'district', 'phone' => '01550053899', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],

            ['division_id' => '6', 'district_id' => '73', 'designation' => 'সহকারী পরিচালক (ইঞ্জিঃ)', 'name' => 'মোঃ আব্দুল্লাহ আল-মামুন', 'email' => 'ade_dhakadiv@brta.gov.bd', 'uno_type' => 'district', 'phone' => '01550056581', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],

            ['division_id' => '6', 'district_id' => '73', 'designation' => 'উপপরিচালক (ইঞ্জিঃ)', 'name' => 'মোহাম্মদ রফিকুল ইসলাম', 'email' => 'dde_dm1@brta.gov.bd', 'uno_type' => 'district', 'phone' => '01550051614', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],

            ['division_id' => '6', 'district_id' => '73', 'designation' => 'সহকারী পরিচালক (ইঞ্জিঃ)', 'name' => 'খালিদ মাহমুদ', 'email' => 'ad_dm1_reg1@brta.gov.bd', 'uno_type' => 'district', 'phone' => '01550051613', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],

            ['division_id' => '6', 'district_id' => '73', 'designation' => 'সহকারী পরিচালক (ইঞ্জিঃ)', 'name' => 'মোহাম্মদ রুহুল আমীন', 'email' => 'ad_dm1_ft@brta.gov.bd', 'uno_type' => 'district', 'phone' => '01550051616', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],

            ['division_id' => '6', 'district_id' => '73', 'designation' => 'সহকারী পরিচালক (ইঞ্জিঃ)', 'name' => 'মোঃ শামসুল কবীর', 'email' => 'ad_dm1_to@brta.gov.bd', 'uno_type' => 'district', 'phone' => '01550051617', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],

            ['division_id' => '6', 'district_id' => '73', 'designation' => 'সহকারী পরিচালক (ইঞ্জিঃ)', 'name' => 'শেখ মোঃ রাজীবুল ইসলাম', 'email' => 'adedm1topvt@brta.gov.bd', 'uno_type' => 'district', 'phone' => '01550053893', 'password' => Hash::make('123456'), 'role_id' => UserType::USER],

        ];

        foreach ($users as $user) {
            User::create($user);
        }
    }
}
