<?php

namespace Database\Seeders;

use App\Models\Upozila;
use Illuminate\Database\Seeder;

class UpozilaSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $thanas = [
            ['id' => '1', 'district_id' => '1', 'name' => 'Debidwar', 'bn_name' => 'দেবিদ্বার', 'url' => 'debidwar.comilla.gov.bd', 'email' => 'unodebidwar@mopa.gov.bd'],
            ['id' => '2', 'district_id' => '1', 'name' => 'Barura', 'bn_name' => 'বরুড়া', 'url' => 'barura.comilla.gov.bd', 'email' => 'unobarura@mopa.gov.bd'],
            ['id' => '3', 'district_id' => '1', 'name' => 'Brahmanpara', 'bn_name' => 'ব্রাহ্মণপাড়া', 'url' => 'brahmanpara.comilla.gov.bd', 'email' => 'unobrahmanpara@mopa.gov.bd'],
            ['id' => '4', 'district_id' => '1', 'name' => 'Chandina', 'bn_name' => 'চান্দিনা', 'url' => 'chandina.comilla.gov.bd', 'email' => 'unochandina@mopa.gov.bd'],
            ['id' => '5', 'district_id' => '1', 'name' => 'Chauddagram', 'bn_name' => 'চৌদ্দগ্রাম', 'url' => 'chauddagram.comilla.gov.bd', 'email' => 'unochouddagram@mopa.gov.bd'],
            ['id' => '6', 'district_id' => '1', 'name' => 'Daudkandi', 'bn_name' => 'দাউদকান্দি', 'url' => 'daudkandi.comilla.gov.bd', 'email' => 'unodaudkandi@mopa.gov.bd'],
            ['id' => '7', 'district_id' => '1', 'name' => 'Homna', 'bn_name' => 'হোমনা', 'url' => 'homna.comilla.gov.bd', 'email' => 'unohomna@mopa.gov.bd'],
            ['id' => '8', 'district_id' => '1', 'name' => 'Laksam', 'bn_name' => 'লাকসাম', 'url' => 'laksam.comilla.gov.bd', 'email' => 'unolaksam@mopa.gov.bd'],
            ['id' => '9', 'district_id' => '1', 'name' => 'Muradnagar', 'bn_name' => 'মুরাদনগর', 'url' => 'muradnagar.comilla.gov.bd', 'email' => 'unomuradnagar@mopa.gov.bd'],
            ['id' => '10', 'district_id' => '1', 'name' => 'Nangalkot', 'bn_name' => 'নাঙ্গলকোট', 'url' => 'nangalkot.comilla.gov.bd', 'email' => 'unonangolkot@mopa.gov.bd'],
            ['id' => '11', 'district_id' => '1', 'name' => 'Comilla Sadar', 'bn_name' => 'কুমিল্লা সদর', 'url' => 'comillasadar.comilla.gov.bd', 'email' => 'unocomillasadar@mopa.gov.bd'],
            ['id' => '12', 'district_id' => '1', 'name' => 'Meghna', 'bn_name' => 'মেঘনা', 'url' => 'meghna.comilla.gov.bd', 'email' => 'unomeghna@mopa.gov.bd'],
            ['id' => '13', 'district_id' => '1', 'name' => 'Monohargonj', 'bn_name' => 'মনোহরগঞ্জ', 'url' => 'monohargonj.comilla.gov.bd', 'email' => 'unomonoharganj@mopa.gov.bd'],
            ['id' => '14', 'district_id' => '1', 'name' => 'Sadarsouth', 'bn_name' => 'সদর দক্ষিণ', 'url' => 'sadarsouth.comilla.gov.bd', 'email' => 'unocomillasadarsouth@mopa.gov.bd'],
            ['id' => '15', 'district_id' => '1', 'name' => 'Titas', 'bn_name' => 'তিতাস', 'url' => 'titas.comilla.gov.bd', 'email' => 'unotitas@mopa.gov.bd'],
            ['id' => '16', 'district_id' => '1', 'name' => 'Burichang', 'bn_name' => 'বুড়িচং', 'url' => 'burichang.comilla.gov.bd', 'email' => 'unoburichang@mopa.gov.bd'],
            ['id' => '17', 'district_id' => '1', 'name' => 'Lalmai', 'bn_name' => 'লালমাই', 'url' => 'lalmai.comilla.gov.bd', 'email' => null], 

            ['id' => '18', 'district_id' => '2', 'name' => 'Chhagalnaiya', 'bn_name' => 'ছাগলনাইয়া', 'url' => 'chhagalnaiya.feni.gov.bd', 'email' => 'unochagalnaiya@mopa.gov.bd'],
            ['id' => '19', 'district_id' => '2', 'name' => 'Feni Sadar', 'bn_name' => 'ফেনী সদর', 'url' => 'sadar.feni.gov.bd', 'email' => 'unofeni@mopa.gov.bd'],
            ['id' => '20', 'district_id' => '2', 'name' => 'Sonagazi', 'bn_name' => 'সোনাগাজী', 'url' => 'sonagazi.feni.gov.bd', 'email' => 'unosonagazi@mopa.gov.bd'],
            ['id' => '21', 'district_id' => '2', 'name' => 'Fulgazi', 'bn_name' => 'ফুলগাজী', 'url' => 'fulgazi.feni.gov.bd', 'email' => 'unofulgazi@mopa.gov.bd'],
            ['id' => '22', 'district_id' => '2', 'name' => 'Parshuram', 'bn_name' => 'পরশুরাম', 'url' => 'parshuram.feni.gov.bd', 'email' => 'unoparshuram@mopa.gov.bd'],
            ['id' => '23', 'district_id' => '2', 'name' => 'Daganbhuiyan', 'bn_name' => 'দাগনভূঞা', 'url' => 'daganbhuiyan.feni.gov.bd', 'email' => 'unodaganbhuiyan@mopa.gov.bd'],

            ['id' => '24', 'district_id' => '3', 'name' => 'Brahmanbaria Sadar', 'bn_name' => 'ব্রাহ্মণবাড়িয়া সদর', 'url' => 'sadar.brahmanbaria.gov.bd', 'email' => 'unobrahmanbaria@mopa.gov.bd'],
            ['id' => '25', 'district_id' => '3', 'name' => 'Kasba', 'bn_name' => 'কসবা', 'url' => 'kasba.brahmanbaria.gov.bd', 'email' => 'unokasba@mopa.gov.bd'],
            ['id' => '26', 'district_id' => '3', 'name' => 'Nasirnagar', 'bn_name' => 'নাসিরনগর', 'url' => 'nasirnagar.brahmanbaria.gov.bd', 'email' => 'unonasirnagar@mopa.gov.bd'],
            ['id' => '27', 'district_id' => '3', 'name' => 'Sarail', 'bn_name' => 'সরাইল', 'url' => 'sarail.brahmanbaria.gov.bd', 'email' => 'unosarail@mopa.gov.bd'],
            ['id' => '28', 'district_id' => '3', 'name' => 'Ashuganj', 'bn_name' => 'আশুগঞ্জ', 'url' => 'ashuganj.brahmanbaria.gov.bd', 'email' => 'unoashuganj@mopa.gov.bd'],
            ['id' => '29', 'district_id' => '3', 'name' => 'Akhaura', 'bn_name' => 'আখাউড়া', 'url' => 'akhaura.brahmanbaria.gov.bd', 'email' => 'unoakhaura@mopa.gov.bd'],
            ['id' => '30', 'district_id' => '3', 'name' => 'Nabinagar', 'bn_name' => 'নবীনগর', 'url' => 'nabinagar.brahmanbaria.gov.bd', 'email' => 'ununabinagar@mopa.gov.bd'],
            ['id' => '31', 'district_id' => '3', 'name' => 'Bancharampur', 'bn_name' => 'বাঞ্ছারামপুর', 'url' => 'bancharampur.brahmanbaria.gov.bd', 'email' => 'unobancharampur@mopa.gov.bd'],
            ['id' => '32', 'district_id' => '3', 'name' => 'Bijoynagar', 'bn_name' => 'বিজয়নগর', 'url' => 'bijoynagar.brahmanbaria.gov.bd', 'email' => 'unobijoynagar@mopa.gov.bd'],

            ['id' => '33', 'district_id' => '4', 'name' => 'Rangamati Sadar', 'email' => "unorangamati@mopa.gov.bd", 'bn_name' => 'রাঙ্গামাটি সদর', 'url' => 'sadar.rangamati.gov.bd'],
            ['id' => '34', 'district_id' => '4', 'name' => 'Kaptai', 'email' => "unokaptai@mopa.gov.bd", 'bn_name' => 'কাপ্তাই', 'url' => 'kaptai.rangamati.gov.bd'],
            ['id' => '35', 'district_id' => '4', 'name' => 'Kawkhali', 'email' => "unokawkhalirangamati@mopa.gov.bd", 'bn_name' => 'কাউখালী', 'url' => 'kawkhali.rangamati.gov.bd'],
            ['id' => '36', 'district_id' => '4', 'name' => 'Baghaichari', 'email' => "unobaghaichari@mopa.gov.bd", 'bn_name' => 'বাঘাইছড়ি', 'url' => 'baghaichari.rangamati.gov.bd'],
            ['id' => '37', 'district_id' => '4', 'name' => 'Barkal', 'email' => "unobarkal@mopa.gov.bd", 'bn_name' => 'বরকল', 'url' => 'barkal.rangamati.gov.bd'],
            ['id' => '38', 'district_id' => '4', 'name' => 'Langadu', 'email' => "unolangadu@mopa.gov.bd", 'bn_name' => 'লংগদু', 'url' => 'langadu.rangamati.gov.bd'],
            ['id' => '39', 'district_id' => '4', 'name' => 'Rajasthali', 'email' => "unorajasthali@mopa.gov.bd", 'bn_name' => 'রাজস্থলী', 'url' => 'rajasthali.rangamati.gov.bd'],
            ['id' => '40', 'district_id' => '4', 'name' => 'Belaichari', 'email' => "unobelaichhari@mopa.gov.bd", 'bn_name' => 'বিলাইছড়ি', 'url' => 'belaichari.rangamati.gov.bd'],
            ['id' => '41', 'district_id' => '4', 'name' => 'Juraichari', 'email' => "unojuraichari@mopa.gov.bd", 'bn_name' => 'জুরাছড়ি', 'url' => 'juraichari.rangamati.gov.bd'],
            ['id' => '42', 'district_id' => '4', 'name' => 'Naniarchar', 'email' => "unonaniarchar@mopa.gov.bd", 'bn_name' => 'নানিয়ারচর', 'url' => 'naniarchar.rangamati.gov.bd'],

            ['id' => '43', 'district_id' => '5', 'name' => 'Noakhali Sadar', 'email' => "unonoakhali@mopa.gov.bd", 'bn_name' => 'নোয়াখালী সদর', 'url' => 'sadar.noakhali.gov.bd'],
            ['id' => '44', 'district_id' => '5', 'name' => 'Companiganj', 'email' => "unocompaniganjnoakhali@mopa.gov.bd", 'bn_name' => 'কোম্পানীগঞ্জ', 'url' => 'companiganj.noakhali.gov.bd'],
            ['id' => '45', 'district_id' => '5', 'name' => 'Begumganj', 'email' => "unobegumganj@mopa.gov.bd", 'bn_name' => 'বেগমগঞ্জ', 'url' => 'begumganj.noakhali.gov.bd'],
            ['id' => '46', 'district_id' => '5', 'name' => 'Hatia', 'email' => "unohatiya@mopa.gov.bd", 'bn_name' => 'হাতিয়া', 'url' => 'hatia.noakhali.gov.bd'],
            ['id' => '47', 'district_id' => '5', 'name' => 'Subarnachar', 'email' => "unoshubarnachar@mopa.gov.bd", 'bn_name' => 'সুবর্ণচর', 'url' => 'subarnachar.noakhali.gov.bd'],
            ['id' => '48', 'district_id' => '5', 'name' => 'Kabirhat', 'email' => "unokabirhat@mopa.gov.bd", 'bn_name' => 'কবিরহাট', 'url' => 'kabirhat.noakhali.gov.bd'],
            ['id' => '49', 'district_id' => '5', 'name' => 'Senbug', 'email' => "unosenbug@mopa.gov.bd", 'bn_name' => 'সেনবাগ', 'url' => 'senbug.noakhali.gov.bd'],
            ['id' => '50', 'district_id' => '5', 'name' => 'Chatkhil', 'email' => "unochatkhil@mopa.gov.bd", 'bn_name' => 'চাটখিল', 'url' => 'chatkhil.noakhali.gov.bd'],
            ['id' => '51', 'district_id' => '5', 'name' => 'Sonaimori', 'email' => "unosonaimori@mopa.gov.bd", 'bn_name' => 'সোনাইমুড়ী', 'url' => 'sonaimori.noakhali.gov.bd'],

            ['id' => '52', 'district_id' => '6', 'name' => 'Haimchar', 'bn_name' => 'হাইমচর', 'url' => 'haimchar.chandpur.gov.bd', 'email' => 'unohaimchar@mopa.gov.bd'],
            ['id' => '53', 'district_id' => '6', 'name' => 'Kachua', 'bn_name' => 'কচুয়া', 'url' => 'kachua.chandpur.gov.bd', 'email' => 'unokachuachandpur@mopa.gov.bd'],
            ['id' => '54', 'district_id' => '6', 'name' => 'Shahrasti', 'bn_name' => 'শাহরাস্তি', 'url' => 'shahrasti.chandpur.gov.bd', 'email' => 'unoshahrasti@mopa.gov.bd'],
            ['id' => '55', 'district_id' => '6', 'name' => 'Chandpur Sadar', 'bn_name' => 'চাঁদপুর সদর', 'url' => 'sadar.chandpur.gov.bd', 'email' => 'unochandpur@mopa.gov.bd'],
            ['id' => '56', 'district_id' => '6', 'name' => 'Matlab South', 'bn_name' => 'মতলব দক্ষিণ', 'url' => 'matlabsouth.chandpur.gov.bd', 'email' => 'unomatlab@mopa.gov.bd'],
            ['id' => '57', 'district_id' => '6', 'name' => 'Hajiganj', 'bn_name' => 'হাজীগঞ্জ', 'url' => 'hajiganj.chandpur.gov.bd', 'email' => 'unohajiganj@mopa.gov.bd'],
            ['id' => '58', 'district_id' => '6', 'name' => 'Matlab North', 'bn_name' => 'মতলব উত্তর', 'url' => 'matlabnorth.chandpur.gov.bd', 'email' => 'unomatlabnorth@mopa.gov.bd'],
            ['id' => '59', 'district_id' => '6', 'name' => 'Faridgonj', 'bn_name' => 'ফরিদগঞ্জ', 'url' => 'faridgonj.chandpur.gov.bd', 'email' => 'unofaridganj@mopa.gov.bd'],

            ['id' => '60', 'district_id' => '7', 'name' => 'Lakshmipur Sadar', 'email' => "unolaxmipur@mopa.gov.bd", 'bn_name' => 'লক্ষ্মীপুর সদর', 'url' => 'sadar.lakshmipur.gov.bd'],
            ['id' => '61', 'district_id' => '7', 'name' => 'Kamalnagar', 'email' => "unokamalnagar@mopa.gov.bd", 'bn_name' => 'কমলনগর', 'url' => 'kamalnagar.lakshmipur.gov.bd'],
            ['id' => '62', 'district_id' => '7', 'name' => 'Raipur', 'email' => "unoraipur@mopa.gov.bd", 'bn_name' => 'রায়পুর', 'url' => 'raipur.lakshmipur.gov.bd'],
            ['id' => '63', 'district_id' => '7', 'name' => 'Ramgati', 'email' => "unoramgati@mopa.gov.bd", 'bn_name' => 'রামগতি', 'url' => 'ramgati.lakshmipur.gov.bd'],
            ['id' => '64', 'district_id' => '7', 'name' => 'Ramganj', 'email' => "unoramganj@mopa.gov.bd", 'bn_name' => 'রামগঞ্জ', 'url' => 'ramganj.lakshmipur.gov.bd'],

            ['id' => '65', 'district_id' => '8', 'email' => "unorangunia@mopa.gov.bd", 'name' => 'Rangunia', 'bn_name' => 'রাঙ্গুনিয়া', 'url' => 'rangunia.chittagong.gov.bd'],
            ['id' => '66', 'district_id' => '8', 'email' => "unositakunda@mopa.gov.bd", 'name' => 'Sitakunda', 'bn_name' => 'সীতাকুন্ড', 'url' => 'sitakunda.chittagong.gov.bd'],
            ['id' => '67', 'district_id' => '8', 'email' => "unomirsharai@mopa.gov.bd", 'name' => 'Mirsharai', 'bn_name' => 'মীরসরাই', 'url' => 'mirsharai.chittagong.gov.bd'],
            ['id' => '68', 'district_id' => '8', 'email' => "unopatiya@mopa.gov.bd", 'name' => 'Patiya', 'bn_name' => 'পটিয়া', 'url' => 'patiya.chittagong.gov.bd'],
            ['id' => '69', 'district_id' => '8', 'name' => 'Sandwip', 'bn_name' => 'সন্দ্বীপ', 'url' => 'sandwip.chittagong.gov.bd', 'email' => 'unosandwip@mopa.gov.bd'],
            ['id' => '70', 'district_id' => '8', 'email' => "unobanshkhali@mopa.gov.bd", 'name' => 'Banshkhali', 'bn_name' => 'বাঁশখালী', 'url' => 'banshkhali.chittagong.gov.bd'],
            ['id' => '71', 'district_id' => '8', 'email' => "unoboalkhali@mopa.gov.bd", 'name' => 'Boalkhali', 'bn_name' => 'বোয়ালখালী', 'url' => 'boalkhali.chittagong.gov.bd'],
            ['id' => '72', 'district_id' => '8', 'email' => "unoanwara@mopa.gov.bd", 'name' => 'Anwara', 'bn_name' => 'আনোয়ারা', 'url' => 'anwara.chittagong.gov.bd'],
            ['id' => '73', 'district_id' => '8', 'email' => "unochandanaish@mopa.gov.bd", 'name' => 'Chandanaish', 'bn_name' => 'চন্দনাইশ', 'url' => 'chandanaish.chittagong.gov.bd'],
            ['id' => '74', 'district_id' => '8', 'email' => "unosatkania@mopa.gov.bd", 'name' => 'Satkania', 'bn_name' => 'সাতকানিয়া', 'url' => 'satkania.chittagong.gov.bd'],
            ['id' => '75', 'district_id' => '8', 'email' => "unolohagarachittagong@mopa.gov.bd", 'name' => 'Lohagara', 'bn_name' => 'লোহাগাড়া', 'url' => 'lohagara.chittagong.gov.bd'],
            ['id' => '76', 'district_id' => '8', 'email' => "unohathazari@mopa.gov.bd", 'name' => 'Hathazari', 'bn_name' => 'হাটহাজারী', 'url' => 'hathazari.chittagong.gov.bd'],
            ['id' => '77', 'district_id' => '8', 'email' => "unofatikchari@mopa.gov.bd", 'name' => 'Fatikchhari', 'bn_name' => 'ফটিকছড়ি', 'url' => 'fatikchhari.chittagong.gov.bd'],
            ['id' => '78', 'district_id' => '8', 'email' => "unorawzan@mopa.gov.bd", 'name' => 'Raozan', 'bn_name' => 'রাউজান', 'url' => 'raozan.chittagong.gov.bd'],
            ['id' => '79', 'district_id' => '8', 'email' => "", 'name' => 'Karnafuli', 'bn_name' => 'কর্ণফুলী', 'url' => 'karnafuli.chittagong.gov.bd'],

            ['id' => '80', 'district_id' => '9', 'name' => 'Coxsbazar Sadar', 'email' => "unocoxsbazar@mopa.gov.bd", 'bn_name' => 'কক্সবাজার সদর', 'url' => 'sadar.coxsbazar.gov.bd'],
            ['id' => '81', 'district_id' => '9', 'name' => 'Chakaria', 'email' => "unochakaria@mopa.gov.bd", 'bn_name' => 'চকরিয়া', 'url' => 'chakaria.coxsbazar.gov.bd'],
            ['id' => '82', 'district_id' => '9', 'name' => 'Kutubdia', 'email' => "unokutubdia@mopa.gov.bd", 'bn_name' => 'কুতুবদিয়া', 'url' => 'kutubdia.coxsbazar.gov.bd'],
            ['id' => '83', 'district_id' => '9', 'name' => 'Ukhiya', 'email' => "unoukhia@mopa.gov.bd", 'bn_name' => 'উখিয়া', 'url' => 'ukhiya.coxsbazar.gov.bd'],
            ['id' => '84', 'district_id' => '9', 'name' => 'Moheshkhali', 'email' => "unomoheshkhali@mopa.gov.bd", 'bn_name' => 'মহেশখালী', 'url' => 'moheshkhali.coxsbazar.gov.bd'],
            ['id' => '85', 'district_id' => '9', 'name' => 'Pekua', 'email' => "unopekua@mopa.gov.bd", 'bn_name' => 'পেকুয়া', 'url' => 'pekua.coxsbazar.gov.bd'],
            ['id' => '86', 'district_id' => '9', 'name' => 'Ramu', 'email' => "unoramu@mopa.gov.bd", 'bn_name' => 'রামু', 'url' => 'ramu.coxsbazar.gov.bd'],
            ['id' => '87', 'district_id' => '9', 'name' => 'Teknaf', 'email' => "unoteknaf@mopa.gov.bd", 'bn_name' => 'টেকনাফ', 'url' => 'teknaf.coxsbazar.gov.bd'],

            ['id' => '88', 'district_id' => '10', 'name' => 'Khagrachhari Sadar', 'email' => "unokhagrachari@mopa.gov.bd", 'bn_name' => 'খাগড়াছড়ি সদর', 'url' => 'sadar.khagrachhari.gov.bd'],
            ['id' => '89', 'district_id' => '10', 'name' => 'Dighinala', 'email' => "unodighinala@mopa.gov.bd", 'bn_name' => 'দিঘীনালা', 'url' => 'dighinala.khagrachhari.gov.bd'],
            ['id' => '90', 'district_id' => '10', 'name' => 'Panchari', 'email' => "unopanchhari@mopa.gov.bd", 'bn_name' => 'পানছড়ি', 'url' => 'panchari.khagrachhari.gov.bd'],
            ['id' => '91', 'district_id' => '10', 'name' => 'Laxmichhari', 'email' => "unolaxmichhari@mopa.gov.bd", 'bn_name' => 'লক্ষীছড়ি', 'url' => 'laxmichhari.khagrachhari.gov.bd'],
            ['id' => '92', 'district_id' => '10', 'name' => 'Mohalchari', 'email' => "unomohalchari@mopa.gov.bd", 'bn_name' => 'মহালছড়ি', 'url' => 'mohalchari.khagrachhari.gov.bd'],
            ['id' => '93', 'district_id' => '10', 'name' => 'Manikchari', 'email' => "unomanikchhari@mopa.gov.bd", 'bn_name' => 'মানিকছড়ি', 'url' => 'manikchari.khagrachhari.gov.bd'],
            ['id' => '94', 'district_id' => '10', 'name' => 'Ramgarh', 'email' => "unoramgarh@mopa.gov.bd", 'bn_name' => 'রামগড়', 'url' => 'ramgarh.khagrachhari.gov.bd'],
            ['id' => '95', 'district_id' => '10', 'name' => 'Matiranga', 'email' => "unomatiranga@mopa.gov.bd", 'bn_name' => 'মাটিরাঙ্গা', 'url' => 'matiranga.khagrachhari.gov.bd'],
            ['id' => '96', 'district_id' => '10', 'name' => 'Guimara', 'email' => "", 'bn_name' => 'গুইমারা', 'url' => 'guimara.khagrachhari.gov.bd'],

            ['id' => '97', 'district_id' => '11', 'email' => "unobandarban@mopa.gov.bd", 'name' => 'Bandarban Sadar', 'bn_name' => 'বান্দরবান সদর', 'url' => 'sadar.bandarban.gov.bd'],
            ['id' => '98', 'district_id' => '11', 'email' => "unoalikadam@mopa.gov.bd", 'name' => 'Alikadam', 'bn_name' => 'আলীকদম', 'url' => 'alikadam.bandarban.gov.bd'],
            ['id' => '99', 'district_id' => '11', 'email' => "unonaikhongchhari@mopa.gov.bd", 'name' => 'Naikhongchhari', 'bn_name' => 'নাইক্ষ্যংছড়ি', 'url' => 'naikhongchhari.bandarban.gov.bd'],
            ['id' => '100', 'district_id' => '11', 'email' => "unorowangchari@mopa.gov.bd", 'name' => 'Rowangchhari', 'bn_name' => 'রোয়াংছড়ি', 'url' => 'rowangchhari.bandarban.gov.bd'],
            ['id' => '101', 'district_id' => '11', 'email' => "unolama@mopa.gov.bd", 'name' => 'Lama', 'bn_name' => 'লামা', 'url' => 'lama.bandarban.gov.bd'],
            ['id' => '102', 'district_id' => '11', 'email' => "unoruma@mopa.gov.bd", 'name' => 'Ruma', 'bn_name' => 'রুমা', 'url' => 'ruma.bandarban.gov.bd'],
            ['id' => '103', 'district_id' => '11', 'email' => "unothanchi@mopa.gov.bd", 'name' => 'Thanchi', 'bn_name' => 'থানচি', 'url' => 'thanchi.bandarban.gov.bd'],

            ['id' => '104', 'district_id' => '12', 'name' => 'Belkuchi', 'bn_name' => 'বেলকুচি', 'url' => 'belkuchi.sirajganj.gov.bd', 'email' => 'unobelkuchi@mopa.gov.bd'],
            ['id' => '105', 'district_id' => '12', 'name' => 'Chauhali', 'bn_name' => 'চৌহালি', 'url' => 'chauhali.sirajganj.gov.bd', 'email' => 'unochowhali@mopa.gov.bd'],
            ['id' => '106', 'district_id' => '12', 'name' => 'Kamarkhand', 'bn_name' => 'কামারখন্দ', 'url' => 'kamarkhand.sirajganj.gov.bd', 'email' => 'unokamarkhand@mopa.gov.bd'],
            ['id' => '107', 'district_id' => '12', 'name' => 'Kazipur', 'bn_name' => 'কাজীপুর', 'url' => 'kazipur.sirajganj.gov.bd', 'email' => 'unokazipur@mopa.gov.bd'],
            ['id' => '108', 'district_id' => '12', 'name' => 'Raigonj', 'bn_name' => 'রায়গঞ্জ', 'url' => 'raigonj.sirajganj.gov.bd', 'email' => 'unoraiganj@mopa.gov.bd'],
            ['id' => '109', 'district_id' => '12', 'name' => 'Shahjadpur', 'bn_name' => 'শাহজাদপুর', 'url' => 'shahjadpur.sirajganj.gov.bd', 'email' => 'unosahjadpur@mopa.gov.bd'],
            ['id' => '110', 'district_id' => '12', 'name' => 'Sirajganj Sadar', 'bn_name' => 'সিরাজগঞ্জ সদর', 'url' => 'sirajganjsadar.sirajganj.gov.bd', 'email' => 'unosirajganj@mopa.gov.bd'],
            ['id' => '111', 'district_id' => '12', 'name' => 'Tarash', 'bn_name' => 'তাড়াশ', 'url' => 'tarash.sirajganj.gov.bd', 'email' => 'unotarash@mopa.gov.bd'],
            ['id' => '112', 'district_id' => '12', 'name' => 'Ullapara', 'bn_name' => 'উল্লাপাড়া', 'url' => 'ullapara.sirajganj.gov.bd', 'email' => 'unoullahpara@mopa.gov.bd'],

            ['id' => '113', 'district_id' => '13', 'name' => 'Sujanagar', 'email' => "unosujanagar@mopa.gov.bd", 'bn_name' => 'সুজানগর', 'url' => 'sujanagar.pabna.gov.bd'],
            ['id' => '114', 'district_id' => '13', 'name' => 'Ishurdi', 'email' => "unoishurdi@mopa.gov.bd", 'bn_name' => 'ঈশ্বরদী', 'url' => 'ishurdi.pabna.gov.bd'],
            ['id' => '115', 'district_id' => '13', 'name' => 'Bhangura', 'email' => "unobhangura@mopa.gov.bd", 'bn_name' => 'ভাঙ্গুড়া', 'url' => 'bhangura.pabna.gov.bd'],
            ['id' => '116', 'district_id' => '13', 'name' => 'Pabna Sadar', 'email' => "unopabna@mopa.gov.bd", 'bn_name' => 'পাবনা সদর', 'url' => 'pabnasadar.pabna.gov.bd'],
            ['id' => '117', 'district_id' => '13', 'name' => 'Bera', 'email' => "unobera@mopa.gov.bd", 'bn_name' => 'বেড়া', 'url' => 'bera.pabna.gov.bd'],
            ['id' => '118', 'district_id' => '13', 'name' => 'Atghoria', 'email' => "unoatghoria@mopa.gov.bd", 'bn_name' => 'আটঘরিয়া', 'url' => 'atghoria.pabna.gov.bd'],
            ['id' => '119', 'district_id' => '13', 'name' => 'Chatmohar', 'email' => "unochatmohar@mopa.gov.bd", 'bn_name' => 'চাটমোহর', 'url' => 'chatmohar.pabna.gov.bd'],
            ['id' => '120', 'district_id' => '13', 'name' => 'Santhia', 'email' => "unosanthia@mopa.gov.bd", 'bn_name' => 'সাঁথিয়া', 'url' => 'santhia.pabna.gov.bd'],
            ['id' => '121', 'district_id' => '13', 'name' => 'Faridpur', 'email' => "unofaridpurpabna@mopa.gov.bd", 'bn_name' => 'ফরিদপুর', 'url' => 'faridpur.pabna.gov.bd'],

            ['id' => '122', 'district_id' => '14', 'name' => 'Kahaloo', 'bn_name' => 'কাহালু', 'url' => 'kahaloo.bogra.gov.bd', 'email' => 'unokahaloo@mopa.gov.bd'],
            ['id' => '123', 'district_id' => '14', 'name' => 'Bogra Sadar', 'bn_name' => 'বগুড়া সদর', 'url' => 'sadar.bogra.gov.bd', 'email' => 'unobogra@mopa.gov.bd'],
            ['id' => '124', 'district_id' => '14', 'name' => 'Shariakandi', 'bn_name' => 'সারিয়াকান্দি', 'url' => 'shariakandi.bogra.gov.bd', 'email' => 'unosariakandi@mopa.gov.bd'],
            ['id' => '125', 'district_id' => '14', 'name' => 'Shajahanpur', 'bn_name' => 'শাজাহানপুর', 'url' => 'shajahanpur.bogra.gov.bd', 'email' => 'unoshajahanpur@mopa.gov.bd'],
            ['id' => '126', 'district_id' => '14', 'name' => 'Dupchanchia', 'bn_name' => 'দুপচাচিঁয়া', 'url' => 'dupchanchia.bogra.gov.bd', 'email' => 'unodupchanchia@mopa.gov.bd'],
            ['id' => '127', 'district_id' => '14', 'name' => 'Adamdighi', 'bn_name' => 'আদমদিঘি', 'url' => 'adamdighi.bogra.gov.bd', 'email' => 'unoadamdighi@mopa.gov.bd'],
            ['id' => '128', 'district_id' => '14', 'name' => 'Nondigram', 'bn_name' => 'নন্দিগ্রাম', 'url' => 'nondigram.bogra.gov.bd', 'email' => 'ununandigram@mopa.gov.bd'],
            ['id' => '129', 'district_id' => '14', 'name' => 'Sonatala', 'bn_name' => 'সোনাতলা', 'url' => 'sonatala.bogra.gov.bd', 'email' => 'unosonatola@mopa.gov.bd'],
            ['id' => '130', 'district_id' => '14', 'name' => 'Dhunot', 'bn_name' => 'ধুনট', 'url' => 'dhunot.bogra.gov.bd', 'email' => 'unodhunat@mopa.gov.bd'],
            ['id' => '131', 'district_id' => '14', 'name' => 'Gabtali', 'bn_name' => 'গাবতলী', 'url' => 'gabtali.bogra.gov.bd', 'email' => 'unogabtali@mopa.gov.bd'],
            ['id' => '132', 'district_id' => '14', 'name' => 'Sherpur', 'bn_name' => 'শেরপুর', 'url' => 'sherpur.bogra.gov.bd', 'email' => 'unosherpurbogra@mopa.gov.bd'],
            ['id' => '133', 'district_id' => '14', 'name' => 'Shibganj', 'bn_name' => 'শিবগঞ্জ', 'url' => 'shibganj.bogra.gov.bd', 'email' => 'unoshibganjbogra@mopa.gov.bd'],

            ['id' => '134', 'district_id' => '15', 'name' => 'Paba', 'email' => "unopaba@mopa.gov.bd", 'bn_name' => 'পবা', 'url' => 'paba.rajshahi.gov.bd'],
            ['id' => '135', 'district_id' => '15', 'name' => 'Durgapur', 'email' => "unodurgapurrajshahi@mopa.gov.bd", 'bn_name' => 'দুর্গাপুর', 'url' => 'durgapur.rajshahi.gov.bd'],
            ['id' => '136', 'district_id' => '15', 'name' => 'Mohonpur', 'email' => "unomohanpur@mopa.gov.bd", 'bn_name' => 'মোহনপুর', 'url' => 'mohonpur.rajshahi.gov.bd'],
            ['id' => '137', 'district_id' => '15', 'name' => 'Charghat', 'email' => "unocharghat@mopa.gov.bd", 'bn_name' => 'চারঘাট', 'url' => 'charghat.rajshahi.gov.bd'],
            ['id' => '138', 'district_id' => '15', 'name' => 'Puthia', 'email' => "unoputhia@mopa.gov.bd", 'bn_name' => 'পুঠিয়া', 'url' => 'puthia.rajshahi.gov.bd'],
            ['id' => '139', 'district_id' => '15', 'name' => 'Bagha', 'email' => "unobagha@mopa.gov.bd", 'bn_name' => 'বাঘা', 'url' => 'bagha.rajshahi.gov.bd'],
            ['id' => '140', 'district_id' => '15', 'name' => 'Godagari', 'email' => "unogodagari@mopa.gov.bd", 'bn_name' => 'গোদাগাড়ী', 'url' => 'godagari.rajshahi.gov.bd'],
            ['id' => '141', 'district_id' => '15', 'name' => 'Tanore', 'email' => "unotanore@mopa.gov.bd", 'bn_name' => 'তানোর', 'url' => 'tanore.rajshahi.gov.bd'],
            ['id' => '142', 'district_id' => '15', 'name' => 'Bagmara', 'email' => "unobagmara@mopa.gov.bd", 'bn_name' => 'বাগমারা', 'url' => 'bagmara.rajshahi.gov.bd'],

            ['id' => '143', 'district_id' => '16', 'name' => 'Natore Sadar', 'email' => "unonatore@mopa.gov.bd", 'bn_name' => 'নাটোর সদর', 'url' => 'natoresadar.natore.gov.bd'],
            ['id' => '144', 'district_id' => '16', 'name' => 'Singra', 'email' => "unosingra@mopa.gov.bd", 'bn_name' => 'সিংড়া', 'url' => 'singra.natore.gov.bd'],
            ['id' => '145', 'district_id' => '16', 'name' => 'Baraigram', 'email' => "unobaraigram@mopa.gov.bd", 'bn_name' => 'বড়াইগ্রাম', 'url' => 'baraigram.natore.gov.bd'],
            ['id' => '146', 'district_id' => '16', 'name' => 'Bagatipara', 'email' => "unobagatipara@mopa.gov.bd", 'bn_name' => 'বাগাতিপাড়া', 'url' => 'bagatipara.natore.gov.bd'],
            ['id' => '147', 'district_id' => '16', 'name' => 'Lalpur', 'email' => "unolalpur@mopa.gov.bd", 'bn_name' => 'লালপুর', 'url' => 'lalpur.natore.gov.bd'],
            ['id' => '148', 'district_id' => '16', 'name' => 'Gurudaspur', 'email' => "unogurudaspur@mopa.gov.bd", 'bn_name' => 'গুরুদাসপুর', 'url' => 'gurudaspur.natore.gov.bd'],
            ['id' => '149', 'district_id' => '16', 'name' => 'Naldanga', 'email' => "", 'bn_name' => 'নলডাঙ্গা', 'url' => 'naldanga.natore.gov.bd'],

            ['id' => '150', 'district_id' => '17', 'name' => 'Akkelpur', 'email' => "unoakkelpur@mopa.gov.bd", 'bn_name' => 'আক্কেলপুর', 'url' => 'akkelpur.joypurhat.gov.bd'],
            ['id' => '151', 'district_id' => '17', 'name' => 'Kalai', 'email' => "unokalai@mopa.gov.bd", 'bn_name' => 'কালাই', 'url' => 'kalai.joypurhat.gov.bd'],
            ['id' => '152', 'district_id' => '17', 'name' => 'Khetlal', 'email' => "unokhetlal@mopa.gov.bd", 'bn_name' => 'ক্ষেতলাল', 'url' => 'khetlal.joypurhat.gov.bd'],
            ['id' => '153', 'district_id' => '17', 'name' => 'Panchbibi', 'email' => "unopanchbibi@mopa.gov.bd", 'bn_name' => 'পাঁচবিবি', 'url' => 'panchbibi.joypurhat.gov.bd'],
            ['id' => '154', 'district_id' => '17', 'name' => 'Joypurhat Sadar', 'email' => "unojoypurhat@mopa.gov.bd", 'bn_name' => 'জয়পুরহাট সদর', 'url' => 'joypurhatsadar.joypurhat.gov.bd'],

            ['id' => '155', 'district_id' => '18', 'name' => 'Chapainawabganj Sadar', 'bn_name' => 'চাঁপাইনবাবগঞ্জ সদর', 'url' => 'chapainawabganjsadar.chapainawabganj.gov.bd', 'email' => 'unochapainawabganj@mopa.gov.bd'],
            ['id' => '156', 'district_id' => '18', 'name' => 'Gomostapur', 'bn_name' => 'গোমস্তাপুর', 'url' => 'gomostapur.chapainawabganj.gov.bd', 'email' => 'unogomastapur@mopa.gov.bd'],
            ['id' => '157', 'district_id' => '18', 'name' => 'Nachol', 'bn_name' => 'নাচোল', 'url' => 'nachol.chapainawabganj.gov.bd', 'email' => 'ununachole@mopa.gov.bd'],
            ['id' => '158', 'district_id' => '18', 'name' => 'Bholahat', 'bn_name' => 'ভোলাহাট', 'url' => 'bholahat.chapainawabganj.gov.bd', 'email' => 'unobholahat@mopa.gov.bd'],
            ['id' => '159', 'district_id' => '18', 'name' => 'Shibganj', 'bn_name' => 'শিবগঞ্জ', 'url' => 'shibganj.chapainawabganj.gov.bd', 'email' => 'unoshibganjchapainawabganj@mopa.gov.bd'],

            ['id' => '160', 'district_id' => '19', 'name' => 'Mohadevpur', 'bn_name' => 'মহাদেবপুর', 'url' => 'mohadevpur.naogaon.gov.bd', 'email' => 'unomohadevpur@mopa.gov.bd'],
            ['id' => '161', 'district_id' => '19', 'name' => 'Badalgachi', 'bn_name' => 'বদলগাছী', 'url' => 'badalgachi.naogaon.gov.bd', 'email' => 'unobadalgachi@mopa.gov.bd'],
            ['id' => '162', 'district_id' => '19', 'name' => 'Patnitala', 'bn_name' => 'পত্নিতলা', 'url' => 'patnitala.naogaon.gov.bd', 'email' => 'unopatnitola@mopa.gov.bd'],
            ['id' => '163', 'district_id' => '19', 'name' => 'Dhamoirhat', 'bn_name' => 'ধামইরহাট', 'url' => 'dhamoirhat.naogaon.gov.bd', 'email' => 'unodhamoirhat@mopa.gov.bd'],
            ['id' => '164', 'district_id' => '19', 'name' => 'Niamatpur', 'bn_name' => 'নিয়ামতপুর', 'url' => 'niamatpur.naogaon.gov.bd', 'email' => 'unoniamatpur@mopa.gov.bd'],
            ['id' => '165', 'district_id' => '19', 'name' => 'Manda', 'bn_name' => 'মান্দা', 'url' => 'manda.naogaon.gov.bd', 'email' => 'unomanda@mopa.gov.bd'],
            ['id' => '166', 'district_id' => '19', 'name' => 'Atrai', 'bn_name' => 'আত্রাই', 'url' => 'atrai.naogaon.gov.bd', 'email' => 'unoatrai@mopa.gov.bd'],
            ['id' => '167', 'district_id' => '19', 'name' => 'Raninagar', 'bn_name' => 'রাণীনগর', 'url' => 'raninagar.naogaon.gov.bd', 'email' => 'unoraninagar@mopa.gov.bd'],
            ['id' => '168', 'district_id' => '19', 'name' => 'Naogaon Sadar', 'bn_name' => 'নওগাঁ সদর', 'url' => 'naogaonsadar.naogaon.gov.bd', 'email' => 'unonaogaon@mopa.gov.bd'],
            ['id' => '169', 'district_id' => '19', 'name' => 'Porsha', 'bn_name' => 'পোরশা', 'url' => 'porsha.naogaon.gov.bd', 'email' => 'unoporsha@mopa.gov.bd'],
            ['id' => '170', 'district_id' => '19', 'name' => 'Sapahar', 'bn_name' => 'সাপাহার', 'url' => 'sapahar.naogaon.gov.bd', 'email' => 'unosapahar@mopa.gov.bd'],

            ['id' => '171', 'district_id' => '20', 'name' => 'Manirampur', 'bn_name' => 'মণিরামপুর', 'url' => 'manirampur.jessore.gov.bd', 'email' => 'unomanirampur@mopa.gov.bd'],
            ['id' => '172', 'district_id' => '20', 'name' => 'Abhaynagar', 'bn_name' => 'অভয়নগর', 'url' => 'abhaynagar.jessore.gov.bd', 'email' => 'unoabhaynagar@mopa.gov.bd'],
            ['id' => '173', 'district_id' => '20', 'name' => 'Bagherpara', 'bn_name' => 'বাঘারপাড়া', 'url' => 'bagherpara.jessore.gov.bd', 'email' => 'unobagherpara@mopa.gov.bd'],
            ['id' => '174', 'district_id' => '20', 'name' => 'Chougachha', 'bn_name' => 'চৌগাছা', 'url' => 'chougachha.jessore.gov.bd', 'email' => 'unochougachha@mopa.gov.bd'],
            ['id' => '175', 'district_id' => '20', 'name' => 'Jhikargacha', 'bn_name' => 'ঝিকরগাছা', 'url' => 'jhikargacha.jessore.gov.bd', 'email' => 'unojhikargacha@mopa.gov.bd'],
            ['id' => '176', 'district_id' => '20', 'name' => 'Keshabpur', 'bn_name' => 'কেশবপুর', 'url' => 'keshabpur.jessore.gov.bd', 'email' => 'unokeshabpur@mopa.gov.bd'],
            ['id' => '177', 'district_id' => '20', 'name' => 'Jessore Sadar', 'bn_name' => 'যশোর সদর', 'url' => 'sadar.jessore.gov.bd', 'email' => 'unojessore@mopa.gov.bd'],
            ['id' => '178', 'district_id' => '20', 'name' => 'Sharsha', 'bn_name' => 'শার্শা', 'url' => 'sharsha.jessore.gov.bd', 'email' => 'unosharsha@mopa.gov.bd'],

            ['id' => '179', 'district_id' => '21', 'name' => 'Assasuni', 'email' => "unoashasuni@mopa.gov.bd", 'bn_name' => 'আশাশুনি', 'url' => 'assasuni.satkhira.gov.bd'],
            ['id' => '180', 'district_id' => '21', 'name' => 'Debhata', 'email' => "unodebhata@mopa.gov.bd", 'bn_name' => 'দেবহাটা', 'url' => 'debhata.satkhira.gov.bd'],
            ['id' => '181', 'district_id' => '21', 'name' => 'Kalaroa', 'email' => "unokalaroa@mopa.gov.bd", 'bn_name' => 'কলারোয়া', 'url' => 'kalaroa.satkhira.gov.bd'],
            ['id' => '182', 'district_id' => '21', 'name' => 'Satkhira Sadar', 'email' => "unosatkhira@mopa.gov.bd", 'bn_name' => 'সাতক্ষীরা সদর', 'url' => 'satkhirasadar.satkhira.gov.bd'],
            ['id' => '183', 'district_id' => '21', 'name' => 'Shyamnagar', 'email' => "unoshaymnagar@mopa.gov.bd", 'bn_name' => 'শ্যামনগর', 'url' => 'shyamnagar.satkhira.gov.bd'],
            ['id' => '184', 'district_id' => '21', 'name' => 'Tala', 'email' => "unotala@mopa.gov.bd", 'bn_name' => 'তালা', 'url' => 'tala.satkhira.gov.bd'],
            ['id' => '185', 'district_id' => '21', 'name' => 'Kaliganj', 'email' => "unokaliganjsatkhira@mopa.gov.bd", 'bn_name' => 'কালিগঞ্জ', 'url' => 'kaliganj.satkhira.gov.bd'],

            ['id' => '186', 'district_id' => '22', 'name' => 'Mujibnagar', 'email' => "unomujibnagar@mopa.gov.bd", 'bn_name' => 'মুজিবনগর', 'url' => 'mujibnagar.meherpur.gov.bd'],
            ['id' => '187', 'district_id' => '22', 'name' => 'Meherpur Sadar', 'email' => "unomeherpur@mopa.gov.bd", 'bn_name' => 'মেহেরপুর সদর', 'url' => 'meherpursadar.meherpur.gov.bd'],
            ['id' => '188', 'district_id' => '22', 'name' => 'Gangni', 'email' => "unogangni@mopa.gov.bd", 'bn_name' => 'গাংনী', 'url' => 'gangni.meherpur.gov.bd'],

            ['id' => '189', 'district_id' => '23', 'name' => 'Narail Sadar', 'email' => "unonarail@mopa.gov.bd", 'bn_name' => 'নড়াইল সদর', 'url' => 'narailsadar.narail.gov.bd'],
            ['id' => '190', 'district_id' => '23', 'name' => 'Lohagara', 'email' => "unolohagaranarail@mopa.gov.bd", 'bn_name' => 'লোহাগড়া', 'url' => 'lohagara.narail.gov.bd'],
            ['id' => '191', 'district_id' => '23', 'name' => 'Kalia', 'email' => "unokalia@mopa.gov.bd", 'bn_name' => 'কালিয়া', 'url' => 'kalia.narail.gov.bd'],

            ['id' => '192', 'district_id' => '24', 'name' => 'Chuadanga Sadar', 'bn_name' => 'চুয়াডাঙ্গা সদর', 'url' => 'chuadangasadar.chuadanga.gov.bd', 'email' => 'unochuadanga@mopa.gov.bd'],
            ['id' => '193', 'district_id' => '24', 'name' => 'Alamdanga', 'bn_name' => 'আলমডাঙ্গা', 'url' => 'alamdanga.chuadanga.gov.bd', 'email' => 'unoalamdanga@mopa.gov.bd'],
            ['id' => '194', 'district_id' => '24', 'name' => 'Damurhuda', 'bn_name' => 'দামুড়হুদা', 'url' => 'damurhuda.chuadanga.gov.bd', 'email' => 'unodamurhuda@mopa.gov.bd'],
            ['id' => '195', 'district_id' => '24', 'name' => 'Jibannagar', 'bn_name' => 'জীবননগর', 'url' => 'jibannagar.chuadanga.gov.bd', 'email' => 'unojibannagar@mopa.gov.bd'],

            ['id' => '196', 'district_id' => '25', 'name' => 'Kushtia Sadar', 'bn_name' => 'কুষ্টিয়া সদর', 'url' => 'kushtiasadar.kushtia.gov.bd', 'email' => 'unokushtia@mopa.gov.bd'],
            ['id' => '197', 'district_id' => '25', 'name' => 'Kumarkhali', 'bn_name' => 'কুমারখালী', 'url' => 'kumarkhali.kushtia.gov.bd', 'email' => 'unokumarkhali@mopa.gov.bd'],
            ['id' => '198', 'district_id' => '25', 'name' => 'Khoksa', 'bn_name' => 'খোকসা', 'url' => 'khoksa.kushtia.gov.bd', 'email' => 'unokhoksa@mopa.gov.bd'],
            ['id' => '199', 'district_id' => '25', 'name' => 'Mirpur', 'bn_name' => 'মিরপুর', 'url' => 'mirpurkushtia.kushtia.gov.bd', 'email' => 'unomirpur@mopa.gov.bd'],
            ['id' => '200', 'district_id' => '25', 'name' => 'Daulatpur', 'bn_name' => 'দৌলতপুর', 'url' => 'daulatpur.kushtia.gov.bd', 'email' => 'unodaulatpurkushtia@mopa.gov.bd'],
            ['id' => '201', 'district_id' => '25', 'name' => 'Bheramara', 'bn_name' => 'ভেড়ামারা', 'url' => 'bheramara.kushtia.gov.bd', 'email' => 'unobheramara@mopa.gov.bd'],

            ['id' => '202', 'district_id' => '26', 'name' => 'Shalikha', 'email' => "unoshalikha@mopa.gov.bd", 'bn_name' => 'শালিখা', 'url' => 'shalikha.magura.gov.bd'],
            ['id' => '203', 'district_id' => '26', 'name' => 'Sreepur', 'email' => "unosreepurmagura@mopa.gov.bd", 'bn_name' => 'শ্রীপুর', 'url' => 'sreepur.magura.gov.bd'],
            ['id' => '204', 'district_id' => '26', 'name' => 'Magura Sadar', 'email' => "unomagura@mopa.gov.bd", 'bn_name' => 'মাগুরা সদর', 'url' => 'magurasadar.magura.gov.bd'],
            ['id' => '205', 'district_id' => '26', 'name' => 'Mohammadpur', 'email' => "unomohammadpur@mopa.gov.bd", 'bn_name' => 'মহম্মদপুর', 'url' => 'mohammadpur.magura.gov.bd'],

            ['id' => '206', 'district_id' => '27', 'name' => 'Paikgasa', 'bn_name' => 'পাইকগাছা', 'url' => 'paikgasa.khulna.gov.bd', 'email' => 'unopaikgacha@mopa.gov.bd'],
            ['id' => '207', 'district_id' => '27', 'name' => 'Fultola', 'bn_name' => 'ফুলতলা', 'url' => 'fultola.khulna.gov.bd', 'email' => 'unofultala@mopa.gov.bd'],
            ['id' => '208', 'district_id' => '27', 'name' => 'Digholia', 'bn_name' => 'দিঘলিয়া', 'url' => 'digholia.khulna.gov.bd', 'email' => 'unodigholia@mopa.gov.bd'],
            ['id' => '209', 'district_id' => '27', 'name' => 'Rupsha', 'bn_name' => 'রূপসা', 'url' => 'rupsha.khulna.gov.bd', 'email' => 'unorupsha@mopa.gov.bd'],
            ['id' => '210', 'district_id' => '27', 'name' => 'Terokhada', 'bn_name' => 'তেরখাদা', 'url' => 'terokhada.khulna.gov.bd', 'email' => 'unoterokhada@mopa.gov.bd'],
            ['id' => '211', 'district_id' => '27', 'name' => 'Dumuria', 'bn_name' => 'ডুমুরিয়া', 'url' => 'dumuria.khulna.gov.bd', 'email' => 'unodumuria@mopa.gov.bd'],
            ['id' => '212', 'district_id' => '27', 'name' => 'Botiaghata', 'bn_name' => 'বটিয়াঘাটা', 'url' => 'botiaghata.khulna.gov.bd', 'email' => 'unobatiaghata@mopa.gov.bd'],
            ['id' => '213', 'district_id' => '27', 'name' => 'Dakop', 'bn_name' => 'দাকোপ', 'url' => 'dakop.khulna.gov.bd', 'email' => 'unodacope@mopa.gov.bd'],
            ['id' => '214', 'district_id' => '27', 'name' => 'Koyra', 'bn_name' => 'কয়রা', 'url' => 'koyra.khulna.gov.bd', 'email' => 'unokoyra@mopa.gov.bd'],

            ['id' => '215', 'district_id' => '28', 'name' => 'Fakirhat', 'email' => "unofakirhat@mopa.gov.bd", 'bn_name' => 'ফকিরহাট', 'url' => 'fakirhat.bagerhat.gov.bd'],
            ['id' => '216', 'district_id' => '28', 'name' => 'Bagerhat Sadar', 'email' => "unobagerhat@mopa.gov.bd", 'bn_name' => 'বাগেরহাট সদর', 'url' => 'sadar.bagerhat.gov.bd'],
            ['id' => '217', 'district_id' => '28', 'name' => 'Mollahat', 'email' => "unomollahat@mopa.gov.bd", 'bn_name' => 'মোল্লাহাট', 'url' => 'mollahat.bagerhat.gov.bd'],
            ['id' => '218', 'district_id' => '28', 'name' => 'Sarankhola', 'email' => "unosarankhola@mopa.gov.bd", 'bn_name' => 'শরণখোলা', 'url' => 'sarankhola.bagerhat.gov.bd'],
            ['id' => '219', 'district_id' => '28', 'name' => 'Rampal', 'email' => "unorampal@mopa.gov.bd", 'bn_name' => 'রামপাল', 'url' => 'rampal.bagerhat.gov.bd'],
            ['id' => '220', 'district_id' => '28', 'name' => 'Morrelganj', 'email' => "unomoralganj@mopa.gov.bd", 'bn_name' => 'মোড়েলগঞ্জ', 'url' => 'morrelganj.bagerhat.gov.bd'],
            ['id' => '221', 'district_id' => '28', 'name' => 'Kachua', 'email' => "unokachuabagerhat@mopa.gov.bd", 'bn_name' => 'কচুয়া', 'url' => 'kachua.bagerhat.gov.bd'],
            ['id' => '222', 'district_id' => '28', 'name' => 'Mongla', 'email' => "unomongla@mopa.gov.bd", 'bn_name' => 'মোংলা', 'url' => 'mongla.bagerhat.gov.bd'],
            ['id' => '223', 'district_id' => '28', 'name' => 'Chitalmari', 'email' => "unochitalmari@mopa.gov.bd", 'bn_name' => 'চিতলমারী', 'url' => 'chitalmari.bagerhat.gov.bd'],

            ['id' => '224', 'district_id' => '29', 'name' => 'Jhenaidah Sadar', 'email' => "unojhenaidah@mopa.gov.bd", 'bn_name' => 'ঝিনাইদহ সদর', 'url' => 'sadar.jhenaidah.gov.bd'],
            ['id' => '225', 'district_id' => '29', 'name' => 'Shailkupa', 'email' => "unoshailkupa@mopa.gov.bd", 'bn_name' => 'শৈলকুপা', 'url' => 'shailkupa.jhenaidah.gov.bd'],
            ['id' => '226', 'district_id' => '29', 'name' => 'Harinakundu', 'email' => "unoharinakunda@mopa.gov.bd", 'bn_name' => 'হরিণাকুন্ডু', 'url' => 'harinakundu.jhenaidah.gov.bd'],
            ['id' => '227', 'district_id' => '29', 'name' => 'Kaliganj', 'email' => "unokaliganjjhenaidah@mopa.gov.bd", 'bn_name' => 'কালীগঞ্জ', 'url' => 'kaliganj.jhenaidah.gov.bd'],
            ['id' => '228', 'district_id' => '29', 'name' => 'Kotchandpur', 'email' => "unokotchandpur@mopa.gov.bd", 'bn_name' => 'কোটচাঁদপুর', 'url' => 'kotchandpur.jhenaidah.gov.bd'],
            ['id' => '229', 'district_id' => '29', 'name' => 'Moheshpur', 'email' => "unomoheshpur@mopa.gov.bd", 'bn_name' => 'মহেশপুর', 'url' => 'moheshpur.jhenaidah.gov.bd'],

            ['id' => '230', 'district_id' => '30', 'name' => 'Jhalakathi Sadar', 'email' => "unojhalakathi@mopa.gov.bd", 'bn_name' => 'ঝালকাঠি সদর', 'url' => 'sadar.jhalakathi.gov.bd'],
            ['id' => '231', 'district_id' => '30', 'name' => 'Kathalia', 'email' => "unokathalia@mopa.gov.bd", 'bn_name' => 'কাঠালিয়া', 'url' => 'kathalia.jhalakathi.gov.bd'],
            ['id' => '232', 'district_id' => '30', 'name' => 'Nalchity', 'email' => "unonalchity@mopa.gov.bd", 'bn_name' => 'নলছিটি', 'url' => 'nalchity.jhalakathi.gov.bd'],
            ['id' => '233', 'district_id' => '30', 'name' => 'Rajapur', 'email' => "unorajapur@mopa.gov.bd", 'bn_name' => 'রাজাপুর', 'url' => 'rajapur.jhalakathi.gov.bd'],

            ['id' => '234', 'district_id' => '31', 'name' => 'Bauphal', 'email' => "unobawphal@mopa.gov.bd", 'bn_name' => 'বাউফল', 'url' => 'bauphal.patuakhali.gov.bd'],
            ['id' => '235', 'district_id' => '31', 'name' => 'Patuakhali Sadar', 'email' => "unopatuakhali@mopa.gov.bd", 'bn_name' => 'পটুয়াখালী সদর', 'url' => 'sadar.patuakhali.gov.bd'],
            ['id' => '236', 'district_id' => '31', 'name' => 'Dumki', 'email' => "unodhumki@mopa.gov.bd", 'bn_name' => 'দুমকি', 'url' => 'dumki.patuakhali.gov.bd'],
            ['id' => '237', 'district_id' => '31', 'name' => 'Dashmina', 'email' => "unodashmina@mopa.gov.bd", 'bn_name' => 'দশমিনা', 'url' => 'dashmina.patuakhali.gov.bd'],
            ['id' => '238', 'district_id' => '31', 'name' => 'Kalapara', 'email' => "unokalapara@mopa.gov.bd", 'bn_name' => 'কলাপাড়া', 'url' => 'kalapara.patuakhali.gov.bd'],
            ['id' => '239', 'district_id' => '31', 'name' => 'Mirzaganj', 'email' => "unomirzaganj@mopa.gov.bd", 'bn_name' => 'মির্জাগঞ্জ', 'url' => 'mirzaganj.patuakhali.gov.bd'],
            ['id' => '240', 'district_id' => '31', 'name' => 'Galachipa', 'email' => "unogalachipa@mopa.gov.bd", 'bn_name' => 'গলাচিপা', 'url' => 'galachipa.patuakhali.gov.bd'],
            ['id' => '241', 'district_id' => '31', 'name' => 'Rangabali', 'email' => "unorangabali@mopa.gov.bd", 'bn_name' => 'রাঙ্গাবালী', 'url' => 'rangabali.patuakhali.gov.bd'],

            ['id' => '242', 'district_id' => '32', 'name' => 'Pirojpur Sadar', 'email' => "unopirojpur@mopa.gov.bd", 'bn_name' => 'পিরোজপুর সদর', 'url' => 'sadar.pirojpur.gov.bd'],
            ['id' => '243', 'district_id' => '32', 'name' => 'Nazirpur', 'email' => "unonazirpur@mopa.gov.bd", 'bn_name' => 'নাজিরপুর', 'url' => 'nazirpur.pirojpur.gov.bd'],
            ['id' => '244', 'district_id' => '32', 'name' => 'Kawkhali', 'email' => "unokawkhalipirojpur@mopa.gov.bd", 'bn_name' => 'কাউখালী', 'url' => 'kawkhali.pirojpur.gov.bd'],
            ['id' => '245', 'district_id' => '32', 'name' => 'Zianagar', 'email' => "unozianagar@mopa.gov.bd", 'bn_name' => 'জিয়ানগর', 'url' => 'zianagar.pirojpur.gov.bd'],
            ['id' => '246', 'district_id' => '32', 'name' => 'Bhandaria', 'email' => "unobhandaria@mopa.gov.bd", 'bn_name' => 'ভান্ডারিয়া', 'url' => 'bhandaria.pirojpur.gov.bd'],
            ['id' => '247', 'district_id' => '32', 'name' => 'Mathbaria', 'email' => "unomathbaria@mopa.gov.bd", 'bn_name' => 'মঠবাড়ীয়া', 'url' => 'mathbaria.pirojpur.gov.bd'],
            ['id' => '248', 'district_id' => '32', 'name' => 'Nesarabad', 'email' => "unonesarabad@mopa.gov.bd", 'bn_name' => 'নেছারাবাদ', 'url' => 'nesarabad.pirojpur.gov.bd'],

            ['id' => '249', 'district_id' => '33', 'name' => 'Barisal Sadar', 'email' => 'unobarisal@mopa.gov.bd', 'bn_name' => 'বরিশাল সদর', 'url' => 'barisalsadar.barisal.gov.bd'],
            ['id' => '250', 'district_id' => '33', 'name' => 'Bakerganj', 'email' => 'unobakerganj@mopa.gov.bd', 'bn_name' => 'বাকেরগঞ্জ', 'url' => 'bakerganj.barisal.gov.bd'],
            ['id' => '251', 'district_id' => '33', 'name' => 'Babuganj', 'email' => 'unobabuganj@mopa.gov.bd', 'bn_name' => 'বাবুগঞ্জ', 'url' => 'babuganj.barisal.gov.bd'],
            ['id' => '252', 'district_id' => '33', 'name' => 'Wazirpur', 'email' => 'unowazirpur@mopa.gov.bd', 'bn_name' => 'উজিরপুর', 'url' => 'wazirpur.barisal.gov.bd'],
            ['id' => '253', 'district_id' => '33', 'name' => 'Banaripara', 'email' => 'unobanaripara@mopa.gov.bd', 'bn_name' => 'বানারীপাড়া', 'url' => 'banaripara.barisal.gov.bd'],
            ['id' => '254', 'district_id' => '33', 'name' => 'Gournadi', 'email' => 'unogournadi@mopa.gov.bd', 'bn_name' => 'গৌরনদী', 'url' => 'gournadi.barisal.gov.bd'],
            ['id' => '255', 'district_id' => '33', 'name' => 'Agailjhara', 'email' => 'unoagailjhara@mopa.gov.bd', 'bn_name' => 'আগৈলঝাড়া', 'url' => 'agailjhara.barisal.gov.bd'],
            ['id' => '256', 'district_id' => '33', 'name' => 'Mehendiganj', 'email' => 'unomehendiganj@mopa.gov.bd', 'bn_name' => 'মেহেন্দিগঞ্জ', 'url' => 'mehendiganj.barisal.gov.bd'],
            ['id' => '257', 'district_id' => '33', 'name' => 'Muladi', 'email' => "", 'bn_name' => 'মুলাদী', 'url' => 'muladi.barisal.gov.bd'],
            ['id' => '258', 'district_id' => '33', 'name' => 'Hizla', 'email' => 'unohizla@mopa.gov.bd', 'bn_name' => 'হিজলা', 'url' => 'hizla.barisal.gov.bd'],

            ['id' => '259', 'district_id' => '34', 'name' => 'Bhola Sadar', 'bn_name' => 'ভোলা সদর', 'url' => 'sadar.bhola.gov.bd', 'email' => 'unobhola@mopa.gov.bd'],
            ['id' => '260', 'district_id' => '34', 'name' => 'Borhan Sddin', 'bn_name' => 'বোরহান উদ্দিন', 'url' => 'borhanuddin.bhola.gov.bd', 'email' => 'unoborhanuddin@mopa.gov.bd'],
            ['id' => '261', 'district_id' => '34', 'name' => 'Charfesson', 'bn_name' => 'চরফ্যাশন', 'url' => 'charfesson.bhola.gov.bd', 'email' => 'unocharfesson@mopa.gov.bd'],
            ['id' => '262', 'district_id' => '34', 'name' => 'Doulatkhan', 'bn_name' => 'দৌলতখান', 'url' => 'doulatkhan.bhola.gov.bd', 'email' => 'unodaulatkhan@mopa.gov.bd'],
            ['id' => '263', 'district_id' => '34', 'name' => 'Monpura', 'bn_name' => 'মনপুরা', 'url' => 'monpura.bhola.gov.bd', 'email' => 'unomonpura@mopa.gov.bd'],
            ['id' => '264', 'district_id' => '34', 'name' => 'Tazumuddin', 'bn_name' => 'তজুমদ্দিন', 'url' => 'tazumuddin.bhola.gov.bd', 'email' => 'unotazumuddin@mopa.gov.bd'],
            ['id' => '265', 'district_id' => '34', 'name' => 'Lalmohan', 'bn_name' => 'লালমোহন', 'url' => 'lalmohan.bhola.gov.bd', 'email' => 'unolalmohan@mopa.gov.bd'],

            ['id' => '266', 'district_id' => '35', 'email' => "unoamtali@mopa.gov.bd", 'name' => 'Amtali', 'bn_name' => 'আমতলী', 'url' => 'amtali.barguna.gov.bd'],
            ['id' => '267', 'district_id' => '35', 'email' => "unobarguna@mopa.gov.bd", 'name' => 'Barguna Sadar', 'bn_name' => 'বরগুনা সদর', 'url' => 'sadar.barguna.gov.bd'],
            ['id' => '268', 'district_id' => '35', 'email' => "unobetagi@mopa.gov.bd", 'name' => 'Betagi', 'bn_name' => 'বেতাগী', 'url' => 'betagi.barguna.gov.bd'],
            ['id' => '269', 'district_id' => '35', 'email' => "unobamna@mopa.gov.bd", 'name' => 'Bamna', 'bn_name' => 'বামনা', 'url' => 'bamna.barguna.gov.bd'],
            ['id' => '270', 'district_id' => '35', 'email' => "unopatharghata@mopa.gov.bd", 'name' => 'Pathorghata', 'bn_name' => 'পাথরঘাটা', 'url' => 'pathorghata.barguna.gov.bd'],
            ['id' => '271', 'district_id' => '35', 'email' => "unotaltoli@mopa.gov.bd", 'name' => 'Taltali', 'bn_name' => 'তালতলি', 'url' => 'taltali.barguna.gov.bd'],

            ['id' => '272', 'district_id' => '36', 'name' => 'Balaganj', 'email' => "unobalaganj@mopa.gov.bd", 'bn_name' => 'বালাগঞ্জ', 'url' => 'balaganj.sylhet.gov.bd'],
            ['id' => '273', 'district_id' => '36', 'name' => 'Beanibazar', 'email' => "unobeanibazar@mopa.gov.bd", 'bn_name' => 'বিয়ানীবাজার', 'url' => 'beanibazar.sylhet.gov.bd'],
            ['id' => '274', 'district_id' => '36', 'name' => 'Bishwanath', 'email' => "unobiswanath@mopa.gov.bd", 'bn_name' => 'বিশ্বনাথ', 'url' => 'bishwanath.sylhet.gov.bd'],
            ['id' => '275', 'district_id' => '36', 'name' => 'Companiganj', 'email' => "unocompaniganjsylhet@mopa.gov.bd", 'bn_name' => 'কোম্পানীগঞ্জ', 'url' => 'companiganj.sylhet.gov.bd'],
            ['id' => '276', 'district_id' => '36', 'name' => 'Fenchuganj', 'email' => "unofenchuganj@mopa.gov.bd", 'bn_name' => 'ফেঞ্চুগঞ্জ', 'url' => 'fenchuganj.sylhet.gov.bd'],
            ['id' => '277', 'district_id' => '36', 'name' => 'Golapganj', 'email' => "unogolapganj@mopa.gov.bd", 'bn_name' => 'গোলাপগঞ্জ', 'url' => 'golapganj.sylhet.gov.bd'],
            ['id' => '278', 'district_id' => '36', 'name' => 'Gowainghat', 'email' => "unogowainghat@mopa.gov.bd", 'bn_name' => 'গোয়াইনঘাট', 'url' => 'gowainghat.sylhet.gov.bd'],
            ['id' => '279', 'district_id' => '36', 'name' => 'Jaintiapur', 'email' => "unojaintapur@mopa.gov.bd", 'bn_name' => 'জৈন্তাপুর', 'url' => 'jaintiapur.sylhet.gov.bd'],
            ['id' => '280', 'district_id' => '36', 'name' => 'Kanaighat', 'email' => "unokanaighat@mopa.gov.bd", 'bn_name' => 'কানাইঘাট', 'url' => 'kanaighat.sylhet.gov.bd'],
            ['id' => '281', 'district_id' => '36', 'name' => 'Sylhet Sadar', 'email' => "unosylhet@mopa.gov.bd", 'bn_name' => 'সিলেট সদর', 'url' => 'sylhetsadar.sylhet.gov.bd'],
            ['id' => '282', 'district_id' => '36', 'name' => 'Zakiganj', 'email' => "unozakiganj@mopa.gov.bd", 'bn_name' => 'জকিগঞ্জ', 'url' => 'zakiganj.sylhet.gov.bd'],
            ['id' => '283', 'district_id' => '36', 'name' => 'Dakshinsurma', 'email' => "unosouthshurma@mopa.gov.bd", 'bn_name' => 'দক্ষিণ সুরমা', 'url' => 'dakshinsurma.sylhet.gov.bd'],
            ['id' => '284', 'district_id' => '36', 'name' => 'Osmaninagar', 'email' => "", 'bn_name' => 'ওসমানী নগর', 'url' => 'osmaninagar.sylhet.gov.bd'],

            ['id' => '285', 'district_id' => '37', 'name' => 'Barlekha', 'email' => "unobaralekha@mopa.gov.bd", 'bn_name' => 'বড়লেখা', 'url' => 'barlekha.moulvibazar.gov.bd'],
            ['id' => '286', 'district_id' => '37', 'name' => 'Kamolganj', 'email' => "unokamalganj@mopa.gov.bd", 'bn_name' => 'কমলগঞ্জ', 'url' => 'kamolganj.moulvibazar.gov.bd'],
            ['id' => '287', 'district_id' => '37', 'name' => 'Kulaura', 'email' => "unokulaura@mopa.gov.bd", 'bn_name' => 'কুলাউড়া', 'url' => 'kulaura.moulvibazar.gov.bd'],
            ['id' => '288', 'district_id' => '37', 'name' => 'Moulvibazar Sadar', 'email' => "unomoulvibazar@mopa.gov.bd", 'bn_name' => 'মৌলভীবাজার সদর', 'url' => 'moulvibazarsadar.moulvibazar.gov.bd'],
            ['id' => '289', 'district_id' => '37', 'name' => 'Rajnagar', 'email' => "unorajnagar@mopa.gov.bd", 'bn_name' => 'রাজনগর', 'url' => 'rajnagar.moulvibazar.gov.bd'],
            ['id' => '290', 'district_id' => '37', 'name' => 'Sreemangal', 'email' => "unosreemangal@mopa.gov.bd", 'bn_name' => 'শ্রীমঙ্গল', 'url' => 'sreemangal.moulvibazar.gov.bd'],
            ['id' => '291', 'district_id' => '37', 'name' => 'Juri', 'email' => "unojuri@mopa.gov.bd", 'bn_name' => 'জুড়ী', 'url' => 'juri.moulvibazar.gov.bd'],

            ['id' => '292', 'district_id' => '38', 'name' => 'Nabiganj', 'bn_name' => 'নবীগঞ্জ', 'url' => 'nabiganj.habiganj.gov.bd', 'email' => 'unonabiganj@mopa.gov.bd'],
            ['id' => '293', 'district_id' => '38', 'name' => 'Bahubal', 'bn_name' => 'বাহুবল', 'url' => 'bahubal.habiganj.gov.bd', 'email' => ''],
            ['id' => '294', 'district_id' => '38', 'name' => 'Ajmiriganj', 'bn_name' => 'আজমিরীগঞ্জ', 'url' => 'ajmiriganj.habiganj.gov.bd', 'email' => 'unoajmiriganj@mopa.gov.bd'],
            ['id' => '295', 'district_id' => '38', 'name' => 'Baniachong', 'bn_name' => 'বানিয়াচং', 'url' => 'baniachong.habiganj.gov.bd', 'email' => 'unobaniachong@mopa.gov.bd'],
            ['id' => '296', 'district_id' => '38', 'name' => 'Lakhai', 'bn_name' => 'লাখাই', 'url' => 'lakhai.habiganj.gov.bd', 'email' => ''],
            ['id' => '297', 'district_id' => '38', 'name' => 'Chunarughat', 'bn_name' => 'চুনারুঘাট', 'url' => 'chunarughat.habiganj.gov.bd', 'email' => 'unochunarughat@mopa.gov.bd'],
            ['id' => '298', 'district_id' => '38', 'name' => 'Habiganj Sadar', 'bn_name' => 'হবিগঞ্জ সদর', 'url' => 'habiganjsadar.habiganj.gov.bd', 'email' => 'unohabiganj@mopa.gov.bd'],
            ['id' => '299', 'district_id' => '38', 'name' => 'Madhabpur', 'bn_name' => 'মাধবপুর', 'url' => 'madhabpur.habiganj.gov.bd', 'email' => 'unomadhabpur@mopa.gov.bd'],

            ['id' => '300', 'district_id' => '39', 'name' => 'Sunamganj Sadar', 'bn_name' => 'সুনামগঞ্জ সদর', 'url' => 'sadar.sunamganj.gov.bd', 'email' => 'unosunamganj@mopa.gov.bd'],
            ['id' => '301', 'district_id' => '39', 'name' => 'South Sunamganj', 'bn_name' => 'দক্ষিণ সুনামগঞ্জ', 'url' => 'southsunamganj.sunamganj.gov.bd', 'email' => 'unosouthsunamganj@mopa.gov.bd'],
            ['id' => '302', 'district_id' => '39', 'name' => 'Bishwambarpur', 'bn_name' => 'বিশ্বম্ভরপুর', 'url' => 'bishwambarpur.sunamganj.gov.bd', 'email' => 'unobishwamvarpur@mopa.gov.bd'],
            ['id' => '303', 'district_id' => '39', 'name' => 'Chhatak', 'bn_name' => 'ছাতক', 'url' => 'chhatak.sunamganj.gov.bd', 'email' => 'unochhatak@mopa.gov.bd'],
            ['id' => '304', 'district_id' => '39', 'name' => 'Jagannathpur', 'bn_name' => 'জগন্নাথপুর', 'url' => 'jagannathpur.sunamganj.gov.bd', 'email' => 'unojagannathpur@mopa.gov.bd'],
            ['id' => '305', 'district_id' => '39', 'name' => 'Dowarabazar', 'bn_name' => 'দোয়ারাবাজার', 'url' => 'dowarabazar.sunamganj.gov.bd', 'email' => 'unodoarabazar@mopa.gov.bd'],
            ['id' => '306', 'district_id' => '39', 'name' => 'Tahirpur', 'bn_name' => 'তাহিরপুর', 'url' => 'tahirpur.sunamganj.gov.bd', 'email' => 'unotahirpur@mopa.gov.bd'],
            ['id' => '307', 'district_id' => '39', 'name' => 'Dharmapasha', 'bn_name' => 'ধর্মপাশা', 'url' => 'dharmapasha.sunamganj.gov.bd', 'email' => 'unodharmapasha@mopa.gov.bd'],
            ['id' => '308', 'district_id' => '39', 'name' => 'Jamalganj', 'bn_name' => 'জামালগঞ্জ', 'url' => 'jamalganj.sunamganj.gov.bd', 'email' => 'unojamalganj@mopa.gov.bd'],
            ['id' => '309', 'district_id' => '39', 'name' => 'Shalla', 'bn_name' => 'শাল্লা', 'url' => 'shalla.sunamganj.gov.bd', 'email' => 'unoshalla@mopa.gov.bd'],
            ['id' => '310', 'district_id' => '39', 'name' => 'Derai', 'bn_name' => 'দিরাই', 'url' => 'derai.sunamganj.gov.bd', 'email' => 'unoderai@mopa.gov.bd'],

            ['id' => '311', 'district_id' => '40', 'name' => 'Belabo', 'email' => "unobelabo@mopa.gov.bd", 'bn_name' => 'বেলাবো', 'url' => 'belabo.narsingdi.gov.bd'],
            ['id' => '312', 'district_id' => '40', 'name' => 'Monohardi', 'email' => "unomonohardi@mopa.gov.bd", 'bn_name' => 'মনোহরদী', 'url' => 'monohardi.narsingdi.gov.bd'],
            ['id' => '313', 'district_id' => '40', 'name' => 'Narsingdi Sadar', 'email' => "unonarsingdi@mopa.gov.bd", 'bn_name' => 'নরসিংদী সদর', 'url' => 'narsingdisadar.narsingdi.gov.bd'],
            ['id' => '314', 'district_id' => '40', 'name' => 'Palash', 'email' => "unopalash@mopa.gov.bd", 'bn_name' => 'পলাশ', 'url' => 'palash.narsingdi.gov.bd'],
            ['id' => '315', 'district_id' => '40', 'name' => 'Raipura', 'email' => "unoraipura@mopa.gov.bd", 'bn_name' => 'রায়পুরা', 'url' => 'raipura.narsingdi.gov.bd'],
            ['id' => '316', 'district_id' => '40', 'name' => 'Shibpur', 'email' => "unoshibpur@mopa.gov.bd", 'bn_name' => 'শিবপুর', 'url' => 'shibpur.narsingdi.gov.bd'],

            ['id' => '317', 'district_id' => '41', 'name' => 'Kaliganj', 'email' => "unokaliganjgazipur@mopa.gov.bd", 'bn_name' => 'কালীগঞ্জ', 'url' => 'kaliganj.gazipur.gov.bd'],
            ['id' => '318', 'district_id' => '41', 'name' => 'Kaliakair', 'email' => "unokaliakair@mopa.gov.bd", 'bn_name' => 'কালিয়াকৈর', 'url' => 'kaliakair.gazipur.gov.bd'],
            ['id' => '319', 'district_id' => '41', 'name' => 'Kapasia', 'email' => "unokapasia@mopa.gov.bd", 'bn_name' => 'কাপাসিয়া', 'url' => 'kapasia.gazipur.gov.bd'],
            ['id' => '320', 'district_id' => '41', 'name' => 'Gazipur Sadar', 'email' => "unogazipur@mopa.gov.bd", 'bn_name' => 'গাজীপুর সদর', 'url' => 'sadar.gazipur.gov.bd'],
            ['id' => '321', 'district_id' => '41', 'name' => 'Sreepur', 'email' => "unosreepurgazipur@mopa.gov.bd", 'bn_name' => 'শ্রীপুর', 'url' => 'sreepur.gazipur.gov.bd'],

            ['id' => '322', 'district_id' => '42', 'name' => 'Shariatpur Sadar', 'email' => "unoshariatpur@mopa.gov.bd", 'bn_name' => 'শরিয়তপুর সদর', 'url' => 'sadar.shariatpur.gov.bd'],
            ['id' => '323', 'district_id' => '42', 'name' => 'Naria', 'email' => "unonaria@mopa.gov.bd", 'bn_name' => 'নড়িয়া', 'url' => 'naria.shariatpur.gov.bd'],
            ['id' => '324', 'district_id' => '42', 'name' => 'Zajira', 'email' => "unozajira@mopa.gov.bd", 'bn_name' => 'জাজিরা', 'url' => 'zajira.shariatpur.gov.bd'],
            ['id' => '325', 'district_id' => '42', 'name' => 'Gosairhat', 'email' => "unogoshairhat@mopa.gov.bd", 'bn_name' => 'গোসাইরহাট', 'url' => 'gosairhat.shariatpur.gov.bd'],
            ['id' => '326', 'district_id' => '42', 'name' => 'Bhedarganj', 'email' => "unobhedarganj@mopa.gov.bd", 'bn_name' => 'ভেদরগঞ্জ', 'url' => 'bhedarganj.shariatpur.gov.bd'],
            ['id' => '327', 'district_id' => '42', 'name' => 'Damudya', 'email' => "unodamudya@mopa.gov.bd", 'bn_name' => 'ডামুড্যা', 'url' => 'damudya.shariatpur.gov.bd'],

            ['id' => '328', 'district_id' => '43', 'name' => 'Araihazar', 'email' => "unoaraihazar@mopa.gov.bd", 'bn_name' => 'আড়াইহাজার', 'url' => 'araihazar.narayanganj.gov.bd'],
            ['id' => '329', 'district_id' => '43', 'name' => 'Bandar', 'email' => "unobondor@mopa.gov.bd", 'bn_name' => 'বন্দর', 'url' => 'bandar.narayanganj.gov.bd'],
            ['id' => '330', 'district_id' => '43', 'name' => 'Narayanganj Sadar', 'email' => "unonarayanganj@mopa.gov.bd", 'bn_name' => 'নারায়নগঞ্জ সদর', 'url' => 'narayanganjsadar.narayanganj.gov.bd'],
            ['id' => '331', 'district_id' => '43', 'name' => 'Rupganj', 'email' => "unorupganj@mopa.gov.bd", 'bn_name' => 'রূপগঞ্জ', 'url' => 'rupganj.narayanganj.gov.bd'],
            ['id' => '332', 'district_id' => '43', 'name' => 'Sonargaon', 'email' => "unosonargaon@mopa.gov.bd", 'bn_name' => 'সোনারগাঁ', 'url' => 'sonargaon.narayanganj.gov.bd'],

            ['id' => '333', 'district_id' => '44', 'name' => 'Basail', 'bn_name' => 'বাসাইল', 'url' => 'basail.tangail.gov.bd', 'email' => 'unobashail@mopa.gov.bd'],
            ['id' => '334', 'district_id' => '44', 'name' => 'Bhuapur', 'bn_name' => 'ভুয়াপুর', 'url' => 'bhuapur.tangail.gov.bd', 'email' => 'unobhuapur@mopa.gov.bd'],
            ['id' => '335', 'district_id' => '44', 'name' => 'Delduar', 'bn_name' => 'দেলদুয়ার', 'url' => 'delduar.tangail.gov.bd', 'email' => 'unodelduar@mopa.gov.bd'],
            ['id' => '336', 'district_id' => '44', 'name' => 'Ghatail', 'bn_name' => 'ঘাটাইল', 'url' => 'ghatail.tangail.gov.bd', 'email' => 'unoghatail@mopa.gov.bd'],
            ['id' => '337', 'district_id' => '44', 'name' => 'Gopalpur', 'bn_name' => 'গোপালপুর', 'url' => 'gopalpur.tangail.gov.bd', 'email' => 'unogopalpur@mopa.gov.bd'],
            ['id' => '338', 'district_id' => '44', 'name' => 'Madhupur', 'bn_name' => 'মধুপুর', 'url' => 'madhupur.tangail.gov.bd', 'email' => 'unomadhupur@mopa.gov.bd'],
            ['id' => '339', 'district_id' => '44', 'name' => 'Mirzapur', 'bn_name' => 'মির্জাপুর', 'url' => 'mirzapur.tangail.gov.bd', 'email' => 'unomirzapur@mopa.gov.bd'],
            ['id' => '340', 'district_id' => '44', 'name' => 'Nagarpur', 'bn_name' => 'নাগরপুর', 'url' => 'nagarpur.tangail.gov.bd', 'email' => 'unonagarpur@mopa.gov.bd'],
            ['id' => '341', 'district_id' => '44', 'name' => 'Sakhipur', 'bn_name' => 'সখিপুর', 'url' => 'sakhipur.tangail.gov.bd', 'email' => 'unoshakhipur@mopa.gov.bd'],
            ['id' => '342', 'district_id' => '44', 'name' => 'Tangail Sadar', 'bn_name' => 'টাঙ্গাইল সদর', 'url' => 'tangailsadar.tangail.gov.bd', 'email' => 'unotangail@mopa.gov.bd'],
            ['id' => '343', 'district_id' => '44', 'name' => 'Kalihati', 'bn_name' => 'কালিহাতী', 'url' => 'kalihati.tangail.gov.bd', 'email' => 'unokalihati@mopa.gov.bd'],
            ['id' => '344', 'district_id' => '44', 'name' => 'Dhanbari', 'bn_name' => 'ধনবাড়ী', 'url' => 'dhanbari.tangail.gov.bd', 'email' => 'unodhanbari@mopa.gov.bd'],

            ['id' => '345', 'district_id' => '45', 'name' => 'Itna', 'bn_name' => 'ইটনা', 'url' => 'itna.kishoreganj.gov.bd', 'email' => 'unoitna@mopa.gov.bd'],
            ['id' => '346', 'district_id' => '45', 'name' => 'Katiadi', 'bn_name' => 'কটিয়াদী', 'url' => 'katiadi.kishoreganj.gov.bd', 'email' => 'unokatiadi@mopa.gov.bd'],
            ['id' => '347', 'district_id' => '45', 'name' => 'Bhairab', 'bn_name' => 'ভৈরব', 'url' => 'bhairab.kishoreganj.gov.bd', 'email' => 'unobhairab@mopa.gov.bd'],
            ['id' => '348', 'district_id' => '45', 'name' => 'Tarail', 'bn_name' => 'তাড়াইল', 'url' => 'tarail.kishoreganj.gov.bd', 'email' => 'unotarail@mopa.gov.bd'],
            ['id' => '349', 'district_id' => '45', 'name' => 'Hossainpur', 'bn_name' => 'হোসেনপুর', 'url' => 'hossainpur.kishoreganj.gov.bd', 'email' => 'unohossainpur@mopa.gov.bd'],
            ['id' => '350', 'district_id' => '45', 'name' => 'Pakundia', 'bn_name' => 'পাকুন্দিয়া', 'url' => 'pakundia.kishoreganj.gov.bd', 'email' => 'unopakundia@mopa.gov.bd'],
            ['id' => '351', 'district_id' => '45', 'name' => 'Kuliarchar', 'bn_name' => 'কুলিয়ারচর', 'url' => 'kuliarchar.kishoreganj.gov.bd', 'email' => 'unokuliarchar@mopa.gov.bd'],
            ['id' => '352', 'district_id' => '45', 'name' => 'Kishoreganj Sadar', 'bn_name' => 'কিশোরগঞ্জ সদর', 'url' => 'kishoreganjsadar.kishoreganj.gov.bd', 'email' => 'unokishoreganj@mopa.gov.bd'],
            ['id' => '353', 'district_id' => '45', 'name' => 'Karimgonj', 'bn_name' => 'করিমগঞ্জ', 'url' => 'karimgonj.kishoreganj.gov.bd', 'email' => 'unokarimganj@mopa.gov.bd'],
            ['id' => '354', 'district_id' => '45', 'name' => 'Bajitpur', 'bn_name' => 'বাজিতপুর', 'url' => 'bajitpur.kishoreganj.gov.bd', 'email' => 'unobajitpur@mopa.gov.bd'],
            ['id' => '355', 'district_id' => '45', 'name' => 'Austagram', 'bn_name' => 'অষ্টগ্রাম', 'url' => 'austagram.kishoreganj.gov.bd', 'email' => 'unoaustagram@mopa.gov.bd'],
            ['id' => '356', 'district_id' => '45', 'name' => 'Mithamoin', 'bn_name' => 'মিঠামইন', 'url' => 'mithamoin.kishoreganj.gov.bd', 'email' => 'unomithamoin@mopa.gov.bd'],
            ['id' => '357', 'district_id' => '45', 'name' => 'Nikli', 'bn_name' => 'নিকলী', 'url' => 'nikli.kishoreganj.gov.bd', 'email' => 'unonikli@mopa.gov.bd'],

            ['id' => '358', 'district_id' => '46', 'name' => 'Harirampur', 'email' => "unoharirampur@mopa.gov.bd", 'bn_name' => 'হরিরামপুর', 'url' => 'harirampur.manikganj.gov.bd'],
            ['id' => '359', 'district_id' => '46', 'name' => 'Saturia', 'email' => "unosaturia@mopa.gov.bd", 'bn_name' => 'সাটুরিয়া', 'url' => 'saturia.manikganj.gov.bd'],
            ['id' => '360', 'district_id' => '46', 'name' => 'Manikganj Sadar', 'email' => "unomanikganj@mopa.gov.bd", 'bn_name' => 'মানিকগঞ্জ সদর', 'url' => 'sadar.manikganj.gov.bd'],
            ['id' => '361', 'district_id' => '46', 'name' => 'Gior', 'email' => "unoghior@mopa.gov.bd", 'bn_name' => 'ঘিওর', 'url' => 'gior.manikganj.gov.bd'],
            ['id' => '362', 'district_id' => '46', 'name' => 'Shibaloy', 'email' => "unoshibalay@mopa.gov.bd", 'bn_name' => 'শিবালয়', 'url' => 'shibaloy.manikganj.gov.bd'],
            ['id' => '363', 'district_id' => '46', 'name' => 'Doulatpur', 'email' => "unodaulatpurmanikganj@mopa.gov.bd", 'bn_name' => 'দৌলতপুর', 'url' => 'doulatpur.manikganj.gov.bd'],
            ['id' => '364', 'district_id' => '46', 'name' => 'Singiar', 'email' => "unosingair@mopa.gov.bd", 'bn_name' => 'সিংগাইর', 'url' => 'singiar.manikganj.gov.bd'],

            ['id' => '365', 'district_id' => '47', 'name' => 'Savar', 'email' => "unosavar@mopa.gov.bd", 'bn_name' => 'সাভার', 'url' => 'savar.dhaka.gov.bd'],
            ['id' => '366', 'district_id' => '47', 'name' => 'Dhamrai', 'email' => "unodhamrai@mopa.gov.bd", 'bn_name' => 'ধামরাই', 'url' => 'dhamrai.dhaka.gov.bd'],
            ['id' => '367', 'district_id' => '47', 'name' => 'Keraniganj', 'email' => "unokeraniganj@mopa.gov.bd", 'bn_name' => 'কেরাণীগঞ্জ', 'url' => 'keraniganj.dhaka.gov.bd'],
            ['id' => '368', 'district_id' => '47', 'name' => 'Nawabganj', 'email' => "unonawabganjdhaka@mopa.gov.bd", 'bn_name' => 'নবাবগঞ্জ', 'url' => 'nawabganj.dhaka.gov.bd'],
            ['id' => '369', 'district_id' => '47', 'name' => 'Dohar', 'email' => "unodohar@mopa.gov.bd", 'bn_name' => 'দোহার', 'url' => 'dohar.dhaka.gov.bd'],

            ['id' => '370', 'district_id' => '48', 'name' => 'Munshiganj Sadar', 'email' => "unomunshiganj@mopa.gov.bd", 'bn_name' => 'মুন্সিগঞ্জ সদর', 'url' => 'sadar.munshiganj.gov.bd'],
            ['id' => '371', 'district_id' => '48', 'name' => 'Sreenagar', 'email' => "unosreenagar@mopa.gov.bd", 'bn_name' => 'শ্রীনগর', 'url' => 'sreenagar.munshiganj.gov.bd'],
            ['id' => '372', 'district_id' => '48', 'name' => 'Sirajdikhan', 'email' => "unoserajdikhan@mopa.gov.bd", 'bn_name' => 'সিরাজদিখান', 'url' => 'sirajdikhan.munshiganj.gov.bd'],
            ['id' => '373', 'district_id' => '48', 'name' => 'Louhajanj', 'email' => "unolouhajanj@mopa.gov.bd", 'bn_name' => 'লৌহজং', 'url' => 'louhajanj.munshiganj.gov.bd'],
            ['id' => '374', 'district_id' => '48', 'name' => 'Gajaria', 'email' => "unogajaria@mopa.gov.bd", 'bn_name' => 'গজারিয়া', 'url' => 'gajaria.munshiganj.gov.bd'],
            ['id' => '375', 'district_id' => '48', 'name' => 'Tongibari', 'email' => "unotongibari@mopa.gov.bd", 'bn_name' => 'টংগীবাড়ি', 'url' => 'tongibari.munshiganj.gov.bd'],

            ['id' => '376', 'district_id' => '49', 'name' => 'Rajbari Sadar', 'email' => "unorajbari@mopa.gov.bd", 'bn_name' => 'রাজবাড়ী সদর', 'url' => 'sadar.rajbari.gov.bd'],
            ['id' => '377', 'district_id' => '49', 'name' => 'Goalanda', 'email' => "unogoalanda@mopa.gov.bd", 'bn_name' => 'গোয়ালন্দ', 'url' => 'goalanda.rajbari.gov.bd'],
            ['id' => '378', 'district_id' => '49', 'name' => 'Pangsa', 'email' => "unopangsa@mopa.gov.bd", 'bn_name' => 'পাংশা', 'url' => 'pangsa.rajbari.gov.bd'],
            ['id' => '379', 'district_id' => '49', 'name' => 'Baliakandi', 'email' => "unobaliakandi@mopa.gov.bd", 'bn_name' => 'বালিয়াকান্দি', 'url' => 'baliakandi.rajbari.gov.bd'],
            ['id' => '380', 'district_id' => '49', 'name' => 'Kalukhali', 'email' => "unokalukhali@mopa.gov.bd", 'bn_name' => 'কালুখালী', 'url' => 'kalukhali.rajbari.gov.bd'],

            ['id' => '381', 'district_id' => '50', 'name' => 'Madaripur Sadar', 'email' => "unomadaripur@mopa.gov.bd", 'bn_name' => 'মাদারীপুর সদর', 'url' => 'sadar.madaripur.gov.bd'],
            ['id' => '382', 'district_id' => '50', 'name' => 'Shibchar', 'email' => "unoshibchar@mopa.gov.bd", 'bn_name' => 'শিবচর', 'url' => 'shibchar.madaripur.gov.bd'],
            ['id' => '383', 'district_id' => '50', 'name' => 'Kalkini', 'email' => "unokalkini@mopa.gov.bd", 'bn_name' => 'কালকিনি', 'url' => 'kalkini.madaripur.gov.bd'],
            ['id' => '384', 'district_id' => '50', 'name' => 'Rajoir', 'email' => "unorajoir@mopa.gov.bd", 'bn_name' => 'রাজৈর', 'url' => 'rajoir.madaripur.gov.bd'],

            ['id' => '385', 'district_id' => '51', 'name' => 'Gopalganj Sadar', 'email' => "unogopalganj@mopa.gov.bd", 'bn_name' => 'গোপালগঞ্জ সদর', 'url' => 'sadar.gopalganj.gov.bd'],
            ['id' => '386', 'district_id' => '51', 'name' => 'Kashiani', 'email' => "unokasiani@mopa.gov.bd", 'bn_name' => 'কাশিয়ানী', 'url' => 'kashiani.gopalganj.gov.bd'],
            ['id' => '387', 'district_id' => '51', 'name' => 'Tungipara', 'email' => "unotungipara@mopa.gov.bd", 'bn_name' => 'টুংগীপাড়া', 'url' => 'tungipara.gopalganj.gov.bd'],
            ['id' => '388', 'district_id' => '51', 'name' => 'Kotalipara', 'email' => "unokotalipara@mopa.gov.bd", 'bn_name' => 'কোটালীপাড়া', 'url' => 'kotalipara.gopalganj.gov.bd'],
            ['id' => '389', 'district_id' => '51', 'name' => 'Muksudpur', 'email' => "unomaksudpur@mopa.gov.bd", 'bn_name' => 'মুকসুদপুর', 'url' => 'muksudpur.gopalganj.gov.bd'],

            ['id' => '390', 'district_id' => '52', 'name' => 'Faridpur Sadar', 'bn_name' => 'ফরিদপুর সদর', 'url' => 'sadar.faridpur.gov.bd', 'email' => 'unofaridpur@mopa.gov.bd'],
            ['id' => '391', 'district_id' => '52', 'name' => 'Alfadanga', 'bn_name' => 'আলফাডাঙ্গা', 'url' => 'alfadanga.faridpur.gov.bd', 'email' => 'unoalfadanga@mopa.gov.bd'],
            ['id' => '392', 'district_id' => '52', 'name' => 'Boalmari', 'bn_name' => 'বোয়ালমারী', 'url' => 'boalmari.faridpur.gov.bd', 'email' => 'unoboalmari@mopa.gov.bd'],
            ['id' => '393', 'district_id' => '52', 'name' => 'Sadarpur', 'bn_name' => 'সদরপুর', 'url' => 'sadarpur.faridpur.gov.bd', 'email' => 'unosadarpur@mopa.gov.bd'],
            ['id' => '394', 'district_id' => '52', 'name' => 'Nagarkanda', 'bn_name' => 'নগরকান্দা', 'url' => 'nagarkanda.faridpur.gov.bd', 'email' => 'unonagarkanda@mopa.gov.bd'],
            ['id' => '395', 'district_id' => '52', 'name' => 'Bhanga', 'bn_name' => 'ভাঙ্গা', 'url' => 'bhanga.faridpur.gov.bd', 'email' => 'unobhanga@mopa.gov.bd'],
            ['id' => '396', 'district_id' => '52', 'name' => 'Charbhadrasan', 'bn_name' => 'চরভদ্রাসন', 'url' => 'charbhadrasan.faridpur.gov.bd', 'email' => 'unocharbhadrasan@mopa.gov.bd'],
            ['id' => '397', 'district_id' => '52', 'name' => 'Madhukhali', 'bn_name' => 'মধুখালী', 'url' => 'madhukhali.faridpur.gov.bd', 'email' => 'unomadhukhali@mopa.gov.bd'],
            ['id' => '398', 'district_id' => '52', 'name' => 'Saltha', 'bn_name' => 'সালথা', 'url' => 'saltha.faridpur.gov.bd', 'email' => 'unosaltha@mopa.gov.bd'],

            ['id' => '399', 'district_id' => '53', 'name' => 'Panchagarh Sadar', 'email' => "unopanchagarh@mopa.gov.bd", 'bn_name' => 'পঞ্চগড় সদর', 'url' => 'panchagarhsadar.panchagarh.gov.bd'],
            ['id' => '400', 'district_id' => '53', 'name' => 'Debiganj', 'email' => "unodebiganj@mopa.gov.bd", 'bn_name' => 'দেবীগঞ্জ', 'url' => 'debiganj.panchagarh.gov.bd'],
            ['id' => '401', 'district_id' => '53', 'name' => 'Boda', 'email' => "unoboda@mopa.gov.bd", 'bn_name' => 'বোদা', 'url' => 'boda.panchagarh.gov.bd'],
            ['id' => '402', 'district_id' => '53', 'name' => 'Atwari', 'email' => "unoatwari@mopa.gov.bd", 'bn_name' => 'আটোয়ারী', 'url' => 'atwari.panchagarh.gov.bd'],
            ['id' => '403', 'district_id' => '53', 'name' => 'Tetulia', 'email' => "unotetulia@mopa.gov.bd", 'bn_name' => 'তেতুলিয়া', 'url' => 'tetulia.panchagarh.gov.bd'],

            ['id' => '404', 'district_id' => '54', 'name' => 'Nawabganj', 'bn_name' => 'নবাবগঞ্জ', 'url' => 'nawabganj.dinajpur.gov.bd', 'email' => 'unonawabganjdinajpur@mopa.gov.bd'],
            ['id' => '405', 'district_id' => '54', 'name' => 'Birganj', 'bn_name' => 'বীরগঞ্জ', 'url' => 'birganj.dinajpur.gov.bd', 'email' => 'unobirganj@mopa.gov.bd'],
            ['id' => '406', 'district_id' => '54', 'name' => 'Ghoraghat', 'bn_name' => 'ঘোড়াঘাট', 'url' => 'ghoraghat.dinajpur.gov.bd', 'email' => 'unoghoraghat@mopa.gov.bd'],
            ['id' => '407', 'district_id' => '54', 'name' => 'Birampur', 'bn_name' => 'বিরামপুর', 'url' => 'birampur.dinajpur.gov.bd', 'email' => 'unobirampur@mopa.gov.bd'],
            ['id' => '408', 'district_id' => '54', 'name' => 'Parbatipur', 'bn_name' => 'পার্বতীপুর', 'url' => 'parbatipur.dinajpur.gov.bd', 'email' => 'unoparbatipur@mopa.gov.bd'],
            ['id' => '409', 'district_id' => '54', 'name' => 'Bochaganj', 'bn_name' => 'বোচাগঞ্জ', 'url' => 'bochaganj.dinajpur.gov.bd', 'email' => 'unobochaganj@mopa.gov.bd'],
            ['id' => '410', 'district_id' => '54', 'name' => 'Kaharol', 'bn_name' => 'কাহারোল', 'url' => 'kaharol.dinajpur.gov.bd', 'email' => 'unokaharole@mopa.gov.bd'],
            ['id' => '411', 'district_id' => '54', 'name' => 'Fulbari', 'bn_name' => 'ফুলবাড়ী', 'url' => 'fulbari.dinajpur.gov.bd', 'email' => 'unofulbaridinajpur@mopa.gov.bd'],
            ['id' => '412', 'district_id' => '54', 'name' => 'Dinajpur Sadar', 'bn_name' => 'দিনাজপুর সদর', 'url' => 'dinajpursadar.dinajpur.gov.bd', 'email' => 'unodinajpur@mopa.gov.bd'],
            ['id' => '413', 'district_id' => '54', 'name' => 'Hakimpur', 'bn_name' => 'হাকিমপুর', 'url' => 'hakimpur.dinajpur.gov.bd', 'email' => 'unohakimpur@mopa.gov.bd'],
            ['id' => '414', 'district_id' => '54', 'name' => 'Khansama', 'bn_name' => 'খানসামা', 'url' => 'khansama.dinajpur.gov.bd', 'email' => 'unokhansama@mopa.gov.bd'],
            ['id' => '415', 'district_id' => '54', 'name' => 'Birol', 'bn_name' => 'বিরল', 'url' => 'birol.dinajpur.gov.bd', 'email' => 'unobirol@mopa.gov.bd'],
            ['id' => '416', 'district_id' => '54', 'name' => 'Chirirbandar', 'bn_name' => 'চিরিরবন্দর', 'url' => 'chirirbandar.dinajpur.gov.bd', 'email' => 'unochirirbandar@mopa.gov.bd'],

            ['id' => '417', 'district_id' => '55', 'name' => 'Lalmonirhat Sadar', 'email' => "unolalmonirhat@mopa.gov.bd", 'bn_name' => 'লালমনিরহাট সদর', 'url' => 'sadar.lalmonirhat.gov.bd'],
            ['id' => '418', 'district_id' => '55', 'name' => 'Kaliganj', 'email' => "unokaliganjlalmonirhat@mopa.gov.bd", 'bn_name' => 'কালীগঞ্জ', 'url' => 'kaliganj.lalmonirhat.gov.bd'],
            ['id' => '419', 'district_id' => '55', 'name' => 'Hatibandha', 'email' => "unohatibandha@mopa.gov.bd", 'bn_name' => 'হাতীবান্ধা', 'url' => 'hatibandha.lalmonirhat.gov.bd'],
            ['id' => '420', 'district_id' => '55', 'name' => 'Patgram', 'email' => "unopatgram@mopa.gov.bd", 'bn_name' => 'পাটগ্রাম', 'url' => 'patgram.lalmonirhat.gov.bd'],
            ['id' => '421', 'district_id' => '55', 'name' => 'Aditmari', 'email' => "unoaditmari@mopa.gov.bd", 'bn_name' => 'আদিতমারী', 'url' => 'aditmari.lalmonirhat.gov.bd'],

            ['id' => '422', 'district_id' => '56', 'name' => 'Syedpur', 'email' => "unosyedpur@mopa.gov.bd", 'bn_name' => 'সৈয়দপুর', 'url' => 'syedpur.nilphamari.gov.bd'],
            ['id' => '423', 'district_id' => '56', 'name' => 'Domar', 'email' => "unodomar@mopa.gov.bd", 'bn_name' => 'ডোমার', 'url' => 'domar.nilphamari.gov.bd'],
            ['id' => '424', 'district_id' => '56', 'name' => 'Dimla', 'email' => "unodimla@mopa.gov.bd", 'bn_name' => 'ডিমলা', 'url' => 'dimla.nilphamari.gov.bd'],
            ['id' => '425', 'district_id' => '56', 'name' => 'Jaldhaka', 'email' => "unojaldhaka@mopa.gov.bd", 'bn_name' => 'জলঢাকা', 'url' => 'jaldhaka.nilphamari.gov.bd'],
            ['id' => '426', 'district_id' => '56', 'name' => 'Kishorganj', 'email' => "unokishoreganjnilphamari@mopa.gov.bd", 'bn_name' => 'কিশোরগঞ্জ', 'url' => 'kishorganj.nilphamari.gov.bd'],
            ['id' => '427', 'district_id' => '56', 'name' => 'Nilphamari Sadar', 'email' => "unonilphamari@mopa.gov.bd", 'bn_name' => 'নীলফামারী সদর', 'url' => 'nilphamarisadar.nilphamari.gov.bd'],

            ['id' => '428', 'district_id' => '57', 'name' => 'Sadullapur', 'email' => "unosadullapur@mopa.gov.bd", 'bn_name' => 'সাদুল্লাপুর', 'url' => 'sadullapur.gaibandha.gov.bd'],
            ['id' => '429', 'district_id' => '57', 'name' => 'Gaibandha Sadar', 'email' => "unogaibandha@mopa.gov.bd", 'bn_name' => 'গাইবান্ধা সদর', 'url' => 'gaibandhasadar.gaibandha.gov.bd'],
            ['id' => '430', 'district_id' => '57', 'name' => 'Palashbari', 'email' => "unopalashbari@mopa.gov.bd", 'bn_name' => 'পলাশবাড়ী', 'url' => 'palashbari.gaibandha.gov.bd'],
            ['id' => '431', 'district_id' => '57', 'name' => 'Saghata', 'email' => "unosaghatta@mopa.gov.bd", 'bn_name' => 'সাঘাটা', 'url' => 'saghata.gaibandha.gov.bd'],
            ['id' => '432', 'district_id' => '57', 'name' => 'Gobindaganj', 'email' => "unogobindaganj@mopa.gov.bd", 'bn_name' => 'গোবিন্দগঞ্জ', 'url' => 'gobindaganj.gaibandha.gov.bd'],
            ['id' => '433', 'district_id' => '57', 'name' => 'Sundarganj', 'email' => "unosundarganj@mopa.gov.bd", 'bn_name' => 'সুন্দরগঞ্জ', 'url' => 'sundarganj.gaibandha.gov.bd'],
            ['id' => '434', 'district_id' => '57', 'name' => 'Phulchari', 'email' => "unofulchari@mopa.gov.bd", 'bn_name' => 'ফুলছড়ি', 'url' => 'phulchari.gaibandha.gov.bd'],




            ['id' => '435', 'district_id' => '58', 'name' => 'Thakurgaon Sadar', 'email' => "unothakurgaon@mopa.gov.bd", 'bn_name' => 'ঠাকুরগাঁও সদর', 'url' => 'thakurgaonsadar.thakurgaon.gov.bd'],
            ['id' => '436', 'district_id' => '58', 'name' => 'Pirganj', 'email' => "unopirganjthakurgaon@mopa.gov.bd", 'bn_name' => 'পীরগঞ্জ', 'url' => 'pirganj.thakurgaon.gov.bd'],
            ['id' => '437', 'district_id' => '58', 'name' => 'Ranisankail', 'email' => "unoranisankail@mopa.gov.bd", 'bn_name' => 'রাণীশংকৈল', 'url' => 'ranisankail.thakurgaon.gov.bd'],
            ['id' => '438', 'district_id' => '58', 'name' => 'Haripur', 'email' => "unoharipur@mopa.gov.bd", 'bn_name' => 'হরিপুর', 'url' => 'haripur.thakurgaon.gov.bd'],
            ['id' => '439', 'district_id' => '58', 'name' => 'Baliadangi', 'email' => "unobaliadangi@mopa.gov.bd", 'bn_name' => 'বালিয়াডাঙ্গী', 'url' => 'baliadangi.thakurgaon.gov.bd'],




            ['id' => '440', 'district_id' => '59', 'name' => 'Rangpur Sadar', 'email' => "unorangpur@mopa.gov.bd", 'bn_name' => 'রংপুর সদর', 'url' => 'rangpursadar.rangpur.gov.bd'],
            ['id' => '441', 'district_id' => '59', 'name' => 'Gangachara', 'email' => "unogangachara@mopa.gov.bd", 'bn_name' => 'গংগাচড়া', 'url' => 'gangachara.rangpur.gov.bd'],
            ['id' => '442', 'district_id' => '59', 'name' => 'Taragonj', 'email' => "unotaraganj@mopa.gov.bd", 'bn_name' => 'তারাগঞ্জ', 'url' => 'taragonj.rangpur.gov.bd'],
            ['id' => '443', 'district_id' => '59', 'name' => 'Badargonj', 'email' => "unobadarganj@mopa.gov.bd", 'bn_name' => 'বদরগঞ্জ', 'url' => 'badargonj.rangpur.gov.bd'],
            ['id' => '444', 'district_id' => '59', 'name' => 'Mithapukur', 'email' => "unomithapukur@mopa.gov.bd", 'bn_name' => 'মিঠাপুকুর', 'url' => 'mithapukur.rangpur.gov.bd'],
            ['id' => '445', 'district_id' => '59', 'name' => 'Pirgonj', 'email' => "unopirganjrangpur@mopa.gov.bd", 'bn_name' => 'পীরগঞ্জ', 'url' => 'pirgonj.rangpur.gov.bd'],
            ['id' => '446', 'district_id' => '59', 'name' => 'Kaunia', 'email' => "unokaunia@mopa.gov.bd", 'bn_name' => 'কাউনিয়া', 'url' => 'kaunia.rangpur.gov.bd'],
            ['id' => '447', 'district_id' => '59', 'name' => 'Pirgacha', 'email' => "unopirgacha@mopa.gov.bd", 'bn_name' => 'পীরগাছা', 'url' => 'pirgacha.rangpur.gov.bd'],

            ['id' => '448', 'district_id' => '60', 'name' => 'Kurigram Sadar', 'bn_name' => 'কুড়িগ্রাম সদর', 'url' => 'kurigramsadar.kurigram.gov.bd', 'email' => 'unokurigram@mopa.gov.bd'],
            ['id' => '449', 'district_id' => '60', 'name' => 'Nageshwari', 'bn_name' => 'নাগেশ্বরী', 'url' => 'nageshwari.kurigram.gov.bd', 'email' => 'unonageswari@mopa.gov.bd'],
            ['id' => '450', 'district_id' => '60', 'name' => 'Bhurungamari', 'bn_name' => 'ভুরুঙ্গামারী', 'url' => 'bhurungamari.kurigram.gov.bd', 'email' => 'unobhurungamari@mopa.gov.bd'],
            ['id' => '451', 'district_id' => '60', 'name' => 'Phulbari', 'bn_name' => 'ফুলবাড়ী', 'url' => 'phulbari.kurigram.gov.bd', 'email' => 'unofulbarikurigram@mopa.gov.bd'],
            ['id' => '452', 'district_id' => '60', 'name' => 'Rajarhat', 'bn_name' => 'রাজারহাট', 'url' => 'rajarhat.kurigram.gov.bd', 'email' => 'unorajarat@mopa.gov.bd'],
            ['id' => '453', 'district_id' => '60', 'name' => 'Ulipur', 'bn_name' => 'উলিপুর', 'url' => 'ulipur.kurigram.gov.bd', 'email' => 'unoulipur@mopa.gov.bd'],
            ['id' => '454', 'district_id' => '60', 'name' => 'Chilmari', 'bn_name' => 'চিলমারী', 'url' => 'chilmari.kurigram.gov.bd', 'email' => 'unochilmari@mopa.gov.bd'],
            ['id' => '455', 'district_id' => '60', 'name' => 'Rowmari', 'bn_name' => 'রৌমারী', 'url' => 'rowmari.kurigram.gov.bd', 'email' => 'unorowmari@mopa.gov.bd'],
            ['id' => '456', 'district_id' => '60', 'name' => 'Charrajibpur', 'bn_name' => 'চর রাজিবপুর', 'url' => 'charrajibpur.kurigram.gov.bd', 'email' => 'unorajibpur@mopa.gov.bd'],

            ['id' => '457', 'district_id' => '61', 'name' => 'Sherpur Sadar', 'email' => "unosherpur@mopa.gov.bd", 'bn_name' => 'শেরপুর সদর', 'url' => 'sherpursadar.sherpur.gov.bd'],
            ['id' => '458', 'district_id' => '61', 'name' => 'Nalitabari', 'email' => "unonalitabari@mopa.gov.bd", 'bn_name' => 'নালিতাবাড়ী', 'url' => 'nalitabari.sherpur.gov.bd'],
            ['id' => '459', 'district_id' => '61', 'name' => 'Sreebordi', 'email' => "unosreebardi@mopa.gov.bd", 'bn_name' => 'শ্রীবরদী', 'url' => 'sreebordi.sherpur.gov.bd'],
            ['id' => '460', 'district_id' => '61', 'name' => 'Nokla', 'email' => "unonakhla@mopa.gov.bd", 'bn_name' => 'নকলা', 'url' => 'nokla.sherpur.gov.bd'],
            ['id' => '461', 'district_id' => '61', 'name' => 'Jhenaigati', 'email' => "unojhenaigati@mopa.gov.bd", 'bn_name' => 'ঝিনাইগাতী', 'url' => 'jhenaigati.sherpur.gov.bd'],

            ['id' => '462', 'district_id' => '62', 'name' => 'Fulbaria', 'email' => "unofulbaria@mopa.gov.bd", 'bn_name' => 'ফুলবাড়ীয়া', 'url' => 'fulbaria.mymensingh.gov.bd'],
            ['id' => '463', 'district_id' => '62', 'name' => 'Trishal', 'email' => "unotrishal@mopa.gov.bd", 'bn_name' => 'ত্রিশাল', 'url' => 'trishal.mymensingh.gov.bd'],
            ['id' => '464', 'district_id' => '62', 'name' => 'Bhaluka', 'email' => "unobhaluka@mopa.gov.bd", 'bn_name' => 'ভালুকা', 'url' => 'bhaluka.mymensingh.gov.bd'],
            ['id' => '465', 'district_id' => '62', 'name' => 'Muktagacha', 'email' => "unomuktagacha@mopa.gov.bd", 'bn_name' => 'মুক্তাগাছা', 'url' => 'muktagacha.mymensingh.gov.bd'],
            ['id' => '466', 'district_id' => '62', 'name' => 'Mymensingh Sadar', 'email' => "unomymensingh@mopa.gov.bd", 'bn_name' => 'ময়মনসিংহ সদর', 'url' => 'mymensinghsadar.mymensingh.gov.bd'],
            ['id' => '467', 'district_id' => '62', 'name' => 'Dhobaura', 'email' => "unodhobaura@mopa.gov.bd", 'bn_name' => 'ধোবাউড়া', 'url' => 'dhobaura.mymensingh.gov.bd'],
            ['id' => '468', 'district_id' => '62', 'name' => 'Phulpur', 'email' => "unofulpur@mopa.gov.bd", 'bn_name' => 'ফুলপুর', 'url' => 'phulpur.mymensingh.gov.bd'],
            ['id' => '469', 'district_id' => '62', 'name' => 'Haluaghat', 'email' => "unohaluaghat@mopa.gov.bd", 'bn_name' => 'হালুয়াঘাট', 'url' => 'haluaghat.mymensingh.gov.bd'],
            ['id' => '470', 'district_id' => '62', 'name' => 'Gouripur', 'email' => "unogouripur@mopa.gov.bd", 'bn_name' => 'গৌরীপুর', 'url' => 'gouripur.mymensingh.gov.bd'],
            ['id' => '471', 'district_id' => '62', 'name' => 'Gafargaon', 'email' => "unogaffargaon@mopa.gov.bd", 'bn_name' => 'গফরগাঁও', 'url' => 'gafargaon.mymensingh.gov.bd'],
            ['id' => '472', 'district_id' => '62', 'name' => 'Iswarganj', 'email' => "unoiswarganj@mopa.gov.bd", 'bn_name' => 'ঈশ্বরগঞ্জ', 'url' => 'iswarganj.mymensingh.gov.bd'],
            ['id' => '473', 'district_id' => '62', 'name' => 'Nandail', 'email' => "unonandail@mopa.gov.bd", 'bn_name' => 'নান্দাইল', 'url' => 'nandail.mymensingh.gov.bd'],
            ['id' => '474', 'district_id' => '62', 'name' => 'Tarakanda', 'email' => "unotarakanda@mopa.gov.bd", 'bn_name' => 'তারাকান্দা', 'url' => 'tarakanda.mymensingh.gov.bd'],

            ['id' => '475', 'district_id' => '63', 'name' => 'Jamalpur Sadar', 'bn_name' => 'জামালপুর সদর', 'url' => 'jamalpursadar.jamalpur.gov.bd', 'email' => 'unojamalpur@mopa.gov.bd'],
            ['id' => '476', 'district_id' => '63', 'name' => 'Melandah', 'bn_name' => 'মেলান্দহ', 'url' => 'melandah.jamalpur.gov.bd', 'email' => 'unomelandah@mopa.gov.bd'],
            ['id' => '477', 'district_id' => '63', 'name' => 'Islampur', 'bn_name' => 'ইসলামপুর', 'url' => 'islampur.jamalpur.gov.bd', 'email' => 'unoislampur@mopa.gov.bd'],
            ['id' => '478', 'district_id' => '63', 'name' => 'Dewangonj', 'bn_name' => 'দেওয়ানগঞ্জ', 'url' => 'dewangonj.jamalpur.gov.bd', 'email' => 'unodewanganj@mopa.gov.bd'],
            ['id' => '479', 'district_id' => '63', 'name' => 'Sarishabari', 'bn_name' => 'সরিষাবাড়ী', 'url' => 'sarishabari.jamalpur.gov.bd', 'email' => 'unosarishabari@mopa.gov.bd'],
            ['id' => '480', 'district_id' => '63', 'name' => 'Madarganj', 'bn_name' => 'মাদারগঞ্জ', 'url' => 'madarganj.jamalpur.gov.bd', 'email' => 'unomadarganj@mopa.gov.bd'],
            ['id' => '481', 'district_id' => '63', 'name' => 'Bokshiganj', 'bn_name' => 'বকশীগঞ্জ', 'url' => 'bokshiganj.jamalpur.gov.bd', 'email' => 'unobakshiganj@mopa.gov.bd'],

            ['id' => '482', 'district_id' => '64', 'name' => 'Barhatta', 'email' => "unobarhatta@mopa.gov.bd", 'bn_name' => 'বারহাট্টা', 'url' => 'barhatta.netrokona.gov.bd'],
            ['id' => '483', 'district_id' => '64', 'name' => 'Durgapur', 'email' => "", 'bn_name' => 'দুর্গাপুর', 'url' => 'durgapur.netrokona.gov.bd'],
            ['id' => '484', 'district_id' => '64', 'name' => 'Kendua', 'email' => "unokendua@mopa.gov.bd", 'bn_name' => 'কেন্দুয়া', 'url' => 'kendua.netrokona.gov.bd'],
            ['id' => '485', 'district_id' => '64', 'name' => 'Atpara', 'email' => "", 'bn_name' => 'আটপাড়া', 'url' => 'atpara.netrokona.gov.bd'],
            ['id' => '486', 'district_id' => '64', 'name' => 'Madan', 'email' => "unomadan@mopa.gov.bd", 'bn_name' => 'মদন', 'url' => 'madan.netrokona.gov.bd'],
            ['id' => '487', 'district_id' => '64', 'name' => 'Khaliajuri', 'email' => "unokhaliajuri@mopa.gov.bd", 'bn_name' => 'খালিয়াজুরী', 'url' => 'khaliajuri.netrokona.gov.bd'],
            ['id' => '488', 'district_id' => '64', 'name' => 'Kalmakanda', 'email' => "unokalmakanda@mopa.gov.bd", 'bn_name' => 'কলমাকান্দা', 'url' => 'kalmakanda.netrokona.gov.bd'],
            ['id' => '489', 'district_id' => '64', 'name' => 'Mohongonj', 'email' => "unomohanganj@mopa.gov.bd", 'bn_name' => 'মোহনগঞ্জ', 'url' => 'mohongonj.netrokona.gov.bd'],
            ['id' => '490', 'district_id' => '64', 'name' => 'Purbadhala', 'email' => "unopurbadhala@mopa.gov.bd", 'bn_name' => 'পূর্বধলা', 'url' => 'purbadhala.netrokona.gov.bd'],
            ['id' => '491', 'district_id' => '64', 'name' => 'Netrokona Sadar', 'email' => "unonetrokona@mopa.gov.bd", 'bn_name' => 'নেত্রকোণা সদর', 'url' => 'netrokonasadar.netrokona.gov.bd'],

            ['id' => '492', 'district_id' => '65', 'name' => 'Adabar Thana', 'bn_name' => 'আদাবর থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['id' => '493', 'district_id' => '65', 'name' => 'Azampur Thana', 'bn_name' => 'আজমপুর থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['id' => '494', 'district_id' => '65', 'name' => 'Badda Thana', 'bn_name' => 'বাড্ডা থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['id' => '495', 'district_id' => '65', 'name' => 'Bangsal Thana', 'bn_name' => 'বংশাল থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['id' => '496', 'district_id' => '65', 'name' => 'Bimanbandar Thana (Dhaka]', 'bn_name' => 'বিমানবন্দর থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['id' => '497', 'district_id' => '65', 'name' => 'Cantonment Thana', 'bn_name' => 'ক্যান্টনমেন্ট থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['id' => '498', 'district_id' => '65', 'name' => 'Chowkbazar Thana', 'bn_name' => 'চকবাজার থানা ', 'url' => 'debidwar.comilla.gov.bd'],
            ['id' => '499', 'district_id' => '65', 'name' => 'Darus Salam Thana', 'bn_name' => 'দারুস সালাম থানা ', 'url' => 'debidwar.comilla.gov.bd'],
            ['id' => '500', 'district_id' => '65', 'name' => 'Demra Thana', 'bn_name' => 'ডেমরা থানা ', 'url' => 'debidwar.comilla.gov.bd'],
            ['id' => '501', 'district_id' => '65', 'name' => 'Dhanmondi Thana', 'bn_name' => 'ধানমন্ডি থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['id' => '502', 'district_id' => '65', 'name' => 'Gendaria Thana', 'bn_name' => 'গেন্ডারিয়া থানা ', 'url' => 'debidwar.comilla.gov.bd'],
            ['id' => '503', 'district_id' => '65', 'name' => 'Hazaribagh Thana', 'bn_name' => 'হাজারিবাঘ থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['id' => '504', 'district_id' => '65', 'name' => 'Kadamtali Thana', 'bn_name' => 'কদমতলি থানা ', 'url' => 'debidwar.comilla.gov.bd'],
            ['id' => '505', 'district_id' => '65', 'name' => 'Kafrul Thana', 'bn_name' => 'কাফরুল থানা ', 'url' => 'debidwar.comilla.gov.bd'],
            ['id' => '506', 'district_id' => '65', 'name' => 'Kalabagan Thana', 'bn_name' => 'কলাবাগান থানা ', 'url' => 'debidwar.comilla.gov.bd'],
            ['id' => '507', 'district_id' => '65', 'name' => 'Kamrangirchar Thana', 'bn_name' => 'কামরাংগিচর থানা ', 'url' => 'debidwar.comilla.gov.bd'],
            ['id' => '508', 'district_id' => '65', 'name' => 'Khilgaon Thana', 'bn_name' => 'খিলগাঁ থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['id' => '509', 'district_id' => '65', 'name' => 'Khilkhet Thana', 'bn_name' => 'খিলখেত থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['id' => '510', 'district_id' => '65', 'name' => 'Kotwali Thana (Dhaka]', 'bn_name' => 'কতোয়াখালি থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['id' => '511', 'district_id' => '65', 'name' => 'Lalbagh Thana', 'bn_name' => 'লালবাঘ থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['id' => '512', 'district_id' => '65', 'name' => 'Mirpur Model Thana', 'bn_name' => 'মিরপুর থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['id' => '513', 'district_id' => '65', 'name' => 'Mohammadpur Thana', 'bn_name' => 'মুহাম্মাদপুর থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['id' => '514', 'district_id' => '65', 'name' => 'Motijheel Thana', 'bn_name' => 'মতিঝিল থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['id' => '515', 'district_id' => '65', 'name' => 'New Market Thana', 'bn_name' => 'নিউ মার্কেট থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['id' => '516', 'district_id' => '65', 'name' => 'Pallabi Thana', 'bn_name' => 'পল্লবি থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['id' => '517', 'district_id' => '65', 'name' => 'Paltan Thana', 'bn_name' => 'পল্টন থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['id' => '518', 'district_id' => '65', 'name' => 'Panthapath Thana', 'bn_name' => 'পান্থপথ থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['id' => '519', 'district_id' => '65', 'name' => 'Ramna Thana', 'bn_name' => 'রমনা থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['id' => '520', 'district_id' => '65', 'name' => 'Rampura Thana', 'bn_name' => 'রামপুরা থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['id' => '521', 'district_id' => '65', 'name' => 'Sabujbagh Thana', 'bn_name' => 'সবুজবাঘ থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['id' => '522', 'district_id' => '65', 'name' => 'Shah Ali Thana', 'bn_name' => 'সাহ্‌ আলী থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['id' => '523', 'district_id' => '65', 'name' => 'Shahbag Thana', 'bn_name' => 'শাহ্‌বাগ থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['id' => '524', 'district_id' => '65', 'name' => 'Sher-e-Bangla Nagar', 'bn_name' => 'শেরে-ই-বাংলা নগর থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['id' => '525', 'district_id' => '65', 'name' => 'Shyampur Thana', 'bn_name' => 'শ্যামপুর থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['id' => '526', 'district_id' => '65', 'name' => 'Sutrapur Thana', 'bn_name' => 'সুত্রাপুর থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['id' => '527', 'district_id' => '65', 'name' => 'Tejgaon Industrial Area Thana', 'bn_name' => 'তেজগাঁও ইন্ডাস্ট্রিয়াল থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['id' => '528', 'district_id' => '65', 'name' => 'Tejgaon Thana', 'bn_name' => 'তেজগাঁও থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['id' => '529', 'district_id' => '65', 'name' => 'Turag Thana', 'bn_name' => 'তুরাগ থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['id' => '530', 'district_id' => '65', 'name' => 'Uttar Khan Thana', 'bn_name' => 'উত্তর খান থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['id' => '531', 'district_id' => '65', 'name' => 'Uttara West Thana', 'bn_name' => 'উত্তরা পশ্চিম থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['id' => '532', 'district_id' => '65', 'name' => 'Vatara Thana', 'bn_name' => 'ভাটারা থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['id' => '533', 'district_id' => '65', 'name' => 'Wari Thana', 'bn_name' => 'ওয়ারি থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['id' => '534', 'district_id' => '65', 'name' => 'Uttara East Thana', 'bn_name' => 'উত্তরা পূর্ব থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['id' => '535', 'district_id' => '65', 'name' => 'Dakshinkhan Thana', 'bn_name' => 'দক্ষিনখান থানা', 'url' => 'debidwar.comilla.gov.bd'],

            ['id' => '536', 'district_id' => '66', 'name' => 'Akbarshah Thana', 'bn_name' => 'আকবরশাহ থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['id' => '537', 'district_id' => '66', 'name' => 'Bakoliya Thana', 'bn_name' => 'বাকোলিয়া থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['id' => '538', 'district_id' => '66', 'name' => 'Bandar Thana', 'bn_name' => 'বন্দর থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['id' => '539', 'district_id' => '66', 'name' => 'Bayazid Thana', 'bn_name' => 'বায়জিদ থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['id' => '540', 'district_id' => '66', 'name' => 'Bhujpur Thana', 'bn_name' => 'ভুজপুর থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['id' => '541', 'district_id' => '66', 'name' => 'Chandgaon Thana', 'bn_name' => 'চন্দগন থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['id' => '542', 'district_id' => '66', 'name' => 'Chaowkbazar Thana', 'bn_name' => 'চকবাজার থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['id' => '543', 'district_id' => '66', 'name' => 'Chittagong Kotwali Thana', 'bn_name' => 'চিটাগাং থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['id' => '544', 'district_id' => '66', 'name' => 'Double Mooring Thana', 'bn_name' => 'ডাবল মর্নিং থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['id' => '545', 'district_id' => '66', 'name' => 'EPZ Thana Thana', 'bn_name' => 'ইপিজেড থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['id' => '546', 'district_id' => '66', 'name' => 'Halishahar Thana', 'bn_name' => 'হালিশাহার থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['id' => '547', 'district_id' => '66', 'name' => 'Karnaphuli Thana', 'bn_name' => 'কর্ণফুলি থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['id' => '548', 'district_id' => '66', 'name' => 'Khulshi Thana', 'bn_name' => 'খুলসি থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['id' => '549', 'district_id' => '66', 'name' => 'Kotwali Thana (Chittagong]', 'bn_name' => 'কতোয়াখালি থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['id' => '550', 'district_id' => '66', 'name' => 'Pahartali Thana', 'bn_name' => 'পাহারতলি থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['id' => '551', 'district_id' => '66', 'name' => 'Panchlaish Thana', 'bn_name' => 'পাঞ্চলাইস থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['id' => '552', 'district_id' => '66', 'name' => 'Patenga Thana', 'bn_name' => 'পতেংগা থানা', 'url' => 'debidwar.comilla.gov.bd'],

            ['id' => '553', 'district_id' => '65', 'name' => 'Gulshan Thana', 'bn_name' => 'গুলশান থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['id' => '554', 'district_id' => '65', 'name' => 'Banani Thana', 'bn_name' => 'বনানী থানা', 'url' => 'debidwar.comilla.gov.bd'],

            ['id' => '555', 'district_id' => '72', 'name' => 'Sadar Thana', 'bn_name' => 'সদর/জয়দেবপুর থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['id' => '556', 'district_id' => '72', 'name' => 'Bason Thana', 'bn_name' => 'বাসন থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['id' => '557', 'district_id' => '72', 'name' => 'Konabari Thana', 'bn_name' => 'কোনাবাড়ী থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['id' => '558', 'district_id' => '72', 'name' => 'Kashimpur Thana', 'bn_name' => 'কাশিমপুর থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['id' => '559', 'district_id' => '72', 'name' => 'Gacha Thana', 'bn_name' => 'গাছা থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['id' => '560', 'district_id' => '72', 'name' => 'Pubail Thana', 'bn_name' => 'পূবাইল থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['id' => '561', 'district_id' => '72', 'name' => 'Tongi West Thana', 'bn_name' => 'টঙ্গী পশ্চিম থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['id' => '562', 'district_id' => '72', 'name' => 'Tongi East Thana', 'bn_name' => 'টঙ্গী পূর্ব থানা', 'url' => 'debidwar.comilla.gov.bd'],
        ];
        foreach ($thanas as $thana) {
            Upozila::create($thana);
        }
    }
}