<?php

namespace Database\Seeders;

use App\Models\Division;
use Illuminate\Database\Seeder;

class DivisionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $data = [
            ['id' => 1, 'bn_name' => 'চট্টগ্রাম', 'name' => 'Chattogram'],
            ['id' => 2, 'bn_name' => 'রাজশাহী', 'name' => 'Rajshahi'],
            ['id' => 3, 'bn_name' => 'খুলনা', 'name' => 'Khulna'],
            ['id' => 4, 'bn_name' => 'বরিশাল', 'name' => 'Barishal'],
            ['id' => 5, 'bn_name' => 'সিলেট', 'name' => 'Sylhet'],
            ['id' => 6, 'bn_name' => 'ঢাকা', 'name' => 'Dhaka'],
            ['id' => 7, 'bn_name' => 'রংপুর', 'name' => 'Rangpur'],
            ['id' => 8, 'bn_name' => 'ময়মনসিংহ', 'name' => 'Mymensingh'],
        ];

        foreach ($data as $division) {
            Division::create($division);
        }
    }
}
