<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Faker\Factory as Faker;

class ApplyFormTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $faker = Faker::create();

        for ($i = 0; $i < 30; $i++) {
            DB::table('apply_forms')->insert([
                'division_id' => $faker->randomDigitNotNull(),
                'district_id' => $faker->randomDigitNotNull(),
                'upozila_id' => $faker->randomDigitNotNull(),
                'reference_number' => $faker->uuid(),
                'otp' => $faker->randomNumber(5, true),
                'otp_verified' => $faker->randomElement(['verified']),
                'status' => $faker->randomElement([1]),
                'take_count' => $faker->numberBetween(1),
                'fail_count' => $faker->numberBetween(1),
                'victim_name' => $faker->name(),
                'sick_short_details' => $faker->sentence(),
                'relation' => $faker->word(),
                'father_husband_name' => $faker->name(),
                'mother_name' => $faker->name(),
                'applicant_name' => $faker->name(),
                'relation_with_deceased' => $faker->word(),
                'victim_birthdate' => $faker->date(),
                'national_id' => $faker->numerify('#############'),
                'phone' => $faker->phoneNumber(),
                'driving_license' => $faker->optional()->numerify('DL######'),
                'address' => $faker->address(),
                'accident_description' => $faker->text(),
                'accident_date_time' => $faker->date(),
                'case_dd_number' => $faker->numerify('DD######'),
                'death_date' => $faker->optional()->date(),
                'total_expense' => $faker->randomFloat(2, 1000, 50000),
                'current_address' => $faker->address(),
                'fund_aid' => $faker->word(),
                // 'gd_stamp' => $faker->word(),
                // 'medical_certificate' => $faker->word(),
                // 'death_certificate' => $faker->optional()->word(),
                // 'victim_driving_license' => $faker->optional()->numerify('DL######'),
                'warish_sonod' => $faker->optional()->word(),
                // 'victim_birth_certificate' => $faker->optional()->word(),
                // 'applicant_nid' => $faker->numerify('#############'),
                'applicant_birth_certificate' => $faker->optional()->word(),
                'victim_nid' => $faker->numerify('#############'),
                'non_judicial_stamp' => $faker->optional()->word(),
                // 'applicant_signature' => $faker->optional()->word(),
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }
    }
}
