<?php

namespace Database\Seeders;

use App\Enum\UserType;
use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

class AdminSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    private $permissions = [
        'role-list',
        'role-create',
        'role-edit',
        'role-delete',

        'user-list',
        'user-create',
        'user-edit',
        'user-delete',

    ];

    public function run(): void
    {
        // Create roles
        $roles = ['admin', 'uno', 'user', 'dc', 'district', 'apply'];
        $roleInstances = [];

        foreach ($roles as $roleName) {
            $roleInstances[$roleName] = Role::create(['name' => $roleName]);
        }

        // Create permissions
        foreach ($this->permissions as $permission) {
            Permission::create(['name' => $permission]);
        }

        // Create admin user and assign the role to him.
        $adminUser = User::create([
            'name' => 'Mr Administrator',
            'phone' => '01774272649',
            'email' => 'admin@gmail.com',
            'uno_type' => 'admin',
            'password' => Hash::make('123456'),
            'role_id' => UserType::ADMIN,
        ]);

        $dcUser = User::create([
            'name' => 'Bogra District (DC)',
            'phone' => '01774274649',
            'email' => 'dc@gmail.com',
            'password' => Hash::make('123456'),
            'role_id' => UserType::DC,
        ]);


        // Get all permission IDs
        $permissions = Permission::pluck('id')->all();

        // Assign all permissions to the 'admin' role
        $adminRole = $roleInstances['admin'];
        $adminRole = $roleInstances['dc'];
        $adminRole->syncPermissions($permissions);

        // Assign the 'admin' role to the admin user
        $adminUser->assignRole($adminRole);
        $dcUser->assignRole($adminRole);
    }
}
