<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('uno_infos', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('division_id');   
            $table->foreign('division_id')->references('id')->on('divisions')->onDelete('cascade')->onUpdate('cascade');

            $table->string('name');
            $table->string('email')->nullable();
            $table->string('phone', 20)->nullable(); 
            $table->string('mobile', 20)->nullable(); 
            $table->string('designation')->nullable();
            $table->string('address')->nullable();
            $table->string('image')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('uno_infos');
    }
};
