<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('apply_forms', function (Blueprint $table) {
            $table->id();
            $table->string('reference_number')->nullable();
            $table->string('otp')->nullable();
             $table->string('otp_verified')->comment('verified, unverified');
            $table->integer('status')->comment("1->active, 2->block, 0->pending");
            $table->integer('take_count')->nullable();
            $table->integer('fail_count')->nullable();
            $table->string('victim_name')->nullable();
            $table->string('father_husband_name')->nullable();
            $table->string('mother_name')->nullable();
            $table->string('applicant_name')->nullable();
            $table->string('relation_with_deceased')->nullable();
            $table->date('victim_birthdate')->nullable();
            $table->string('national_id')->nullable();
            $table->string('phone')->unique()->nullable();
            $table->string('driving_license')->nullable();
            $table->string('address')->nullable();
            $table->text('accident_description')->nullable();
            $table->date('accident_date_time')->nullable();
            $table->string('case_dd_number')->nullable();
            $table->date('death_date')->nullable();
            $table->decimal('total_expense', 10, 2)->nullable();
            $table->string('current_address')->nullable();
            $table->string('fund_aid')->nullable();
            $table->string('medical_certificate');
            $table->string('death_certificate')->nullable();
            $table->string('victim_driving_license')->nullable();
            $table->string('warish_sonod')->nullable();
            $table->string('victim_birth_certificate')->nullable();
            $table->string('applicant_nid')->nullable();
            $table->string('applicant_birth_certificate')->nullable();
            $table->string('victim_nid')->nullable();
            $table->string('non_judicial_stamp')->nullable();
            $table->string('applicant_signature')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('apply_forms');
    }
};