<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class ApplicationMail extends Mailable
{
    use Queueable, SerializesModels;

    public $details;

    /**
     * Create a new message instance.
     */
    public function __construct($details)
    {
        $this->details = $details;

    }

    public function build()
    {
        // Start building the email with subject and view
        $email = $this->subject('Mail from BRTA')
            ->view('mail.application-mail')
            ->with('details', $this->details);

// Check if there are files to attach
        $attachments = [];

        if (!empty($this->details?->medical_certificate)) {
            $attachments[] = public_path('application/' . $this->details->medical_certificate);
        }

        if (!empty($this->details?->death_certificate)) {
            $attachments[] = public_path('application/' . $this->details->death_certificate);
        }

        if (!empty($this->details?->victim_driving_license)) {
            $attachments[] = public_path('application/' . $this->details->victim_driving_license);
        }

        if (!empty($this->details?->victim_birth_certificate)) {
            $attachments[] = public_path('application/' . $this->details->victim_birth_certificate);
        }

        if (!empty($this->details?->applicant_nid)) {
            $attachments[] = public_path('application/' . $this->details->applicant_nid);
        }

        if (!empty($this->details?->applicant_signature)) {
            $attachments[] = public_path('application/' . $this->details->applicant_signature);
        }

        if (!empty($this->details?->gd_stamp)) {
            $attachments[] = public_path('application/' . $this->details->gd_stamp);
        }

        foreach ($attachments as $filePath) {
            if (file_exists($filePath)) {
                $email->attach($filePath);
            }
        }

        return $email;

    }

}
