<?php

namespace App\Http\Controllers;

use App\Enum\EnoType;
use App\Enum\UserType;
use App\Models\District;
use App\Models\Division;
use App\Models\Upozila;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class UserController extends Controller
{
    public function division()
    {
        if (Auth::user()->role_id != UserType::ADMIN) {
            abort(404);
        }

        $users = User::with('division')->where('uno_type', EnoType::DIVISIONUNO)->latest()->get();

        return view('backEnd.userManage.division', compact('users'));
    }
    public function district()
    {
        if (Auth::user()->role_id != UserType::ADMIN) {
            abort(404);
        }

        $users = User::with('district')->where('uno_type', EnoType::DISTRICT)->latest()->get();

        return view('backEnd.userManage.district', compact('users'));
    }

    public function upozila()
    {
        if (Auth::user()->role_id != UserType::ADMIN) {
            abort(404);
        }

        $users = User::select('id', 'name', 'email','upozila_id')->where('uno_type', EnoType::UPOZILAUNO)->latest()->get();

        return view('backEnd.userManage.index', compact('users'));
    }

    public function create()
    {
        $upozila = Upozila::select('id', 'name')->get();
        $division = Division::select('id', 'name')->get();

        return view('backEnd.userManage.create', compact('upozila', 'division'));
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'name' => 'required',
            'email' => 'required|unique:users,email,',
            'phone' => 'required',
            'upozila_id' => 'nullable|exists:upozilas,id',
            'password' => 'required|string',
            'division_id' => 'nullable|exists:divisions,id',
        ]);

        $validated['role_id'] = UserType::USER;

        if (url()->previous() == url('division-user/create')) {
            $validated['uno_type'] = EnoType::DIVISIONUNO;
        } else {
            $validated['uno_type'] = EnoType::UPOZILAUNO;
        }

        $user = User::create($validated);

        if ($user->uno_type == EnoType::DIVISIONUNO) {
            return redirect()->route('admin-user.division')->withSuccess('division user created sucees');
        } else {
            return redirect()->route('admin-user.upozila')->withSuccess('division user created sucees');
        }
    }

    public function edit($id)
    {
        $user = User::findOrFail($id);
        $upozila = Upozila::select('id', 'name')->get();
        $division = Division::select('id', 'name')->get();
        $district = District::select('id', 'name')->get();

        return view('backEnd.userManage.edit', compact('user', 'upozila', 'division', 'district'));
    }

    public function update(Request $request, $id)
    {
        $user = User::findOrFail($id);

        $validated = $request->validate([
            'name' => 'required',
            'email' => 'required|unique:users,email,' . $user->id,
            'phone' => 'required',
            'upozila_id' => 'nullable|exists:upozilas,id',
            'division_id' => 'nullable|exists:divisions,id',
        ]);

        $user->update($validated);

        if ($user->uno_type == EnoType::DIVISIONUNO) {
            return redirect()->route('admin-user.division')->withSuccess('user updated sucees');
        } else {
            return redirect()->route('admin-user.upozila')->withSuccess('user updated sucees');
        }

    }
}
