<?php

namespace App\Http\Controllers\User;

use App\Models\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

class UserLoginController extends Controller
{
    public function login(Request $request)
    {
        // Validate the input
        $request->validate([
            'phone' => 'required|string',
            'password' => 'required|string',
        ]);

        // Find users with the matching phone number
        $users = User::where('phone', $request->phone)->get();

        // Check if any of these users have a matching password
        $user = $users->first(function ($user) use ($request) {
            return Hash::check($request->password, $user->password);
        });

        // If no user is found with matching phone and password
        if (!$user) {
            return redirect()->back()->withError('Credentials do not match our records.');
         
        }

        // Log in the user
        Auth::login($user);

        // Return a success response
        return redirect()->route('admin.dashboard');
    }
}
