<?php

namespace App\Http\Controllers\User;

use App\Models\ApplyForm;
use Illuminate\Http\Request;
use Mccarlosen\LaravelMpdf\Facades\LaravelMpdf as PDF;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Cache;

class ApplicationController_old extends Controller
{
    public function index()
    {
        $appId = Cache::get('app_id');

        $application = ApplyForm::where('id', $appId)->first();
        if (!$application) {
            return redirect()->route('home')->with('error', 'Application not found.');
        }
        return view('user.applications.index');
    }

    public function applyNow()
    {
        return view('user.applications.apply_now');
    }

    public function create()
    {
        return view('user.applications.index');
    }

    public function store(Request $request)
    {
        $validatedData = $request->validate([
            'victim_name' => 'required|string|max:255',
            'father_husband_name' => 'required|string|max:255',
            'mother_name' => 'required|string|max:255',
            'applicant_name' => 'required|string|max:255',
            'relation_with_deceased' => 'required|string|max:255',
            'victim_birthdate' => 'required|date',
            'national_id' => 'required|string|max:20',
            'driving_license' => 'nullable|string|max:255',
            'address' => 'required|string|max:500',
            'accident_description' => 'required|string',
            'accident_date_time' => 'required|date',
            'case_dd_number' => 'required|string|max:50',
            'death_date' => 'required|date',
            'total_expense' => 'required|numeric',
            'current_address' => 'required|string|max:500',
            'fund_aid' => 'required|string|max:255',
            'medical_certificate' => 'required|file|mimes:jpg,jpeg,png,pdf',
            'death_certificate' => 'required|file|mimes:jpg,jpeg,png,pdf',
            'victim_driving_license' => 'nullable|file|mimes:jpg,jpeg,png,pdf',
            'warish_sonod' => 'required|file|mimes:jpg,jpeg,png,pdf',
            'victim_birth_certificate' => 'required|file|mimes:jpg,jpeg,png,pdf',
            'applicant_nid' => 'required|file|mimes:jpg,jpeg,png,pdf',
            'applicant_birth_certificate' => 'required|file|mimes:jpg,jpeg,png,pdf',
            'victim_nid' => 'required|file|mimes:jpg,jpeg,png,pdf',
            'non_judicial_stamp' => 'required|file|mimes:jpg,jpeg,png,pdf',
            'applicant_signature' => 'required|file|mimes:jpg,jpeg,png,pdf',
        ]);

        DB::beginTransaction();

        try {
            $appId = Cache::get('app_id');

            $application = ApplyForm::where('id', $appId)->first();
            $data = $request->except('_token', 'phone');

            // Upload Files and Save Paths
            if ($request->hasFile('medical_certificate')) {
                $data['medical_certificate'] = $request->file('medical_certificate')->store('uploads', 'public');
            }

            if ($request->hasFile('death_certificate')) {
                $data['death_certificate'] = $request->file('death_certificate')->store('uploads', 'public');
            }

            if ($request->hasFile('victim_driving_license')) {
                $data['victim_driving_license'] = $request->file('victim_driving_license')->store('uploads', 'public');
            }

            if ($request->hasFile('warish_sonod')) {
                $data['warish_sonod'] = $request->file('warish_sonod')->store('uploads', 'public');
            }

            if ($request->hasFile('victim_birth_certificate')) {
                $data['victim_birth_certificate'] = $request->file('victim_birth_certificate')->store('uploads', 'public');
            }

            if ($request->hasFile('applicant_nid')) {
                $data['applicant_nid'] = $request->file('applicant_nid')->store('uploads', 'public');
            }

            if ($request->hasFile('applicant_birth_certificate')) {
                $data['applicant_birth_certificate'] = $request->file('applicant_birth_certificate')->store('uploads', 'public');
            }

            if ($request->hasFile('victim_nid')) {
                $data['victim_nid'] = $request->file('victim_nid')->store('uploads', 'public');
            }

            if ($request->hasFile('non_judicial_stamp')) {
                $data['non_judicial_stamp'] = $request->file('non_judicial_stamp')->store('uploads', 'public');
            }

            if ($request->hasFile('applicant_signature')) {
                $data['applicant_signature'] = $request->file('applicant_signature')->store('uploads', 'public');
            }

            $update = $application->update($data);

            DB::commit();

            $message = 'Your application reference number ' . $application->reference_number;

            $response = send_sms($application->phone, $message);

            return redirect()->route('download-application-pdf');

        } catch (\Exception $e) {
            DB::rollback();
            return redirect()->route('home')->with('error', $e->getMessage());
        }
    }

    public function downloadApplicationPdf()
    {
        // Retrieve application ID from cache
        $appId = Cache::get('app_id');
        $application = ApplyForm::where('id', $appId)->first();
        if ($application) {
            $data = ['invoice' => $application];
            $pdf = PDF::loadView('pdf-view', $data);
            $filePath = storage_path('app/public/' . $application->reference_number . '.pdf');
            $pdf->save($filePath);
            return view('thankyou', ['filename' => $application->reference_number . '.pdf']);
        }

        // If no application found, return 404
        abort(404);
    }

    public function servePdf($filename)
    {
        $filePath = storage_path('app/public/' . $filename);

        if (file_exists($filePath)) {
            return response()->download($filePath)->deleteFileAfterSend(true);
        }

        return response()->json(['error' => 'File not found'], 404);
    }
}