<?php

namespace App\Http\Controllers;

use App\Models\OrderOffice;
use Illuminate\Http\Request;

class OfficeOrderController extends Controller
{
    public function index()
    {
        $orders = OrderOffice::officeOrder()->latest()->get();

        return view('backEnd.officeOrder.index', compact('orders'));
    }

    public function create()
    {
        return view('backEnd.officeOrder.create');
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'title' => 'required|string|max:255',
            'download' => 'required|url',
            'explain' => 'required|string|max:255',
        ]);

        $validated['type'] = 'office_order';

        OrderOffice::create($validated);

        return redirect()->route('office-orders.index')->withSuccess('order added successfully.');
    }

    public function edit( $id)
    {
         $orderOffice = OrderOffice::findOrFail($id);

        return view('backEnd.officeOrder.edit', compact('orderOffice'));
    }

    public function update(Request $request, $id)
    {
        $validated = $request->validate([
            'title' => 'required|string|max:255',
            'download' => 'required|url',
            'explain' => 'required|string|max:255',
        ]);

        $orderOffice = OrderOffice::findOrFail($id);

        $orderOffice->update($validated);

        return redirect()->route('office-orders.index')->withSuccess('order updated successfully.');
    }

    public function destroy($id)
    {
        $orderOffice = OrderOffice::findOrFail($id);
        $orderOffice->delete();

        return redirect()->back()->withSuccess('office order deleted successfully.');
    }

}
