<?php

namespace App\Http\Controllers;

use App\Models\OrderOffice;
use Illuminate\Http\Request;

class FormController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $forms = OrderOffice::form()->latest()->get();

        return view('backEnd.officeForm.index', compact('forms'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('backEnd.officeForm.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $validated = $request->validate([
            'form_no' => 'required|string|max:255',
            'title' => 'required|string|max:255',
            'download' => 'required|url', 
            'explain' => 'required|string|max:255',
        ]);

        $validated['type'] = 'form';

        OrderOffice::create($validated);

        return redirect()->route('office-forms.index')->withSuccess( 'order added successfully.');
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id)
    {
        $orderOffice= OrderOffice::findOrFail($id);
        
        return view('backEnd.officeForm.edit', compact('orderOffice'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request,  $id)
    {
        $validated = $request->validate([
            'form_no' => 'required|string|max:255',
            'title' => 'required|string|max:255',
            'download' => 'required|url', 
            'explain' => 'required|string|max:255',
        ]);
        $orderOffice= OrderOffice::findOrFail($id);

        $orderOffice->update($validated);

        return redirect()->route('office-forms.index')->withSuccess( 'from updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        $orderOffice= OrderOffice::findOrFail($id);
        $orderOffice->delete();

        return redirect()->back()->withSuccess( 'from deleted successfully.');
    }
}
