<?php

namespace App\Http\Controllers;

use App\Models\ApplyForm;
use Illuminate\Http\Request;

class ApplyFormController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $items = ApplyForm::latest()->get();

        return view('apply.index', compact('items'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('apply.create', compact('items'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $validation = $request->validate([
            'person_name' => 'required|string|max:255',
            'person_relative_name' => 'required|string|max:255',
            'mother_name' => 'required|string|max:255',
            'apply_person_name' => 'required|string|max:255',
            'relation_with_person' => 'required|string|max:255',
            'dob' => 'required|date_format:Y-m-d',
            'nid_no' => 'required|string|max:20|unique:your_table_name,nid_no',
        ]);

        ApplyForm::create($validation);

        return redirect()->back()->withSuccess('your application send successfully');

    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}