<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Division;
use App\Models\UnoInfo;
use Illuminate\Http\Request;

class UnoInfoController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $records = UnoInfo::latest()->get();

        return view('backEnd.uno.index', compact('records'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $division = Division::all();

        return view('backEnd.uno.create', compact('division'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $validatedData = $request->validate([
            'division_id' => 'required',
            'name' => 'required|string|max:255',
            'email' => 'required|string|email|max:255',
            'mobile' => 'required|string|max:20',
            'phone' => 'nullable|string|max:20',
            'designation' => 'required|string|max:255',
            'address' => 'required|string|max:255',
            'image' => 'nullable',
        ]);

        if ($request->hasFile('image')) {
            $image = $request->file('image');
            $ext = $image->getClientOriginalExtension();
            $fileName = time() . '.' . $ext;
            $path = public_path('images/uno/');
            $validatedData['image'] = 'images/uno/' . $fileName;

            $image->move($path, $fileName);
        }

        UnoInfo::create($validatedData);

        return redirect()->route('uno-information.index')->withSuccess( 'Record created successfully.');
    }

    /**
     * Display the specified resource.
     */
    public function show(UnoInfo $unoInfo)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(UnoInfo $unoInfo)
    {
        $division = Division::select('id', 'name', 'bn_name')->get();

        return view('backEnd.uno.edit', compact('unoInfo', 'division'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, UnoInfo $unoInfo)
    {

        $validatedData = $request->validate([
            'division_id' => 'required',
            'name' => 'required|string|max:255',
            'email' => 'required|string|email|max:255',
            'mobile' => 'required|string|max:20',
            'phone' => 'nullable|string|max:20',
            'designation' => 'required|string|max:255',
            'address' => 'required|string|max:255',
            'image' => 'nullable',
        ]);

        if ($request->hasFile('image')) {
            $image = $request->file('image');
            $ext = $image->getClientOriginalExtension();
            $fileName = time() . '.' . $ext;
            $path = public_path('images/uno/');
            $validatedData['image'] = 'images/uno/' . $fileName;

            if (!empty($unoInfo->image)) {
                $oldImagePath = public_path($unoInfo->image);
                if (file_exists($oldImagePath)) {
                    unlink($oldImagePath);
                }
            }

            $image->move($path, $fileName);
        }

        $unoInfo->update($validatedData);

        return redirect()->route('uno-information.index')->withSuccess('Record updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(UnoInfo $unoInfo)
    {
        $unoInfo->delete();

        return redirect()->back()->withSuccess('Record delete successfully.');
    }
}
