<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\DynamicContentSet;
use Illuminate\Http\Request;

class DynamicContentSetController extends Controller
{
    public function introductionTrastyBoard()
    {
        return view('backEnd.dynamic-content.bn_trasti_board');
    }

    public function introductionEngTrastyBoard()
    {
        return view('backEnd.dynamic-content.en_trasti_board');
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'bn_introduction_trasti_board' => 'nullable',
            'bn_trasti_board_workflow' => 'nullable',
            'bn_office_order' => 'nullable',
            'bn_all_form' => 'nullable',
            'form_fill' => 'nullable|file|mimes:png,jpg,jpeg,webp,gif,pdf|max:2048',
            'bn_introduction_title' => 'nullable',
            'bn_workFlow_title' => 'nullable',
            'bn_office_order_title' => 'nullable',
            'bn_all_form_title' => 'nullable',
            'bn_trasti_board_member' => 'nullable',

            'en_introduction_trasti_board' => 'nullable',
            'en_trasti_board_workflow' => 'nullable',
            'en_office_order' => 'nullable',
            'en_all_form' => 'nullable',
            'en_introduction_title' => 'nullable',
            'en_workFlow_title' => 'nullable',
            'en_office_order_title' => 'nullable',
            'en_all_form_title' => 'nullable',
            'en_trasti_board_member' => 'nullable',
        ]);

        if ($request->hasFile('form_fill')) {

            $file = $request->file('form_fill');
            $fileName = time() . '.' . $file->getClientOriginalExtension();
            $path = $file->move(public_path('images'), $fileName);

            $oldData = public_path('images/') . get_trasti_board('form_fill');

            if (!empty(get_trasti_board('form_fill'))) {
                if (file_exists($oldData)) {
                    unlink($oldData);
                }
            }

            $validated['form_fill'] = $fileName;
        }

        foreach ($validated as $k => $v) {
            DynamicContentSet::updateOrCreate(['key' => $k], ['value' => json_encode($v)]);
        }

        return redirect()->back();
    }
}
