<?php

namespace App\Http\Controllers\Admin;

use App\Enum\EnoType;
use App\Enum\StatusType;
use App\Http\Controllers\Controller;
use App\Models\ApplyForm;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class DashboardController extends Controller
{
    public function index(Request $request)
    {
        $user = Auth::user();

        $todayApplication = todayApplicationCount($user);

        $totalApplication = totalApplication($user);

        $incompleteApplication = incompleteApplication($user);

        $completeApplication = completeApplication($user);
        $currentMonthApplication = currentMonthApplication($user);

        $totalUser = User::select('id')->count();

        $monthlyApplication = ApplyForm::whereMonth('created_at', Carbon::now()->month)->whereYear('created_at', Carbon::now()->year)->select('id')->count();
        $query = ApplyForm::query()->whereDate('created_at', now()->toDateString())->latest();

        $application = applicationData($query,$user);

        return view('backEnd.dashboard.index', compact('application', 'monthlyApplication', 'totalUser', 'totalApplication', 'todayApplication', 'completeApplication', 'incompleteApplication', 'completeApplication', 'currentMonthApplication'));
    }

    public function editProfile()
    {
        return view('backEnd.profile.index');
    }

}
