<?php

use App\Enum\EnoType;
use App\Enum\StatusType;
use App\Models\ApplyForm;
use App\Models\DynamicContentSet;
use App\Models\User;
use Carbon\Carbon;

if (!function_exists('send_sms')) {
    function send_sms($phone, $send_message)
    {
        try {
            $to = $phone;
            $token = "106921215361729145736e64dc4fba7314b816daa37f4736782cc";
            $message = $send_message;
            $url = "https://api.bdbulksms.net/api.php?json";
            $data = array(
                'to' => "$to",
                'message' => "$message",
                'token' => "$token",
            );
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
            curl_setopt($ch, CURLOPT_ENCODING, '');
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            $smsresult = curl_exec($ch);

            if ($smsresult === false) {
                throw new Exception(curl_error($ch));
            }

            return $smsresult;
        } catch (Exception $e) {
            return 'Error: ' . $e->getMessage();
        }
    }
}

if (!function_exists('get_trasti_board')) {
    function get_trasti_board($key)
    {
        $data = DynamicContentSet::where('key', $key)->first();

        return json_decode($data?->value) ?? '';
    }
}


function generateReferenceNumber()
{
    return random_int(100000, 999999);
}

function containsBangla($text)
{
    return preg_match('/[\x{0980}-\x{09FF}]/u', $text);
}

function applicationData($query,$user)
{
    if ($user->uno_type == EnoType::DIVISIONUNO) {
        $query->where('division_id', $user->division_id);
    } else if ($user->uno_type == EnoType::UPOZILAUNO) {
        $query->where('upozila_id', $user->upozila_id);
    } else if ($user->uno_type == EnoType::DISTRICT) {
        $query->where('district_id', $user->district_id);
    } elseif ($user->uno_type != EnoType::ADMIN) {
        $query->where('user_id', $user->id);
    } else {
        $query;
    }

    return $query->get();
}

function userInfo($user)
{
    if ($user->uno_type == EnoType::DIVISIONUNO) {
        $info = User::with('division')->where('id', $user->id)->where('division_id', $user->division_id);
    } else if ($user->uno_type == EnoType::UPOZILAUNO) {
        $info = User::with('upozila')->where('id', $user->id)->where('upozila_id', $user->upozila_id);
    } else if ($user->uno_type == EnoType::DISTRICT) {
        $info = User::with('district')->where('id', $user->id)->where('district_id', $user->district_id);
    } else {
        $info = User::with('district')->where('id', $user->id);
    }

    return $info->first();

}

function todayApplicationCount($user)
{
    $applicationCount = ApplyForm::select('id');

    if ($user->uno_type == EnoType::DIVISIONUNO) {
        $applicationCount->where('division_id', $user->division_id)->whereDate('created_at', now()->toDateString());
    } else if ($user->uno_type == EnoType::UPOZILAUNO) {
        $applicationCount->where('upozila_id', $user->upozila_id)->whereDate('created_at', now()->toDateString());
    } else if ($user->uno_type == EnoType::DISTRICT) {
        $applicationCount->where('district_id', $user->district_id)->whereDate('created_at', now()->toDateString());
    } elseif ($user->uno_type != EnoType::ADMIN) {
        $applicationCount;
    }

    return $applicationCount->count();
}

function totalApplication($user)
{
    $applicationCount = ApplyForm::select('id');

    if ($user->uno_type == EnoType::DIVISIONUNO) {
        $applicationCount->where('division_id', $user->division_id);
    } else if ($user->uno_type == EnoType::UPOZILAUNO) {
        $applicationCount->where('upozila_id', $user->upozila_id);
    } else if ($user->uno_type == EnoType::DISTRICT) {
        $applicationCount->where('district_id', operator: $user->district_id);
    } elseif ($user->uno_type != EnoType::ADMIN) {
        $applicationCount;
    }

    return $applicationCount->count();
}

function incompleteApplication($user)
{
    $applicationCount = ApplyForm::select('id');

    if ($user->uno_type == EnoType::DIVISIONUNO) {
        $applicationCount->where('division_id', $user->division_id)->where('status', StatusType::PENDING);
    } else if ($user->uno_type == EnoType::UPOZILAUNO) {
        $applicationCount->where('upozila_id', $user->upozila_id)->where('status', StatusType::PENDING);
    } else if ($user->uno_type == EnoType::DISTRICT) {
        $applicationCount->where('district_id', $user->district_id)->where('status', StatusType::PENDING);
    } elseif ($user->uno_type != EnoType::ADMIN) {
        $applicationCount->where('district_id', $user->district_id)->where('status', StatusType::PENDING);
    } else {
        $applicationCount->where('status', StatusType::PENDING);
    }

    return $applicationCount->count();
}

function completeApplication($user)
{
    $applicationCount = ApplyForm::select('id');

    if ($user->uno_type == EnoType::DIVISIONUNO) {
        $applicationCount->where('division_id', $user->division_id)->where('status', StatusType::ACTIVE);
    } else if ($user->uno_type == EnoType::UPOZILAUNO) {
        $applicationCount->where('upozila_id', operator: $user->upozila_id)->where('status', StatusType::ACTIVE);
    } else if ($user->uno_type == EnoType::DISTRICT) {
        $applicationCount->where('district_id', $user->district_id)->where('status', StatusType::ACTIVE);
    } elseif ($user->uno_type != EnoType::ADMIN) {
        $applicationCount->where('status', StatusType::ACTIVE);
    } else {

        $applicationCount->where('status', StatusType::ACTIVE);
    }

    return $applicationCount->count();
}

function currentMonthApplication($user)
{
    $applicationCount = ApplyForm::select('id')->whereMonth('created_at', Carbon::now()->month);

    if ($user->uno_type == EnoType::DIVISIONUNO) {
        $applicationCount->where('division_id', $user->division_id);
    } else if ($user->uno_type == EnoType::UPOZILAUNO) {
        $applicationCount->where('upozila_id', operator: $user->upozila_id);
    } else if ($user->uno_type == EnoType::DISTRICT) {
        $applicationCount->where('district_id', $user->district_id);
    } elseif ($user->uno_type != EnoType::ADMIN) {
        $applicationCount;
    }

    return $applicationCount->count();
}
